/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.util.net.IdeHttpClientHelpers;
import com.intellij.util.net.ssl.CertificateManager;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubSettings;

@Deprecated
class GithubConnectionBuilder {
    @NotNull
    private final GithubAuthData myAuth;
    @NotNull
    private final String myApiURL;

    GithubConnectionBuilder(@NotNull GithubAuthData auth, @NotNull String apiURL) {
        if (auth == null) {
            GithubConnectionBuilder.$$$reportNull$$$0(0);
        }
        if (apiURL == null) {
            GithubConnectionBuilder.$$$reportNull$$$0(1);
        }
        this.myAuth = auth;
        this.myApiURL = apiURL;
    }

    @NotNull
    public CloseableHttpClient createClient() {
        HttpClientBuilder builder = HttpClients.custom();
        builder.setDefaultRequestConfig(this.createRequestConfig()).setDefaultConnectionConfig(this.createConnectionConfig()).setDefaultHeaders(this.createHeaders()).setSslcontext(CertificateManager.getInstance().getSslContext());
        this.setupCredentialsProvider(builder);
        CloseableHttpClient closeableHttpClient = builder.build();
        if (closeableHttpClient == null) {
            GithubConnectionBuilder.$$$reportNull$$$0(2);
        }
        return closeableHttpClient;
    }

    @NotNull
    private RequestConfig createRequestConfig() {
        RequestConfig.Builder builder = RequestConfig.custom();
        int timeout = GithubSettings.getInstance().getConnectionTimeout();
        builder.setConnectTimeout(timeout).setSocketTimeout(timeout);
        if (this.myAuth.isUseProxy()) {
            IdeHttpClientHelpers.ApacheHttpClient4.setProxyForUrlIfEnabled((RequestConfig.Builder)builder, (String)this.myApiURL);
        }
        RequestConfig requestConfig = builder.build();
        if (requestConfig == null) {
            GithubConnectionBuilder.$$$reportNull$$$0(3);
        }
        return requestConfig;
    }

    @NotNull
    private ConnectionConfig createConnectionConfig() {
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setCharset(Consts.UTF_8).build();
        if (connectionConfig == null) {
            GithubConnectionBuilder.$$$reportNull$$$0(4);
        }
        return connectionConfig;
    }

    @NotNull
    private CredentialsProvider setupCredentialsProvider(@NotNull HttpClientBuilder builder) {
        if (builder == null) {
            GithubConnectionBuilder.$$$reportNull$$$0(5);
        }
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        GithubAuthData.BasicAuth basicAuth = this.myAuth.getBasicAuth();
        if (basicAuth != null) {
            AuthScope authScope = this.getBasicAuthScope();
            provider.setCredentials(authScope, (Credentials)new UsernamePasswordCredentials(basicAuth.getLogin(), basicAuth.getPassword()));
            builder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveBasicAuthInterceptor(authScope));
        }
        builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        if (this.myAuth.isUseProxy()) {
            IdeHttpClientHelpers.ApacheHttpClient4.setProxyCredentialsForUrlIfEnabled((CredentialsProvider)provider, (String)this.myApiURL);
        }
        BasicCredentialsProvider basicCredentialsProvider = provider;
        if (basicCredentialsProvider == null) {
            GithubConnectionBuilder.$$$reportNull$$$0(6);
        }
        return basicCredentialsProvider;
    }

    @NotNull
    private AuthScope getBasicAuthScope() {
        AuthScope authScope;
        block3: {
            try {
                URIBuilder builder = new URIBuilder(this.myApiURL);
                authScope = new AuthScope(builder.getHost(), builder.getPort(), AuthScope.ANY_REALM, "Basic");
                if (authScope != null) break block3;
            }
            catch (URISyntaxException e) {
                AuthScope authScope2 = AuthScope.ANY;
                if (authScope2 == null) {
                    GithubConnectionBuilder.$$$reportNull$$$0(8);
                }
                return authScope2;
            }
            GithubConnectionBuilder.$$$reportNull$$$0(7);
        }
        return authScope;
    }

    @NotNull
    private Collection<? extends Header> createHeaders() {
        GithubAuthData.BasicAuth basicAuth;
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        GithubAuthData.TokenAuth tokenAuth = this.myAuth.getTokenAuth();
        if (tokenAuth != null) {
            headers.add(new BasicHeader("Authorization", "token " + tokenAuth.getToken()));
        }
        if ((basicAuth = this.myAuth.getBasicAuth()) != null && basicAuth.getCode() != null) {
            headers.add(new BasicHeader("X-GitHub-OTP", basicAuth.getCode()));
        }
        ArrayList<BasicHeader> arrayList = headers;
        if (arrayList == null) {
            GithubConnectionBuilder.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "auth";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apiURL";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/api/GithubConnectionBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/api/GithubConnectionBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createClient";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequestConfig";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createConnectionConfig";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setupCredentialsProvider";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBasicAuthScope";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeaders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupCredentialsProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PreemptiveBasicAuthInterceptor
    implements HttpRequestInterceptor {
        @NotNull
        private final AuthScope myBasicAuthScope;

        PreemptiveBasicAuthInterceptor(@NotNull AuthScope basicAuthScope) {
            if (basicAuthScope == null) {
                PreemptiveBasicAuthInterceptor.$$$reportNull$$$0(0);
            }
            this.myBasicAuthScope = basicAuthScope;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException {
            CredentialsProvider provider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
            Credentials credentials = provider.getCredentials(this.myBasicAuthScope);
            if (credentials != null) {
                request.addHeader(new BasicScheme(Consts.UTF_8).authenticate(credentials, request, context));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basicAuthScope", "org/jetbrains/plugins/github/api/GithubConnectionBuilder$PreemptiveBasicAuthInterceptor", "<init>"));
        }
    }
}

