/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.joni.BitStatus;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.joni.SCStackEntry;
import org.joni.StackEntry;
import org.joni.constants.StackType;

abstract class StackMachine
extends Matcher
implements StackType {
    protected static final int INVALID_INDEX = -1;
    protected StackEntry[] stack;
    protected int stk;
    protected final int[] repeatStk;
    protected final int memStartStk;
    protected final int memEndStk;
    protected byte[] stateCheckBuff;
    protected int stateCheckBuffSize;
    static final ThreadLocal<WeakReference<StackEntry[]>> stacks = new ThreadLocal();
    private static final int STATE_CHECK_BUFF_MALLOC_THRESHOLD_SIZE = 16;

    protected StackMachine(Regex regex, Region region, byte[] bytes, int p, int end) {
        super(regex, region, bytes, p, end);
        this.stack = regex.requireStack ? StackMachine.fetchStack() : null;
        int n = regex.numRepeat + (regex.numMem + 1 << 1);
        this.memStartStk = regex.numRepeat;
        this.memEndStk = this.memStartStk + regex.numMem + 1;
        this.repeatStk = n > 0 ? new int[n] : null;
    }

    protected final void stackInit() {
        if (this.stack != null) {
            this.pushEnsured(1, this.regex.codeLength - 1);
        }
        if (this.repeatStk != null) {
            for (int i = 0; i <= this.regex.numMem; ++i) {
                this.repeatStk[i + this.memEndStk] = -1;
                this.repeatStk[i + this.memStartStk] = -1;
            }
        }
    }

    private static StackEntry[] allocateStack() {
        StackEntry[] stack = new StackEntry[64];
        stack[0] = new StackEntry();
        return stack;
    }

    private void doubleStack() {
        StackEntry[] newStack = new StackEntry[this.stack.length << 1];
        System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
        this.stack = newStack;
    }

    private static StackEntry[] fetchStack() {
        StackEntry[] stack;
        WeakReference<StackEntry[]> ref = stacks.get();
        if (ref == null) {
            stack = StackMachine.allocateStack();
            stacks.set(new WeakReference<StackEntry[]>(stack));
        } else {
            stack = (StackEntry[])ref.get();
            if (stack == null) {
                stack = StackMachine.allocateStack();
                stacks.set(new WeakReference<StackEntry[]>(stack));
            }
        }
        return stack;
    }

    private final StackEntry ensure1() {
        StackEntry e;
        if (this.stk >= this.stack.length) {
            this.doubleStack();
        }
        if ((e = this.stack[this.stk]) == null) {
            this.stack[this.stk] = e = new StackEntry();
        }
        return e;
    }

    private final void pushType(int type) {
        this.ensure1().type = type;
        ++this.stk;
    }

    private int stateCheckPos(int s, int snum) {
        return (s - this.str) * this.regex.numCombExpCheck + (snum - 1);
    }

    protected final boolean stateCheckVal(int s, int snum) {
        if (this.stateCheckBuff != null) {
            int x = this.stateCheckPos(s, snum);
            return (this.stateCheckBuff[x / 8] & 1 << x % 8) != 0;
        }
        return false;
    }

    private void stateCheckMark() {
        StackEntry e = this.stack[this.stk];
        int x = this.stateCheckPos(e.getStatePStr(), ((SCStackEntry)e).getStateCheck());
        int n = x / 8;
        this.stateCheckBuff[n] = (byte)(this.stateCheckBuff[n] | 1 << x % 8);
    }

    @Override
    protected final void stateCheckBuffInit(int strLength, int offset, int stateNum) {
        if (stateNum > 0 && strLength >= 7) {
            int size = (strLength + 1) * stateNum + 7 >>> 3;
            offset = offset * stateNum >>> 3;
            if (size > 0 && offset < size && size < 16384) {
                this.stateCheckBuff = size >= 16 ? new byte[size] : new byte[size];
                Arrays.fill(this.stateCheckBuff, offset, size - offset, (byte)0);
                this.stateCheckBuffSize = size;
            } else {
                this.stateCheckBuff = null;
                this.stateCheckBuffSize = 0;
            }
        } else {
            this.stateCheckBuff = null;
            this.stateCheckBuffSize = 0;
        }
    }

    @Override
    protected final void stateCheckBuffClear() {
        this.stateCheckBuff = null;
        this.stateCheckBuffSize = 0;
    }

    private void push(int type, int pat, int s, int prev, int pkeep) {
        StackEntry e = this.ensure1();
        e.type = type;
        e.setStatePCode(pat);
        e.setStatePStr(s);
        e.setStatePStrPrev(prev);
        e.setPKeep(pkeep);
        ++this.stk;
    }

    private final void pushEnsured(int type, int pat) {
        StackEntry e = this.stack[this.stk];
        e.type = type;
        e.setStatePCode(pat);
        ++this.stk;
    }

    protected final void pushAltWithStateCheck(int pat, int s, int sprev, int snum, int pkeep) {
        StackEntry e = this.ensure1();
        e.type = 1;
        e.setStatePCode(pat);
        e.setStatePStr(s);
        e.setStatePStrPrev(sprev);
        e.setPKeep(pkeep);
        ++this.stk;
    }

    protected final void pushStateCheck(int s, int snum) {
        if (this.stateCheckBuff != null) {
            StackEntry e = this.ensure1();
            e.type = 4096;
            e.setStatePStr(s);
            ((SCStackEntry)e).setStateCheck(snum);
            ++this.stk;
        }
    }

    protected final void pushAlt(int pat, int s, int prev, int pkeep) {
        this.push(1, pat, s, prev, pkeep);
    }

    protected final void pushPos(int s, int prev, int pkeep) {
        this.push(1280, -1, s, prev, pkeep);
    }

    protected final void pushPosNot(int pat, int s, int prev, int pkeep) {
        this.push(3, pat, s, prev, pkeep);
    }

    protected final void pushStopBT() {
        this.pushType(1536);
    }

    protected final void pushLookBehindNot(int pat, int s, int sprev, int pkeep) {
        this.push(2, pat, s, sprev, pkeep);
    }

    protected final void pushRepeat(int id, int pat) {
        StackEntry e = this.ensure1();
        e.type = 1792;
        e.setRepeatNum(id);
        e.setRepeatPCode(pat);
        e.setRepeatCount(0);
        ++this.stk;
    }

    protected final void pushRepeatInc(int sindex) {
        StackEntry e = this.ensure1();
        e.type = 768;
        e.setSi(sindex);
        ++this.stk;
    }

    protected final void pushMemStart(int mnum, int s) {
        StackEntry e = this.ensure1();
        e.type = 256;
        e.setMemNum(mnum);
        e.setMemPstr(s);
        e.setMemStart(this.repeatStk[this.memStartStk + mnum]);
        e.setMemEnd(this.repeatStk[this.memEndStk + mnum]);
        this.repeatStk[this.memStartStk + mnum] = this.stk++;
        this.repeatStk[this.memEndStk + mnum] = -1;
    }

    protected final void pushMemEnd(int mnum, int s) {
        StackEntry e = this.ensure1();
        e.type = 33280;
        e.setMemNum(mnum);
        e.setMemPstr(s);
        e.setMemStart(this.repeatStk[this.memStartStk + mnum]);
        e.setMemEnd(this.repeatStk[this.memEndStk + mnum]);
        this.repeatStk[this.memEndStk + mnum] = this.stk++;
    }

    protected final void pushMemEndMark(int mnum) {
        StackEntry e = this.ensure1();
        e.type = 33792;
        e.setMemNum(mnum);
        ++this.stk;
    }

    protected final int getMemStart(int mnum) {
        int level = 0;
        int stkp = this.stk;
        while (stkp > 0) {
            StackEntry e = this.stack[--stkp];
            if ((e.type & 0x8000) != 0 && e.getMemNum() == mnum) {
                ++level;
                continue;
            }
            if (e.type != 256 || e.getMemNum() != mnum) continue;
            if (level == 0) break;
            --level;
        }
        return stkp;
    }

    protected final void pushNullCheckStart(int cnum, int s) {
        StackEntry e = this.ensure1();
        e.type = 12288;
        e.setNullCheckNum(cnum);
        e.setNullCheckPStr(s);
        ++this.stk;
    }

    protected final void pushNullCheckEnd(int cnum) {
        StackEntry e = this.ensure1();
        e.type = 20480;
        e.setNullCheckNum(cnum);
        ++this.stk;
    }

    protected final void pushCallFrame(int pat) {
        StackEntry e = this.ensure1();
        e.type = 2048;
        e.setCallFrameRetAddr(pat);
        ++this.stk;
    }

    protected final void pushReturn() {
        StackEntry e = this.ensure1();
        e.type = 2304;
        ++this.stk;
    }

    protected final void pushAbsent() {
        StackEntry e = this.ensure1();
        e.type = 3072;
        ++this.stk;
    }

    protected final void pushAbsentPos(int start, int end) {
        StackEntry e = this.ensure1();
        e.type = 2816;
        e.setAbsentStr(start);
        e.setAbsentEndStr(end);
        ++this.stk;
    }

    protected final void popOne() {
        --this.stk;
    }

    protected final StackEntry pop() {
        switch (this.regex.stackPopLevel) {
            case 0: {
                return this.popFree();
            }
            case 1: {
                return this.popMemStart();
            }
        }
        return this.popDefault();
    }

    private StackEntry popFree() {
        StackEntry e;
        do {
            e = this.stack[--this.stk];
        } while ((e.type & 0xFF) == 0);
        return e;
    }

    private StackEntry popMemStart() {
        while (true) {
            StackEntry e = this.stack[--this.stk];
            if ((e.type & 0xFF) != 0) {
                return e;
            }
            if (e.type != 256) continue;
            this.repeatStk[this.memStartStk + e.getMemNum()] = e.getMemStart();
            this.repeatStk[this.memEndStk + e.getMemNum()] = e.getMemEnd();
        }
    }

    private void popRewrite(StackEntry e) {
        if (e.type == 256) {
            this.repeatStk[this.memStartStk + e.getMemNum()] = e.getMemStart();
            this.repeatStk[this.memEndStk + e.getMemNum()] = e.getMemEnd();
        } else if (e.type == 768) {
            this.stack[e.getSi()].decreaseRepeatCount();
        } else if (e.type == 33280) {
            this.repeatStk[this.memStartStk + e.getMemNum()] = e.getMemStart();
            this.repeatStk[this.memEndStk + e.getMemNum()] = e.getMemEnd();
        }
    }

    private StackEntry popDefault() {
        while (true) {
            StackEntry e = this.stack[--this.stk];
            if ((e.type & 0xFF) != 0) {
                return e;
            }
            this.popRewrite(e);
        }
    }

    protected final void popTilPosNot() {
        while (true) {
            StackEntry e = this.stack[--this.stk];
            if (e.type == 3) break;
            this.popRewrite(e);
        }
    }

    protected final void popTilLookBehindNot() {
        while (true) {
            StackEntry e = this.stack[--this.stk];
            if (e.type == 2) break;
            this.popRewrite(e);
        }
    }

    protected final void popTilAbsent() {
        while (true) {
            StackEntry e = this.stack[--this.stk];
            if (e.type == 3072) break;
            this.popRewrite(e);
        }
    }

    protected final int posEnd() {
        int k = this.stk;
        while (true) {
            StackEntry e = this.stack[--k];
            if ((e.type & 0x10FF) != 0) {
                e.type = 2560;
                continue;
            }
            if (e.type == 1280) break;
        }
        e.type = 2560;
        return k;
    }

    protected final void stopBtEnd() {
        int k = this.stk;
        while (true) {
            StackEntry e = this.stack[--k];
            if ((e.type & 0x10FF) != 0) {
                e.type = 2560;
                continue;
            }
            if (e.type == 1536) break;
        }
        e.type = 2560;
    }

    protected final int nullCheck(int id, int s) {
        StackEntry e;
        int k = this.stk;
        do {
            e = this.stack[--k];
        } while (e.type != 12288 || e.getNullCheckNum() != id);
        return e.getNullCheckPStr() == s ? 1 : 0;
    }

    protected final int nullCheckRec(int id, int s) {
        int level = 0;
        int k = this.stk;
        while (true) {
            StackEntry e = this.stack[--k];
            if (e.type == 12288) {
                if (e.getNullCheckNum() != id) continue;
                if (level == 0) {
                    return e.getNullCheckPStr() == s ? 1 : 0;
                }
                --level;
                continue;
            }
            if (e.type != 20480) continue;
            ++level;
        }
    }

    protected final int nullCheckMemSt(int id, int s) {
        int isNull;
        StackEntry e;
        int k = this.stk;
        do {
            e = this.stack[--k];
        } while (e.type != 12288 || e.getNullCheckNum() != id);
        if (e.getNullCheckPStr() != s) {
            isNull = 0;
        } else {
            isNull = 1;
            while (k < this.stk) {
                e = this.stack[k++];
                if (e.type != 256) continue;
                if (e.getMemEnd() == -1) {
                    isNull = 0;
                    break;
                }
                int endp = BitStatus.bsAt(this.regex.btMemEnd, e.getMemNum()) ? this.stack[e.getMemEnd()].getMemPStr() : e.getMemEnd();
                if (this.stack[e.getMemStart()].getMemPStr() != endp) {
                    isNull = 0;
                    break;
                }
                if (endp == s) continue;
                isNull = -1;
            }
        }
        return isNull;
    }

    protected final int nullCheckMemStRec(int id, int s) {
        int isNull;
        int level = 0;
        int k = this.stk;
        block0: while (true) {
            StackEntry e = this.stack[--k];
            if (e.type == 12288) {
                if (e.getNullCheckNum() != id) continue;
                if (level == 0) {
                    if (e.getNullCheckPStr() != s) {
                        isNull = 0;
                        break;
                    }
                    isNull = 1;
                    while (k < this.stk) {
                        if (e.type == 256) {
                            if (e.getMemEnd() == -1) {
                                isNull = 0;
                                break block0;
                            }
                            int endp = BitStatus.bsAt(this.regex.btMemEnd, e.getMemNum()) ? this.stack[e.getMemEnd()].getMemPStr() : e.getMemEnd();
                            if (this.stack[e.getMemStart()].getMemPStr() != endp) {
                                isNull = 0;
                                break block0;
                            }
                            if (endp != s) {
                                isNull = -1;
                            }
                        }
                        e = this.stack[++k];
                    }
                    break;
                }
                --level;
                continue;
            }
            if (e.type != 20480 || e.getNullCheckNum() != id) continue;
            ++level;
        }
        return isNull;
    }

    protected final int getRepeat(int id) {
        int level = 0;
        int k = this.stk;
        while (true) {
            StackEntry e = this.stack[--k];
            if (e.type == 1792) {
                if (level != 0 || e.getRepeatNum() != id) continue;
                return k;
            }
            if (e.type == 2048) {
                --level;
                continue;
            }
            if (e.type != 2304) continue;
            ++level;
        }
    }

    protected final int sreturn() {
        int level = 0;
        int k = this.stk;
        while (true) {
            StackEntry e = this.stack[--k];
            if (e.type == 2048) {
                if (level == 0) {
                    return e.getCallFrameRetAddr();
                }
                --level;
                continue;
            }
            if (e.type != 2304) continue;
            ++level;
        }
    }
}

