/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlLineMarkerProvider
extends LineMarkerProviderDescriptor {
    private final DaemonCodeAnalyzerSettings myDaemonSettings;
    private final EditorColorsManager myColorsManager;

    public SqlLineMarkerProvider(DaemonCodeAnalyzerSettings daemonSettings, EditorColorsManager colorsManager) {
        this.myDaemonSettings = daemonSettings;
        this.myColorsManager = colorsManager;
    }

    @Nullable
    public String getName() {
        return "SQL line markers";
    }

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (this.myDaemonSettings.SHOW_METHOD_SEPARATORS && element2.getFirstChild() == null) {
            JBIterable parents = SyntaxTraverser.psiApi().parents((Object)element2);
            PsiElement p2 = element2.getParent();
            if (p2 instanceof SqlProcedureDefinitionImpl && !(p2 instanceof SqlStatement) || parents.filter(SqlStatement.class).single() != null) {
                boolean addSeparator = false;
                for (PsiElement parent2 : parents) {
                    int newLines = -1;
                    if (parent2 instanceof SqlStatement) {
                        newLines = this.countNewLinesToPrev(parent2, (Condition<PsiElement>)((Condition)o -> o instanceof SqlStatement));
                    } else if (parent2 instanceof SqlProcedureDefinitionImpl) {
                        newLines = this.countNewLinesToPrev(parent2, (Condition<PsiElement>)((Condition)o -> o instanceof SqlDefinition));
                    }
                    if (newLines > 1) {
                        addSeparator = true;
                    }
                    if (newLines == -1 && parent2.getPrevSibling() == null) continue;
                    break;
                }
                if (addSeparator) {
                    LineMarkerInfo info = new LineMarkerInfo(element2, element2.getTextRange(), null, 11, (Function)FunctionUtil.nullConstant(), null, GutterIconRenderer.Alignment.RIGHT);
                    info.separatorColor = this.myColorsManager.getGlobalScheme().getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
                    info.separatorPlacement = SeparatorPlacement.TOP;
                    return info;
                }
            }
        }
        return null;
    }

    public Integer countNewLinesToPrev(PsiElement parent2, Condition<PsiElement> isAcceptable) {
        return (Integer)SqlImplUtil.revSiblings(parent2).skip(1).takeWhile(Conditions.not(isAcceptable)).filter(o -> o instanceof PsiWhiteSpace || o instanceof PsiComment).reduce((Object)0, (result2, o) -> result2 + StringUtil.countNewLines((CharSequence)o.getText()));
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result2) {
        if (elements == null) {
            SqlLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlLineMarkerProvider.$$$reportNull$$$0(2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/editor/SqlLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

