/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.introspector;

import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.oracle.introspector.OraIntroQueries;
import com.intellij.database.dialects.oracle.introspector.PortionType;
import com.intellij.database.dialects.oracle.model.OraCatalogObject;
import com.intellij.database.dialects.oracle.model.OraModArgument;
import com.intellij.database.dialects.oracle.model.OraModCluster;
import com.intellij.database.dialects.oracle.model.OraModConstraint;
import com.intellij.database.dialects.oracle.model.OraModLikeTable;
import com.intellij.database.dialects.oracle.model.OraModMatView;
import com.intellij.database.dialects.oracle.model.OraModModule;
import com.intellij.database.dialects.oracle.model.OraModObjectType;
import com.intellij.database.dialects.oracle.model.OraModPackage;
import com.intellij.database.dialects.oracle.model.OraModRoot;
import com.intellij.database.dialects.oracle.model.OraModRoutine;
import com.intellij.database.dialects.oracle.model.OraModSchema;
import com.intellij.database.dialects.oracle.model.OraModSchemaObject;
import com.intellij.database.dialects.oracle.model.OraModSourceAware;
import com.intellij.database.dialects.oracle.model.OraModStoredSchemaObject;
import com.intellij.database.dialects.oracle.model.OraModSynonym;
import com.intellij.database.dialects.oracle.model.OraModTable;
import com.intellij.database.dialects.oracle.model.OraModTrigger;
import com.intellij.database.dialects.oracle.model.OraModView;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.SingletonFamily;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import gnu.trove.TLongHashSet;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u00ca\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0002\u001a\u001a\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002\u001a\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u0004H\u0002\u001a \u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0*2\u0006\u0010\"\u001a\u00020#2\u0006\u0010,\u001a\u00020\u0004H\u0002\u001aN\u0010-\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\u00042\u0006\u00104\u001a\u00020\u00072\b\u00105\u001a\u0004\u0018\u00010\u00042\b\u00106\u001a\u0004\u0018\u00010\u00042\u0006\u00107\u001a\u00020\u0004H\u0002\u001aL\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020.2\b\u0010;\u001a\u0004\u0018\u00010\u00042\b\u0010<\u001a\u0004\u0018\u00010\u00042\b\u0010=\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010>\u001a\u00020\u00052\b\b\u0002\u0010?\u001a\u00020\u00052\b\b\u0002\u0010@\u001a\u00020\u0007H\u0002\u001a\u001e\u0010A\u001a\u00020\u00162\f\u0010B\u001a\b\u0012\u0004\u0012\u00020D0C2\u0006\u0010E\u001a\u00020FH\u0002\u001a\u0010\u0010G\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0004H\u0003\u001a\u0016\u0010I\u001a\u0004\u0018\u00010J*\u00020K2\u0006\u0010H\u001a\u00020\u0004H\u0002\u001a\u0016\u0010L\u001a\u0004\u0018\u00010M*\u00020#2\u0006\u0010H\u001a\u00020\u0004H\u0002\u001a\u0016\u0010N\u001a\u0004\u0018\u00010 *\u00020.2\u0006\u0010O\u001a\u00020\u0004H\u0002\u001a\u0016\u0010P\u001a\u0004\u0018\u00010Q*\u00020#2\u0006\u0010H\u001a\u00020\u0004H\u0002\u001a\u0016\u0010R\u001a\u0004\u0018\u00010S*\u00020#2\u0006\u0010T\u001a\u00020\u0004H\u0002\u001a \u0010U\u001a\u00020\u0016*\u00020+2\b\u0010V\u001a\u0004\u0018\u00010W2\b\u0010X\u001a\u0004\u0018\u00010WH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"AUTO_NOT_NULL_CHECK_PATTERN", "Lkotlin/text/Regex;", "DATA_TYPE_STAR_SIZE", "", "", "", "DELIMITER", "", "EXPLICIT_UNIT_DATA_TYPES", "", "INDEX_EXPRESSION_STUB_PATTERN", "NATIVE_TRIGGER_DEFINITION_PATTERN", "SEQUENCE_SURROGATE_NAME_PATTERN", "SIMPLE_DATA_TYPES", "SIMPLE_QUOTED_NAME_PATTERN", "SURROGATE_NAME_PATTERN", "SYSTEM_SCHEMAS", "Ljava/util/TreeSet;", "applicablePortionTypeFor", "Lcom/intellij/database/dialects/oracle/introspector/PortionType;", "n", "applyStoredProgramSources", "", "obj", "Lcom/intellij/database/dialects/oracle/model/OraModSourceAware;", "text", "applyViewSources", "view", "Lcom/intellij/database/model/basic/BasicModSourceAware;", "canCheckOutdated", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "dropUnexistentObjectsInSchema", "schema", "Lcom/intellij/database/dialects/oracle/model/OraModSchema;", "identifiers", "Lgnu/trove/TLongHashSet;", "getObjectKindByOracleTypeName", "Lcom/intellij/database/model/ObjectKind;", "oracleTypeName", "majorFamilyOf", "Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "Lcom/intellij/database/dialects/oracle/model/OraModSchemaObject;", "code", "makeArgument", "Lcom/intellij/database/model/basic/BasicSchema;", "routine", "Lcom/intellij/database/dialects/oracle/model/OraModRoutine;", "position", "", "argName", "argDirection", "dataTypeSchemaName", "dataTypePackageName", "dataTypeSpec", "makeDataType", "Lcom/intellij/database/model/DataType;", "thisSchema", "typeSchemaName", "typePackageName", "typeName", "precision", "scale", "unitsCode", "processSynonyms", "ss", "", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries$OneSynonym;", "root", "Lcom/intellij/database/dialects/oracle/model/OraModRoot;", "unquoteNameIfPossible", "name", "findModConstraint", "Lcom/intellij/database/dialects/oracle/model/OraModConstraint;", "Lcom/intellij/database/dialects/oracle/model/OraTable;", "findModuleByName", "Lcom/intellij/database/dialects/oracle/model/OraModModule;", "findOracleObjectByStringTypeAndName", "oracleTypeAndName", "findTableOrViewByName", "Lcom/intellij/database/dialects/oracle/model/OraModLikeTable;", "findTrigger", "Lcom/intellij/database/dialects/oracle/model/OraModTrigger;", "triggerName", "setCreatedAndModifiedTimestamps", "createdTimestamp", "Ljava/util/Date;", "modifiedTimestamp", "intellij.database.dialects"})
@JvmName(name="OraIntrospectorFunctions")
public final class OraIntrospectorFunctions {
    private static final TreeSet<String> SYSTEM_SCHEMAS = SetsKt.sortedSetOf((Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE), (Object[])new String[]{"SYS", "SYSTEM", "CTXSYS"});
    private static final Set<String> SIMPLE_DATA_TYPES = SetsKt.setOf((Object[])new String[]{"INTEGER", "BINARY_INTEGER", "BINARY_FLOAT", "BINARY_DOUBLE", "DATE", "TIME", "ROWID", "UROWID", "CLOB", "BLOB", "LONG", "LONG RAW", "BFILE"});
    private static final Set<String> EXPLICIT_UNIT_DATA_TYPES = SetsKt.setOf((Object[])new String[]{"CHAR", "VARCHAR", "VARCHAR2"});
    private static final Map<String, Integer> DATA_TYPE_STAR_SIZE = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"NUMBER", (Object)38), TuplesKt.to((Object)"FLOAT", (Object)126)});
    private static final Regex NATIVE_TRIGGER_DEFINITION_PATTERN;
    private static final Regex SIMPLE_QUOTED_NAME_PATTERN;
    private static final Regex AUTO_NOT_NULL_CHECK_PATTERN;
    private static final Regex SURROGATE_NAME_PATTERN;
    private static final Regex INDEX_EXPRESSION_STUB_PATTERN;
    private static final Regex SEQUENCE_SURROGATE_NAME_PATTERN;
    public static final char DELIMITER = '\uffff';

    private static final PortionType applicablePortionTypeFor(int n) {
        return n <= 1 ? PortionType.ONE : (n <= PortionType.SMALL.getSize() ? PortionType.SMALL : (n <= PortionType.NORMAL.getSize() ? PortionType.NORMAL : PortionType.ALL));
    }

    private static final ModNamingIdentifyingFamily<? extends OraModSchemaObject> majorFamilyOf(OraModSchema schema, String code) {
        switch (code) {
            case "TA": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getTables();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.tables");
                return namingIdentifyingFamily;
            }
            case "CL": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getClusters();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.clusters");
                return namingIdentifyingFamily;
            }
            case "VI": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getViews();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.views");
                return namingIdentifyingFamily;
            }
            case "SY": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getSynonyms();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.synonyms");
                return namingIdentifyingFamily;
            }
            case "SE": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getSequences();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.sequences");
                return namingIdentifyingFamily;
            }
            case "PR": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getRoutines();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.routines");
                return namingIdentifyingFamily;
            }
            case "FU": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getRoutines();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.routines");
                return namingIdentifyingFamily;
            }
            case "PA": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getPackages();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.packages");
                return namingIdentifyingFamily;
            }
            case "MA": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getMatViews();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.matViews");
                return namingIdentifyingFamily;
            }
            case "YB": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getObjectTypes();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.objectTypes");
                return namingIdentifyingFamily;
            }
            case "YC": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getCollectionTypes();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.collectionTypes");
                return namingIdentifyingFamily;
            }
        }
        throw (Throwable)new IllegalArgumentException("Unknown object code: " + code);
    }

    private static final void processSynonyms(List<OraIntroQueries.OneSynonym> ss, OraModRoot root2) {
        Set affectedSchemas = new HashSet();
        for (OraIntroQueries.OneSynonym s : ss) {
            OraModSchema schema;
            OraModSynonym synonym;
            if ((OraModSchema)root2.getSchemas().get(s.synonym_schema_name) == null) {
                continue;
            }
            OraModSynonym oraModSynonym = synonym = (OraModSynonym)schema.getSynonyms().renew(s.synonym_id, s.synonym_name);
            Intrinsics.checkExpressionValueIsNotNull((Object)oraModSynonym, (String)"synonym");
            oraModSynonym.setCreatedTimestamp(s.created_timestamp);
            synonym.setModifiedTimestamp(s.modified_timestamp);
            synonym.setTargetSchemaName(s.origin_schema_name);
            synonym.setTargetObjectName(s.origin_object_name);
            affectedSchemas.add(schema);
        }
        for (OraModSchema schema : affectedSchemas) {
            schema.getSynonyms().sort();
        }
    }

    private static final void dropUnexistentObjectsInSchema(OraModSchema schema, TLongHashSet identifiers) {
        NamingIdentifyingFamily namingIdentifyingFamily = schema.getSequences();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.sequences");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily2 = schema.getClusters();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily2, (String)"schema.clusters");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily2)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily3 = schema.getTables();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily3, (String)"schema.tables");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily3)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily4 = schema.getMatViews();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily4, (String)"schema.matViews");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily4)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily5 = schema.getViews();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily5, (String)"schema.views");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily5)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily6 = schema.getPackages();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily6, (String)"schema.packages");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily6)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily7 = schema.getObjectTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily7, (String)"schema.objectTypes");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily7)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily8 = schema.getCollectionTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily8, (String)"schema.collectionTypes");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily8)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily9 = schema.getRoutines();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily9, (String)"schema.routines");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily9)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily10 = schema.getSynonyms();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily10, (String)"schema.synonyms");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily10)), identifiers);
        Iterator iterator = schema.getClusters().iterator();
        while (iterator.hasNext()) {
            OraModCluster cluster;
            OraModCluster oraModCluster = cluster = (OraModCluster)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraModCluster, (String)"cluster");
            SingletonFamily singletonFamily = oraModCluster.getIndices();
            Intrinsics.checkExpressionValueIsNotNull((Object)singletonFamily, (String)"cluster.indices");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModSingletonFamily<? extends BasicModIdentifiedElement>)singletonFamily, identifiers);
        }
        for (OraModStoredSchemaObject table : schema.getTables()) {
            OraModTable oraModTable = table;
            Intrinsics.checkExpressionValueIsNotNull((Object)oraModTable, (String)"table");
            NamingIdentifyingFamily namingIdentifyingFamily11 = oraModTable.getIndices();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily11, (String)"table.indices");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily11)), identifiers);
            NamingIdentifyingFamily namingIdentifyingFamily12 = table.getTriggers();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily12, (String)"table.triggers");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily12)), identifiers);
        }
        for (OraModStoredSchemaObject table : schema.getMatViews()) {
        }
        iterator = schema.getViews().iterator();
        while (iterator.hasNext()) {
            OraModView view;
            OraModView oraModView = view = (OraModView)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraModView, (String)"view");
            NamingIdentifyingFamily namingIdentifyingFamily13 = oraModView.getTriggers();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily13, (String)"view.triggers");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily13)), identifiers);
        }
        iterator = schema.getPackages().iterator();
        while (iterator.hasNext()) {
            OraModPackage pack2;
            OraModPackage oraModPackage = pack2 = (OraModPackage)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraModPackage, (String)"pack");
            SingletonFamily singletonFamily = oraModPackage.getBodies();
            Intrinsics.checkExpressionValueIsNotNull((Object)singletonFamily, (String)"pack.bodies");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModSingletonFamily<? extends BasicModIdentifiedElement>)singletonFamily, identifiers);
        }
        iterator = schema.getObjectTypes().iterator();
        while (iterator.hasNext()) {
            OraModObjectType ot;
            OraModObjectType oraModObjectType = ot = (OraModObjectType)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraModObjectType, (String)"ot");
            SingletonFamily singletonFamily = oraModObjectType.getBodies();
            Intrinsics.checkExpressionValueIsNotNull((Object)singletonFamily, (String)"ot.bodies");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModSingletonFamily<? extends BasicModIdentifiedElement>)singletonFamily, identifiers);
        }
    }

    private static final void setCreatedAndModifiedTimestamps(@NotNull OraModSchemaObject $receiver, Date createdTimestamp, Date modifiedTimestamp) {
        $receiver.setCreatedTimestamp(createdTimestamp);
        $receiver.setModifiedTimestamp(modifiedTimestamp);
    }

    private static final OraModLikeTable findTableOrViewByName(@NotNull OraModSchema $receiver, String name) {
        OraModLikeTable oraModLikeTable;
        OraModLikeTable oraModLikeTable2 = (OraModLikeTable)$receiver.getTables().get(name);
        if (oraModLikeTable2 == null) {
            oraModLikeTable2 = oraModLikeTable = (OraModLikeTable)$receiver.getMatViews().get(name);
        }
        if (oraModLikeTable2 == null) {
            oraModLikeTable = (OraModLikeTable)$receiver.getViews().get(name);
        }
        return oraModLikeTable;
    }

    private static final OraModModule findModuleByName(@NotNull OraModSchema $receiver, String name) {
        OraModModule oraModModule = (OraModModule)$receiver.getObjectTypes().get(name);
        if (oraModModule == null) {
            oraModModule = (OraModModule)$receiver.getPackages().get(name);
        }
        return oraModModule;
    }

    private static final OraModConstraint findModConstraint(@NotNull OraTable $receiver, String name) {
        OraModConstraint oraModConstraint;
        OraModConstraint oraModConstraint2 = (OraModConstraint)$receiver.getKeys().get(name);
        if (oraModConstraint2 == null) {
            oraModConstraint2 = oraModConstraint = (OraModConstraint)$receiver.getForeignKeys().get(name);
        }
        if (oraModConstraint2 == null) {
            oraModConstraint = (OraModConstraint)$receiver.getChecks().get(name);
        }
        return oraModConstraint;
    }

    private static final OraModTrigger findTrigger(@NotNull OraModSchema $receiver, String triggerName) {
        OraModTrigger trigger;
        Iterator iterator = $receiver.getTables().iterator();
        while (iterator.hasNext()) {
            OraModTable table;
            OraModTable oraModTable = table = (OraModTable)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraModTable, (String)"table");
            trigger = (OraModTrigger)oraModTable.getTriggers().get(triggerName);
            if (trigger == null) continue;
            return trigger;
        }
        for (OraModLikeTable view : $receiver.getViews()) {
            OraModView oraModView = view;
            Intrinsics.checkExpressionValueIsNotNull((Object)oraModView, (String)"view");
            trigger = (OraModTrigger)oraModView.getTriggers().get(triggerName);
            if (trigger == null) continue;
            return trigger;
        }
        iterator = $receiver.getMatViews().iterator();
        while (iterator.hasNext()) {
            OraModLikeTable view;
            OraModLikeTable oraModLikeTable = view = (OraModMatView)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraModLikeTable, (String)"view");
            trigger = (OraModTrigger)oraModLikeTable.getTriggers().get(triggerName);
            if (trigger == null) continue;
            return trigger;
        }
        return null;
    }

    @Contract(pure=true)
    private static final String unquoteNameIfPossible(String name) {
        Object object = SIMPLE_QUOTED_NAME_PATTERN.matchEntire((CharSequence)name);
        if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
            object = name;
        }
        return object;
    }

    private static final void makeArgument(BasicSchema schema, OraModRoutine routine, short position, String argName, char argDirection, String dataTypeSchemaName, String dataTypePackageName, String dataTypeSpec) {
        OraModArgument argument;
        DasArgument.Direction dir = DasArgument.Direction.of((char)argDirection);
        if (dir == null && argName != null) {
            dir = DasArgument.Direction.IN;
        }
        if (dir == null) {
            dir = DasArgument.Direction.IN;
        }
        if (dir == DasArgument.Direction.RETURN) {
            BasicModArgument basicModArgument = routine.createOrGetReturnArgument();
            if (basicModArgument == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraModArgument");
            }
            argument = (OraModArgument)basicModArgument;
            argument.setRealName(argName);
        } else if (argName != null) {
            Object e = routine.getArguments().createOrGet(argName);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"routine.arguments.createOrGet(argName)");
            argument = (OraModArgument)e;
            argument.setPosition(position);
            argument.setArgumentDirection(dir);
        } else {
            return;
        }
        DataType dataType = OraIntrospectorFunctions.makeDataType$default(schema, dataTypeSchemaName, dataTypePackageName, dataTypeSpec, 0, 0, '\u0000', 112, null);
        argument.setDataType(dataType);
    }

    private static final DataType makeDataType(BasicSchema thisSchema, String typeSchemaName, String typePackageName, String typeName, int precision, int scale, char unitsCode) {
        DataType type;
        if (typeName == null) {
            DataType dataType = DataType.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataType.UNKNOWN");
            type = dataType;
        } else if (StringsKt.contains$default((CharSequence)typeName, (CharSequence)"(", (boolean)false, (int)2, null)) {
            DataType dataType = DataTypeFactory.of(typeName);
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(typeName)");
            type = dataType;
        } else {
            DataType dataType;
            int p2;
            LengthUnit units;
            boolean customType = typeSchemaName != null;
            boolean simple = SIMPLE_DATA_TYPES.contains(typeName) && !customType;
            boolean explicitUnits = EXPLICIT_UNIT_DATA_TYPES.contains(typeName) && unitsCode == 'C' && !customType;
            switch (unitsCode) {
                case 'B': {
                    LengthUnit lengthUnit = LengthUnit.BYTE;
                    break;
                }
                case 'C': {
                    LengthUnit lengthUnit = LengthUnit.CHAR;
                    break;
                }
                case 'D': {
                    LengthUnit lengthUnit = LengthUnit.DIGIT;
                    break;
                }
                default: {
                    LengthUnit lengthUnit = units = null;
                }
            }
            String explicitSchemaName = customType ? (Intrinsics.areEqual((Object)thisSchema.getRealName(), (Object)typeSchemaName) || Intrinsics.areEqual((Object)typeSchemaName, (Object)"PUBLIC") ? null : typeSchemaName) : null;
            Integer starSize = DATA_TYPE_STAR_SIZE.get(typeName);
            int n = p2 = starSize != null && precision == starSize ? 0x7FFFFFFE : precision;
            if (customType) {
                DataType dataType2 = DataTypeFactory.of(explicitSchemaName, typePackageName, typeName, -1, 0, null, null, false, true);
                dataType = dataType2;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType2, (String)"DataTypeFactory.of(expli\u2026 null, null, false, true)");
            } else {
                DataType dataType3 = simple ? DataTypeFactory.of(null, typePackageName, typeName, -1, -1, units, null, false, false) : DataTypeFactory.of(null, typePackageName, typeName, p2, scale, units, null, explicitUnits, false);
                dataType = dataType3;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType3, (String)"if (simple)\n          Da\u2026ll, explicitUnits, false)");
            }
            type = dataType;
        }
        return type;
    }

    static /* synthetic */ DataType makeDataType$default(BasicSchema basicSchema, String string, String string2, String string3, int n, int n2, char c2, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            n = -1;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x40) != 0) {
            c2 = '\u0000';
        }
        return OraIntrospectorFunctions.makeDataType(basicSchema, string, string2, string3, n, n2, c2);
    }

    private static final void applyStoredProgramSources(OraModSourceAware obj, String text2) {
        CharSequence charSequence;
        if (text2 != null && (charSequence = (CharSequence)text2).length() > 0) {
            obj.setSourceText(new SimpleCompositeText("CREATE ", CompositeText.Kind.PLAIN_TEXT, text2, CompositeText.Kind.ORIGINAL_TEXT));
        } else {
            obj.setSourceText(null);
        }
        obj.setObfuscated(false);
    }

    private static final void applyViewSources(BasicModSourceAware view, String text2) {
        CharSequence charSequence;
        if (text2 != null && (charSequence = (CharSequence)text2).length() > 0) {
            view.setSourceText(new SimpleCompositeText(text2, CompositeText.Kind.ORIGINAL_TEXT));
        } else {
            view.setSourceText(null);
        }
    }

    private static final boolean canCheckOutdated(BasicElement e) {
        return e instanceof OraCatalogObject && ((OraCatalogObject)e).getObjectId() != Long.MIN_VALUE && ((OraCatalogObject)e).getModifiedTimestamp() != null;
    }

    private static final BasicElement findOracleObjectByStringTypeAndName(@NotNull BasicSchema $receiver, String oracleTypeAndName) {
        int sep = StringsKt.indexOf$default((CharSequence)oracleTypeAndName, (char)':', (int)0, (boolean)false, (int)6, null);
        if (sep < 0) {
            return null;
        }
        String string = oracleTypeAndName;
        int n = 0;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, sep);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String oracleTypeName = string3;
        ObjectKind objectKind = OraIntrospectorFunctions.getObjectKindByOracleTypeName(oracleTypeName);
        if (objectKind == null) {
            return null;
        }
        ObjectKind objectKind2 = objectKind;
        String string4 = oracleTypeAndName;
        int n2 = sep + 1;
        String string5 = string4;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
        String objectName = string6;
        if (Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.BODY)) {
            BasicNode basicNode;
            ObjectKind objectKind3;
            switch (oracleTypeName.charAt(0)) {
                case 'P': {
                    objectKind3 = ObjectKind.PACKAGE;
                    break;
                }
                case 'T': {
                    objectKind3 = ObjectKind.OBJECT_TYPE;
                    break;
                }
                default: {
                    return null;
                }
            }
            ObjectKind parentKind = objectKind3;
            Family<? extends BasicElement> family = $receiver.familyOf(parentKind);
            if (family == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull(family, (String)"this.familyOf(parentKind) ?: return null");
            Family<? extends BasicElement> parentFamily = family;
            Family<? extends BasicElement> family2 = parentFamily;
            if (!(family2 instanceof NamingFamily)) {
                family2 = null;
            }
            if ((basicNode = (NamingFamily)family2) == null || (basicNode = (BasicElement)basicNode.get(objectName)) == null) {
                return null;
            }
            BasicNode parent2 = basicNode;
            Family<? extends BasicElement> family3 = parent2.familyOf(ObjectKind.BODY);
            return family3 != null ? (BasicElement)CollectionsKt.firstOrNull((Iterable)family3) : null;
        }
        Family<? extends BasicElement> family = $receiver.familyOf(objectKind2);
        if (family == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull(family, (String)"this.familyOf(objectKind) ?: return null");
        Family<? extends BasicElement> family4 = family;
        return family4 instanceof NamingFamily ? (BasicElement)((NamingFamily)family4).get(objectName) : null;
    }

    private static final ObjectKind getObjectKindByOracleTypeName(String oracleTypeName) {
        ObjectKind objectKind;
        switch (oracleTypeName) {
            case "INDEX": {
                objectKind = ObjectKind.INDEX;
                break;
            }
            case "TABLE": {
                objectKind = ObjectKind.TABLE;
                break;
            }
            case "CLUSTER": {
                objectKind = ObjectKind.CLUSTER;
                break;
            }
            case "VIEW": {
                objectKind = ObjectKind.VIEW;
                break;
            }
            case "SYNONYM": {
                objectKind = ObjectKind.SYNONYM;
                break;
            }
            case "SEQUENCE": {
                objectKind = ObjectKind.SEQUENCE;
                break;
            }
            case "PROCEDURE": {
                objectKind = ObjectKind.ROUTINE;
                break;
            }
            case "FUNCTION": {
                objectKind = ObjectKind.ROUTINE;
                break;
            }
            case "PACKAGE": {
                objectKind = ObjectKind.PACKAGE;
                break;
            }
            case "PACKAGE BODY": {
                objectKind = ObjectKind.BODY;
                break;
            }
            case "TRIGGER": {
                objectKind = ObjectKind.TRIGGER;
                break;
            }
            case "TYPE": {
                objectKind = ObjectKind.OBJECT_TYPE;
                break;
            }
            case "TYPE BODY": {
                objectKind = ObjectKind.BODY;
                break;
            }
            case "MATERIALIZED VIEW": {
                objectKind = ObjectKind.MAT_VIEW;
                break;
            }
            default: {
                objectKind = null;
            }
        }
        return objectKind;
    }

    static {
        String string = "(?s)^CREATE(\\s*OR\\s*REPLACE)?(\\s*[EN][A-Z]+)?\\s+TRIGGER.+$";
        NATIVE_TRIGGER_DEFINITION_PATTERN = new Regex(string);
        string = "^\\s*\"([^\"]*)\"\\s*$";
        SIMPLE_QUOTED_NAME_PATTERN = new Regex(string);
        string = "\".+\" IS NOT NULL";
        AUTO_NOT_NULL_CHECK_PATTERN = new Regex(string);
        string = "^SYS_\\w*\\d+\\$*$";
        SURROGATE_NAME_PATTERN = new Regex(string);
        string = "^SYS_NC\\d+.$";
        INDEX_EXPRESSION_STUB_PATTERN = new Regex(string);
        string = "^ISEQ\\$+_\\d+$";
        SEQUENCE_SURROGATE_NAME_PATTERN = new Regex(string);
    }

    public static final /* synthetic */ boolean access$canCheckOutdated(@NotNull BasicElement e) {
        return OraIntrospectorFunctions.canCheckOutdated(e);
    }

    @NotNull
    public static final /* synthetic */ PortionType access$applicablePortionTypeFor(int n) {
        return OraIntrospectorFunctions.applicablePortionTypeFor(n);
    }

    @NotNull
    public static final /* synthetic */ Regex access$getNATIVE_TRIGGER_DEFINITION_PATTERN$p() {
        return NATIVE_TRIGGER_DEFINITION_PATTERN;
    }

    public static final /* synthetic */ void access$processSynonyms(@NotNull List ss, @NotNull OraModRoot root2) {
        OraIntrospectorFunctions.processSynonyms(ss, root2);
    }

    public static final /* synthetic */ void access$dropUnexistentObjectsInSchema(@NotNull OraModSchema schema, @NotNull TLongHashSet identifiers) {
        OraIntrospectorFunctions.dropUnexistentObjectsInSchema(schema, identifiers);
    }

    @NotNull
    public static final /* synthetic */ TreeSet access$getSYSTEM_SCHEMAS$p() {
        return SYSTEM_SCHEMAS;
    }

    @NotNull
    public static final /* synthetic */ Regex access$getSEQUENCE_SURROGATE_NAME_PATTERN$p() {
        return SEQUENCE_SURROGATE_NAME_PATTERN;
    }

    public static final /* synthetic */ void access$setCreatedAndModifiedTimestamps(@NotNull OraModSchemaObject $receiver, @Nullable Date createdTimestamp, @Nullable Date modifiedTimestamp) {
        OraIntrospectorFunctions.setCreatedAndModifiedTimestamps($receiver, createdTimestamp, modifiedTimestamp);
    }

    @NotNull
    public static final /* synthetic */ DataType access$makeDataType(@NotNull BasicSchema thisSchema, @Nullable String typeSchemaName, @Nullable String typePackageName, @Nullable String typeName, int precision, int scale, char unitsCode) {
        return OraIntrospectorFunctions.makeDataType(thisSchema, typeSchemaName, typePackageName, typeName, precision, scale, unitsCode);
    }

    @NotNull
    public static final /* synthetic */ Regex access$getSURROGATE_NAME_PATTERN$p() {
        return SURROGATE_NAME_PATTERN;
    }

    @NotNull
    public static final /* synthetic */ Regex access$getINDEX_EXPRESSION_STUB_PATTERN$p() {
        return INDEX_EXPRESSION_STUB_PATTERN;
    }

    @NotNull
    public static final /* synthetic */ String access$unquoteNameIfPossible(@NotNull String name) {
        return OraIntrospectorFunctions.unquoteNameIfPossible(name);
    }

    @NotNull
    public static final /* synthetic */ Regex access$getAUTO_NOT_NULL_CHECK_PATTERN$p() {
        return AUTO_NOT_NULL_CHECK_PATTERN;
    }

    @Nullable
    public static final /* synthetic */ OraModConstraint access$findModConstraint(@NotNull OraTable $receiver, @NotNull String name) {
        return OraIntrospectorFunctions.findModConstraint($receiver, name);
    }

    @Nullable
    public static final /* synthetic */ OraModLikeTable access$findTableOrViewByName(@NotNull OraModSchema $receiver, @NotNull String name) {
        return OraIntrospectorFunctions.findTableOrViewByName($receiver, name);
    }

    @Nullable
    public static final /* synthetic */ OraModModule access$findModuleByName(@NotNull OraModSchema $receiver, @NotNull String name) {
        return OraIntrospectorFunctions.findModuleByName($receiver, name);
    }

    public static final /* synthetic */ void access$makeArgument(@NotNull BasicSchema schema, @NotNull OraModRoutine routine, short position, @Nullable String argName, char argDirection, @Nullable String dataTypeSchemaName, @Nullable String dataTypePackageName, @NotNull String dataTypeSpec) {
        OraIntrospectorFunctions.makeArgument(schema, routine, position, argName, argDirection, dataTypeSchemaName, dataTypePackageName, dataTypeSpec);
    }

    @Nullable
    public static final /* synthetic */ BasicElement access$findOracleObjectByStringTypeAndName(@NotNull BasicSchema $receiver, @NotNull String oracleTypeAndName) {
        return OraIntrospectorFunctions.findOracleObjectByStringTypeAndName($receiver, oracleTypeAndName);
    }

    public static final /* synthetic */ void access$applyViewSources(@NotNull BasicModSourceAware view, @Nullable String text2) {
        OraIntrospectorFunctions.applyViewSources(view, text2);
    }

    public static final /* synthetic */ void access$applyStoredProgramSources(@NotNull OraModSourceAware obj, @Nullable String text2) {
        OraIntrospectorFunctions.applyStoredProgramSources(obj, text2);
    }

    @Nullable
    public static final /* synthetic */ OraModTrigger access$findTrigger(@NotNull OraModSchema $receiver, @NotNull String triggerName) {
        return OraIntrospectorFunctions.findTrigger($receiver, triggerName);
    }

    @NotNull
    public static final /* synthetic */ ModNamingIdentifyingFamily access$majorFamilyOf(@NotNull OraModSchema schema, @NotNull String code) {
        return OraIntrospectorFunctions.majorFamilyOf(schema, code);
    }
}

