/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.attributetotag;

import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.border.IdeaTitledBorder;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.utils.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

class AttributeToTagDialog
extends BaseRefactoringDialog {
    private final JLabel attributeNameLabel = new JLabel();
    private final JTextField tagNameField;
    private final XmlAttribute attribute;
    private final XmlTag tag;

    AttributeToTagDialog(XmlAttribute attribute) {
        super(attribute.getProject(), true);
        this.attribute = attribute;
        String attributeName = attribute.getName();
        this.tag = attribute.getParent();
        XmlFile containingFile = (XmlFile)this.tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.setTitle("Replace Attribute With Tag");
        this.attributeNameLabel.setText("Name for new tag");
        String newTagName = XMLUtil.attributeNameFromTag(attributeName, this.tag.getLocalName());
        this.tagNameField = new JTextField(newTagName);
        Document document = this.tagNameField.getDocument();
        document.addDocumentListener(this.docListener);
        this.init();
        this.validateButtons();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.AttributeToTag";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.tagNameField;
    }

    public String getTagName() {
        return this.tagNameField.getText().trim();
    }

    protected JComponent createNorthPanel() {
        String tagName = this.tag.getName();
        String attributeName = this.attribute.getName();
        JPanel panel = new JPanel(new BorderLayout());
        IdeaTitledBorder border = IdeBorderFactory.createTitledBorder((String)("Replace attribute " + attributeName + " of tag " + tagName), (boolean)true);
        panel.add((Component)this.attributeNameLabel, "North");
        Box box = Box.createVerticalBox();
        panel.setBorder((Border)border);
        this.tagNameField.setEditable(true);
        box.add(this.tagNameField);
        panel.add((Component)box, "Center");
        return panel;
    }

    @Override
    protected boolean isValid() {
        String tagName = this.getTagName();
        boolean tagNameEntered = XMLUtil.tagNameIsValid(tagName);
        boolean scopeIsValid = this.scopePanel.isScopeValid();
        return tagNameEntered && scopeIsValid;
    }

    @Override
    protected String calculateXSLT() {
        String tagName = this.tag.getName();
        String attributeName = this.attribute.getName();
        String newTagName = this.getTagName();
        return "<xsl:template match=\"@" + attributeName + "[parent::" + tagName + "]\">\n<" + newTagName + "><xsl:value-of select=\".\"/></" + newTagName + ">\n</xsl:template>";
    }

    @Override
    @NotNull
    protected String getHelpId() {
        if ("refactoring.attributeToTag" == null) {
            AttributeToTagDialog.$$$reportNull$$$0(0);
        }
        return "refactoring.attributeToTag";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/attributetotag/AttributeToTagDialog", "getHelpId"));
    }
}

