/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0018\u0010\r\u001a\u00020\u000e*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\u0011*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNestedClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isInsideAnonymousObject", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Z", "description", "", "getDescription", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)Ljava/lang/String;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirNestedClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNestedClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNestedClassChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n51#2:60\n35#2:61\n64#2:62\n28#2:63\n35#2:64\n64#2:68\n1755#3,3:65\n*S KotlinDebug\n*F\n+ 1 FirNestedClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNestedClassChecker\n*L\n28#1:60\n33#1:61\n33#1:62\n38#1:63\n40#1:64\n56#1:68\n45#1:65,3\n*E\n"})
public final class FirNestedClassChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirNestedClassChecker INSTANCE = new FirNestedClassChecker();

    private FirNestedClassChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (declaration.getClassKind().isSingleton() || declaration.getClassKind() == ClassKind.ENUM_CLASS) {
            FirClassLikeDeclaration $this$isLocal$iv = declaration;
            boolean $i$f$isLocal = false;
            if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
                return;
            }
        }
        FirClass firClass = (firDeclaration = CollectionsKt.lastOrNull(context.getContainingDeclarations())) instanceof FirClass ? (FirClass)firDeclaration : null;
        if (firClass == null) {
            return;
        }
        FirClass containingDeclaration = firClass;
        if (containingDeclaration.getClassKind() == ClassKind.ENUM_ENTRY) {
            FirMemberDeclaration $this$isInner$iv = declaration;
            boolean $i$f$isInner = false;
            if (!$this$isInner$iv.getStatus().isInner()) {
                FirRegularClass $this$isCompanion$iv = declaration;
                boolean $i$f$isCompanion = false;
                if (!$this$isCompanion$iv.getStatus().isCompanion()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getNESTED_CLASS_NOT_ALLOWED(), (Object)this.getDescription(declaration), (DiagnosticContext)context, null, 16, null);
                    return;
                }
            }
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = containingDeclaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        boolean containerIsLocal = Intrinsics.areEqual(object, EffectiveVisibility.Local.INSTANCE);
        FirMemberDeclaration $this$isInner$iv = declaration;
        boolean $i$f$isInner = false;
        if (!$this$isInner$iv.getStatus().isInner()) {
            $this$isInner$iv = containingDeclaration;
            $i$f$isInner = false;
            if ($this$isInner$iv.getStatus().isInner() || containerIsLocal || this.isInsideAnonymousObject(context)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getNESTED_CLASS_NOT_ALLOWED(), (Object)this.getDescription(declaration), (DiagnosticContext)context, null, 16, null);
            }
        }
    }

    private final boolean isInsideAnonymousObject(CheckerContext $this$isInsideAnonymousObject) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$isInsideAnonymousObject.getContainingDeclarations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirDeclaration it = (FirDeclaration)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof FirAnonymousObject)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String getDescription(FirRegularClass $this$description) {
        String string2;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$description.getClassKind().ordinal()]) {
            case 1: {
                string2 = "Class";
                break;
            }
            case 2: {
                string2 = "Interface";
                break;
            }
            case 3: {
                string2 = "Enum class";
                break;
            }
            case 4: {
                string2 = "Enum entry";
                break;
            }
            case 5: {
                string2 = "Annotation class";
                break;
            }
            case 6: {
                FirRegularClass $this$isCompanion$iv = $this$description;
                boolean $i$f$isCompanion = false;
                if ($this$isCompanion$iv.getStatus().isCompanion()) {
                    string2 = "Companion object";
                    break;
                }
                string2 = "Object";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

