/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.autobean.shared.impl;

import com.google.gwt.core.client.impl.WeakMapping;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.shared.AutoBeanUtils;
import com.google.web.bindery.autobean.shared.AutoBeanVisitor;
import com.google.web.bindery.autobean.shared.Splittable;
import com.google.web.bindery.autobean.shared.impl.AutoBeanCodexImpl;
import com.google.web.bindery.autobean.shared.impl.HasSplittable;
import com.google.web.bindery.autobean.shared.impl.StringQuoter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAutoBean<T>
implements AutoBean<T>,
HasSplittable {
    public static final String UNSPLITTABLE_VALUES_KEY = "__unsplittableValues";
    protected static final Object[] EMPTY_OBJECT = new Object[0];
    protected Splittable data;
    protected T wrapped;
    private final AutoBeanFactory factory;
    private boolean frozen;
    private Map<String, Object> tags;
    private final boolean usingSimplePeer;

    protected AbstractAutoBean(AutoBeanFactory factory) {
        this(factory, StringQuoter.createSplittable());
    }

    protected AbstractAutoBean(AutoBeanFactory factory, Splittable data) {
        this.data = data;
        this.factory = factory;
        this.usingSimplePeer = true;
        this.wrapped = this.createSimplePeer();
    }

    protected AbstractAutoBean(T wrapped, AutoBeanFactory factory) {
        this.factory = factory;
        this.usingSimplePeer = false;
        this.data = null;
        this.wrapped = wrapped;
        WeakMapping.setWeak(wrapped, AutoBean.class.getName(), this);
    }

    @Override
    public void accept(AutoBeanVisitor visitor) {
        this.traverse(visitor, new OneShotContext());
    }

    @Override
    public abstract T as();

    @Override
    public AutoBean<T> clone(boolean deep) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AutoBeanFactory getFactory() {
        return this.factory;
    }

    @Override
    public Splittable getSplittable() {
        return this.data;
    }

    @Override
    public <Q> Q getTag(String tagName) {
        return (Q)(this.tags == null ? null : this.tags.get(tagName));
    }

    public boolean hasUnsplittableValues() {
        return this.data.isReified(UNSPLITTABLE_VALUES_KEY);
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public boolean isWrapper() {
        return !this.usingSimplePeer;
    }

    public void setData(Splittable data) {
        assert (data != null) : "null data";
        this.data = data;
        this.wrapped = this.createSimplePeer();
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    @Override
    public void setTag(String tagName, Object value) {
        if (this.tags == null) {
            this.tags = new HashMap<String, Object>();
        }
        this.tags.put(tagName, value);
    }

    public void traverse(AutoBeanVisitor visitor, OneShotContext ctx) {
        if (ctx.hasSeen(this)) {
            return;
        }
        if (visitor.visit(this, ctx)) {
            this.traverseProperties(visitor, ctx);
        }
        visitor.endVisit(this, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T unwrap() {
        if (this.usingSimplePeer) {
            throw new IllegalStateException();
        }
        try {
            WeakMapping.set(this.wrapped, AutoBean.class.getName(), null);
            T t = this.wrapped;
            return t;
        }
        finally {
            this.wrapped = null;
        }
    }

    protected void call(String method, Object returned, Object ... parameters) {
    }

    protected void checkFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("The AutoBean has been frozen");
        }
    }

    protected void checkWrapped() {
        if (this.wrapped == null && !this.usingSimplePeer) {
            throw new IllegalStateException("The AutoBean has been unwrapped");
        }
    }

    protected T createSimplePeer() {
        throw new UnsupportedOperationException();
    }

    protected <V> V get(String method, V toReturn) {
        return toReturn;
    }

    protected <W> W getFromWrapper(W obj) {
        return (W)AutoBeanUtils.getAutoBean(obj).as();
    }

    protected <Q> Q getOrReify(String propertyName) {
        this.checkWrapped();
        if (this.data.isReified(propertyName)) {
            Object temp = this.data.getReified(propertyName);
            return (Q)temp;
        }
        if (this.data.isNull(propertyName)) {
            return null;
        }
        this.data.setReified(propertyName, null);
        AutoBeanCodexImpl.Coder coder = AutoBeanCodexImpl.doCoderFor(this, propertyName);
        Object toReturn = coder.decode(AutoBeanCodexImpl.EncodeState.forDecode(this.factory), this.data.get(propertyName));
        this.data.setReified(propertyName, toReturn);
        return (Q)toReturn;
    }

    protected T getWrapped() {
        this.checkWrapped();
        return this.wrapped;
    }

    protected boolean isUsingSimplePeer() {
        return this.usingSimplePeer;
    }

    protected boolean isWrapped(Object obj) {
        return AutoBeanUtils.getAutoBean(obj) != null;
    }

    protected void set(String method, Object value) {
    }

    protected void setProperty(String propertyName, Object value) {
        this.checkWrapped();
        this.checkFrozen();
        this.data.setReified(propertyName, value);
        if (value == null) {
            Splittable.NULL.assign(this.data, propertyName);
            return;
        }
        AutoBeanCodexImpl.Coder coder = AutoBeanCodexImpl.doCoderFor(this, propertyName);
        Splittable backing = coder.extractSplittable(AutoBeanCodexImpl.EncodeState.forDecode(this.factory), value);
        if (backing == null) {
            this.data.setReified(UNSPLITTABLE_VALUES_KEY, true);
        } else {
            backing.assign(this.data, propertyName);
        }
    }

    protected abstract void traverseProperties(AutoBeanVisitor var1, OneShotContext var2);

    public static class OneShotContext
    implements AutoBeanVisitor.Context {
        private final Set<AbstractAutoBean<?>> seen = new HashSet();

        public boolean hasSeen(AbstractAutoBean<?> bean) {
            return !this.seen.add(bean);
        }
    }
}

