/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.validation.client.impl;

import com.google.gwt.validation.client.impl.ConstraintOrigin;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.Payload;
import javax.validation.metadata.ConstraintDescriptor;

public final class ConstraintDescriptorImpl<T extends Annotation>
implements ConstraintDescriptor<T> {
    private final T annotation;
    private final Set<Class<?>> groups;
    private final Set<Class<? extends Payload>> payload;
    private final List<Class<? extends ConstraintValidator<T, ?>>> constraintValidatorClasses;
    private final Map<String, Object> attributes;
    private final Set<ConstraintDescriptor<?>> composingConstraints;
    private final boolean reportAsSingleViolation;
    private final ElementType elementType;
    private final ConstraintOrigin definedOn;

    public static <T extends Annotation> Builder<T> builder() {
        return new Builder();
    }

    private ConstraintDescriptorImpl(T annotation, Set<Class<?>> groups, Set<Class<? extends Payload>> payload, List<Class<? extends ConstraintValidator<T, ?>>> constraintValidatorClasses, Map<String, Object> attributes, Set<ConstraintDescriptor<?>> composingConstraints, boolean reportAsSingleViolation, ElementType elementType, ConstraintOrigin definedOn) {
        this.annotation = annotation;
        this.groups = groups;
        this.payload = payload;
        this.constraintValidatorClasses = constraintValidatorClasses;
        this.attributes = attributes;
        this.composingConstraints = composingConstraints;
        this.reportAsSingleViolation = reportAsSingleViolation;
        this.elementType = elementType;
        this.definedOn = definedOn;
    }

    public T getAnnotation() {
        return this.annotation;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Set<ConstraintDescriptor<?>> getComposingConstraints() {
        return this.composingConstraints;
    }

    public List<Class<? extends ConstraintValidator<T, ?>>> getConstraintValidatorClasses() {
        return this.constraintValidatorClasses;
    }

    public ConstraintOrigin getDefinedOn() {
        return this.definedOn;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public Set<Class<?>> getGroups() {
        return this.groups;
    }

    public Set<Class<? extends Payload>> getPayload() {
        return this.payload;
    }

    public boolean isReportAsSingleViolation() {
        return this.reportAsSingleViolation;
    }

    public String toString() {
        return String.valueOf(this.annotation);
    }

    /* synthetic */ ConstraintDescriptorImpl(Annotation x0, Set x1, Set x2, List x3, Map x4, Set x5, boolean x6, ElementType x7, ConstraintOrigin x8, 1 x9) {
        this(x0, x1, x2, x3, x4, x5, x6, x7, x8);
    }

    static class 1 {
    }

    public static class Builder<T extends Annotation> {
        private T annotation;
        private Set<Class<?>> groups;
        private Set<Class<? extends Payload>> payload;
        private List<Class<? extends ConstraintValidator<T, ?>>> constraintValidatorClasses;
        private Map<String, Object> attributes;
        private Set<ConstraintDescriptor<?>> composingConstraints = new HashSet();
        private boolean reportAsSingleViolation;
        private ElementType elementType;
        private ConstraintOrigin definedOn;

        public Builder<T> addComposingConstraint(ConstraintDescriptor<?> composingConstraint) {
            this.composingConstraints.add(composingConstraint);
            return this;
        }

        public ConstraintDescriptorImpl<T> build() {
            return new ConstraintDescriptorImpl((Annotation)this.annotation, this.groups, this.payload, this.constraintValidatorClasses, this.attributes, this.composingConstraints, this.reportAsSingleViolation, this.elementType, this.definedOn, null);
        }

        public Builder<T> setAnnotation(T annotation) {
            this.annotation = annotation;
            return this;
        }

        public Builder<T> setAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder<T> setConstraintValidatorClasses(Class<? extends ConstraintValidator<T, ?>>[] constraintValidatorClasses) {
            List<Class<? extends ConstraintValidator<T, ?>>> list = Arrays.asList(constraintValidatorClasses);
            this.setConstraintValidatorClasses(list);
            return this;
        }

        public Builder<T> setConstraintValidatorClasses(List<Class<? extends ConstraintValidator<T, ?>>> constraintValidatorClasses) {
            this.constraintValidatorClasses = constraintValidatorClasses;
            return this;
        }

        public Builder<T> setDefinedOn(ConstraintOrigin definedOn) {
            this.definedOn = definedOn;
            return this;
        }

        public Builder<T> setElementType(ElementType elementType) {
            this.elementType = elementType;
            return this;
        }

        public Builder<T> setGroups(Class<?>[] classes) {
            this.setGroups(new HashSet(Arrays.asList(classes)));
            return this;
        }

        public Builder<T> setGroups(Set<Class<?>> groups) {
            this.groups = groups;
            return this;
        }

        public Builder<T> setPayload(Class<? extends Payload>[] classes) {
            this.setPayload(new HashSet<Class<? extends Payload>>(Arrays.asList(classes)));
            return this;
        }

        public Builder<T> setPayload(Set<Class<? extends Payload>> payload) {
            this.payload = payload;
            return this;
        }

        public Builder<T> setReportAsSingleViolation(boolean reportAsSingleViolation) {
            this.reportAsSingleViolation = reportAsSingleViolation;
            return this;
        }
    }
}

