/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.prefs.GalleryProperties;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.prefs.PropertiesFile;
import com.gallery.GalleryRemote.util.BrowserLink;
import com.gallery.GalleryRemote.util.DialogUtil;
import com.gallery.GalleryRemote.util.GRI18n;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.UIManager;

public class Update
extends JFrame
implements ActionListener,
PreferenceNames {
    public static final String MODULE = "Update";
    public static final int NO_UPDATE = 0;
    public static final int RELEASE = 1;
    public static final int BETA = 2;
    Info release = null;
    Info beta = null;
    Info which = null;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JLabel jLabel5 = new JLabel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextArea jVersion = new JTextArea();
    JTextArea jDate = new JTextArea();
    JTextPane jReleaseNotes = new JTextPane();
    BrowserLink jUrl = new BrowserLink();
    JButton jBrowse = new JButton();

    public int check(boolean showImmediate) {
        int result = 0;
        if (GalleryRemote._().properties.getBooleanProperty("updateCheck")) {
            this.release = new Info(GalleryRemote._().properties.getProperty("updateUrl"));
            if (this.release.check()) {
                result = 1;
                this.which = this.release;
            }
        }
        if (result == 0 && GalleryRemote._().properties.getBooleanProperty("updateCheckBeta")) {
            this.beta = new Info(GalleryRemote._().properties.getProperty("updateUrlBeta"));
            if (this.beta.check()) {
                result = 2;
                this.which = this.beta;
            }
        }
        if (showImmediate && this.which != null) {
            this.showNotice();
        }
        return result;
    }

    public void showNotice() {
        if (this.which == null) {
            return;
        }
        try {
            this.jbInit();
            this.pack();
            DialogUtil.center((Window)this);
            this.setIconImage(GalleryRemote._().getMainFrame().getIconImage());
            this.setVisible(true);
        }
        catch (Exception e) {
            Log.logException((int)0, (String)MODULE, (Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        this.setTitle(GRI18n.getString((String)MODULE, (String)"title"));
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.jLabel1.setFont(UIManager.getFont("Label.font").deriveFont(1, 16.0f));
        this.jLabel1.setText(GRI18n.getString((String)MODULE, (String)"newVerAvail"));
        this.jLabel2.setText(GRI18n.getString((String)MODULE, (String)"ver"));
        this.jLabel3.setText(GRI18n.getString((String)MODULE, (String)"relDate"));
        this.jLabel4.setText(GRI18n.getString((String)MODULE, (String)"relNotes"));
        this.jLabel5.setText(GRI18n.getString((String)MODULE, (String)"dnURL"));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jDate.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.jDate.setEditable(false);
        this.jDate.setFont(UIManager.getFont("Label.font"));
        if (this.which.releaseDate != null) {
            this.jDate.setText(DateFormat.getDateInstance().format(this.which.releaseDate));
        }
        this.jBrowse.setText(GRI18n.getString((String)MODULE, (String)"openInBrwsr"));
        this.jBrowse.addActionListener(this);
        this.jReleaseNotes.setEditable(false);
        this.jReleaseNotes.setFont(UIManager.getFont("Label.font"));
        this.jReleaseNotes.setPreferredSize(new Dimension(520, 250));
        this.jReleaseNotes.setMargin(new Insets(0, 3, 3, 3));
        if (this.which.releaseNotes != null) {
            this.jReleaseNotes.setText(this.which.releaseNotes);
        }
        if (this.which.releaseUrl != null) {
            if (GalleryRemote.IS_MAC_OS_X) {
                this.jUrl.setText(this.which.releaseUrlMac);
            } else {
                this.jUrl.setText(this.which.releaseUrl);
            }
        }
        this.jVersion.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.jVersion.setEditable(false);
        this.jVersion.setFont(UIManager.getFont("Label.font"));
        if (this.which.version != null) {
            this.jVersion.setText(this.which.version);
        }
        this.getContentPane().add((Component)this.jLabel1, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 15, 0), 0, 0));
        this.getContentPane().add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(1, 0, 0, 0), 5, 0));
        this.getContentPane().add((Component)this.jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(1, 0, 0, 0), 5, 0));
        this.getContentPane().add((Component)this.jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 12, 0, new Insets(3, 0, 0, 0), 5, 0));
        this.getContentPane().add((Component)this.jLabel5, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(1, 0, 0, 0), 5, 0));
        this.getContentPane().add((Component)this.jScrollPane1, new GridBagConstraints(1, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 2));
        this.getContentPane().add((Component)this.jVersion, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 2));
        this.getContentPane().add((Component)this.jDate, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 2));
        this.getContentPane().add((Component)this.jUrl, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jBrowse, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 5, 5, 5), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.jReleaseNotes, null);
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            BrowserLauncher.openURL(this.jUrl.getUrl());
        }
        catch (Exception e) {
            Log.log((int)0, (String)MODULE, (String)"Exception while trying to open browser");
            Log.logException((int)0, (String)MODULE, (Throwable)e);
        }
    }

    public static boolean upgrade() {
        PropertiesFile lax = new PropertiesFile("Gallery Remote.lax");
        try {
            lax.read();
        }
        catch (FileNotFoundException e) {
            Log.log((int)2, (String)MODULE, (String)"LAX file not found: probably running from Ant or IDE...");
            return false;
        }
        String laxClasspath = lax.getProperty("lax.class.path");
        String classpath = GalleryRemote._().properties.getProperty("classpath");
        if (classpath != null && !classpath.equals(laxClasspath)) {
            Log.log((int)2, (String)MODULE, (String)"Patching LAX classpath");
            try {
                File laxFile = new File("Gallery Remote.lax");
                File patchFile = new File("Gallery Remote.lax.patch");
                File origFile = new File("Gallery Remote.lax.orig");
                BufferedReader in = new BufferedReader(new FileReader(laxFile));
                BufferedWriter out = new BufferedWriter(new FileWriter(patchFile));
                String line = null;
                String cr = System.getProperty("line.separator");
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("lax.class.path=")) {
                        out.write("lax.class.path=" + classpath + cr);
                        continue;
                    }
                    out.write(line + cr);
                }
                in.close();
                out.close();
                origFile.delete();
                laxFile.renameTo(origFile);
                patchFile.renameTo(laxFile);
                JOptionPane.showMessageDialog(null, GRI18n.getString((String)MODULE, (String)"restart.text"), GRI18n.getString((String)MODULE, (String)"restart.title"), 2);
                return true;
            }
            catch (FileNotFoundException e) {
                Log.logException((int)1, (String)MODULE, (Throwable)e);
            }
            catch (IOException e) {
                Log.logException((int)1, (String)MODULE, (Throwable)e);
            }
            return false;
        }
        Log.log((int)2, (String)MODULE, (String)"LAX classpath up to date");
        return false;
    }

    class Info {
        String version = null;
        Date releaseDate = null;
        String releaseNotes = null;
        String releaseUrl = null;
        String releaseUrlMac = null;
        String url = null;

        Info(String url) {
            this.url = url;
        }

        boolean check() {
            try {
                InputStream content = (InputStream)new URL(this.url).getContent();
                GalleryProperties props = new GalleryProperties();
                props.load(content);
                this.releaseDate = props.getDateProperty("releaseDate");
                this.version = props.getProperty("version");
                this.releaseNotes = props.getProperty("releaseNotes");
                this.releaseUrl = props.getProperty("releaseUrl");
                this.releaseUrlMac = props.getProperty("releaseUrlMac");
                if (this.releaseUrlMac == null) {
                    this.releaseUrlMac = this.releaseUrl;
                }
                Date myReleaseDate = GalleryRemote._().properties.getDateProperty("releaseDate");
                Log.log((int)3, (String)Update.MODULE, (String)("Local release date: " + myReleaseDate + " new: " + this.releaseDate));
                return this.releaseDate.after(myReleaseDate);
            }
            catch (Exception e) {
                Log.log((int)0, (String)Update.MODULE, (String)"Update check failed");
                Log.logException((int)1, (String)Update.MODULE, (Throwable)e);
                return false;
            }
        }
    }
}

