/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import javax.swing.JPopupMenu;
import org.igoweb.go.sgf.Node;
import org.igoweb.go.sgf.Prop;
import org.igoweb.go.swing.StoneImages;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;

public class NodeWidget
extends Component
implements MouseListener,
EventListener {
    public static final int connectorW = 2;
    public final Node node;
    private int color;
    private boolean isOnActivePath;
    private boolean isActive;
    private boolean isAnnotated;
    private int moveNum = -1;
    private boolean mousePressed = false;
    private boolean mouseIn = false;
    private StoneImages images = null;
    private int whiteImageId = StoneImages.whiteImageId();
    private static final int CHILD_RIGHT = 1;
    private static final int CHILD_DOWNRIGHT = 2;
    private static final int CHILD_DOWN = 4;
    private static final int PARENT_DIAG = 1;
    private static final int PARENT_LEFT = 2;
    private int childLines = 0;
    private int newChildLines = 0;
    private int parentLine = 0;
    private ActionListener listener = null;
    private JPopupMenu popup = null;

    public NodeWidget(Node node, ActionListener listener) {
        this.node = node;
        this.setListener(listener);
    }

    @Override
    public void removeNotify() {
        this.node.removeListener(this);
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        this.node.addListener(this);
        this.handleEvent((Event)null);
        super.addNotify();
    }

    public void setParentLines(int yOffset, NodeWidget parent) {
        boolean change = this.childLines != this.newChildLines;
        this.childLines = this.newChildLines;
        this.newChildLines = 0;
        int newParentLine = 0;
        if (yOffset == 0) {
            newParentLine = 2;
            parent.newChildLines |= 1;
        } else if (yOffset > 0) {
            newParentLine = 1;
            parent.newChildLines = yOffset == 1 ? (parent.newChildLines |= 2) : (parent.newChildLines |= 4);
        }
        boolean bl = this.parentLine != newParentLine;
        this.parentLine = newParentLine;
        if (change |= bl) {
            this.repaint();
            if (parent != null) {
                parent.repaint();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (!this.mousePressed) {
            if (this.popup != null && event.isPopupTrigger()) {
                this.popup.show(this, event.getX(), event.getY());
            } else {
                this.mousePressed = true;
                this.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.mousePressed) {
            this.mousePressed = false;
            if (this.popup != null && event.isPopupTrigger()) {
                this.popup.show(this, event.getX(), event.getY());
            } else if (this.mouseIn && this.listener != null) {
                this.listener.actionPerformed(new ActionEvent(this.node, 1001, ""));
            }
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        if (!this.mouseIn) {
            this.mouseIn = true;
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        if (this.mouseIn) {
            this.mouseIn = false;
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void handleEvent(Event event) {
        int newMoveNum;
        boolean newVal;
        boolean change = false;
        int newColor = 2;
        Prop param = this.node.findProp(14);
        if (param != null) {
            newColor = param.getColor();
        }
        if (newColor != this.color) {
            this.color = newColor;
            change = true;
        }
        if ((newVal = this.node.isAnnotated()) != this.isAnnotated) {
            this.isAnnotated = newVal;
            change = true;
        }
        if ((newVal = this.node.isOnActivePath()) != this.isOnActivePath) {
            this.isOnActivePath = newVal;
            change = true;
        }
        if ((newVal = this.node.isActive()) != this.isActive) {
            this.isActive = newVal;
            change = true;
        }
        if (this.color != 2 && !this.isAnnotated && (newMoveNum = this.node.getMoveNum()) != this.moveNum) {
            this.moveNum = newMoveNum;
            change = true;
        }
        if (change) {
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int size = this.getSize().width;
        g2d.translate(2, 2);
        size -= 4;
        if (this.mousePressed && this.mouseIn) {
            g2d.setColor(Color.red.brighter());
            g2d.fill3DRect(0, 0, size, size, false);
        } else if (this.isActive) {
            g2d.setColor(Color.red);
            g2d.fill3DRect(0, 0, size, size, true);
        } else if (this.mouseIn) {
            g2d.setColor(Color.gray);
            g2d.fill3DRect(0, 0, size, size, true);
        }
        g2d.setColor(Color.black);
        g2d.setStroke(new BasicStroke(2.0f));
        GeneralPath path = new GeneralPath();
        float halfWidth = (float)size * 0.5f;
        if (this.parentLine == 2) {
            path.moveTo(0.0f, halfWidth);
            path.lineTo(halfWidth, halfWidth);
        } else if (this.parentLine == 1) {
            path.moveTo(-2.0f, -2.0f);
            path.lineTo(halfWidth, halfWidth);
        } else {
            path.moveTo(halfWidth, halfWidth);
        }
        if ((this.childLines & 1) != 0) {
            path.lineTo(size, halfWidth);
            path.moveTo(halfWidth, halfWidth);
        }
        if ((this.childLines & 2) != 0) {
            path.lineTo(size + 2, size + 2);
            path.moveTo(halfWidth, halfWidth);
        }
        if ((this.childLines & 4) != 0) {
            path.lineTo(halfWidth, size);
        }
        int border = size / 6;
        int stoneSize = size - 2 * border;
        if (this.images == null || this.images.size != stoneSize) {
            this.images = StoneImages.create(stoneSize);
        }
        int mark = 0;
        if (!this.isOnActivePath) {
            mark = 128;
        }
        String label = null;
        if (this.isAnnotated) {
            mark |= 4;
        } else if (this.color != 2) {
            mark |= 2;
            label = " " + Integer.toString(this.moveNum) + " ";
        }
        Shape oldClip = g2d.getClip();
        if (!this.isOnActivePath && this.color != 2) {
            Area newClip = new Area(oldClip);
            newClip.subtract(new Area(new Ellipse2D.Double(border, border, stoneSize, stoneSize)));
            g2d.setClip(newClip);
        }
        g2d.draw(path);
        g2d.setClip(oldClip);
        g2d.translate(border, border);
        this.images.paintStone(g2d, this.color, mark, this.whiteImageId, label, 0);
    }

    public void setListener(ActionListener newListener) {
        if (this.listener != newListener) {
            boolean clickableChange = this.listener == null != (newListener == null);
            this.listener = newListener;
            if (clickableChange) {
                if (this.listener == null) {
                    this.removeMouseListener(this);
                } else {
                    this.addMouseListener(this);
                }
                if (this.mouseIn || this.mousePressed) {
                    this.mouseIn = false;
                    this.mousePressed = false;
                    this.repaint();
                }
            }
        }
    }

    public void setPopupMenu(JPopupMenu newPopupMenu) {
        this.popup = newPopupMenu;
    }

    public void clearImages() {
        this.images = null;
    }
}

