/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.transform;

import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.rows.BaseRowIterator;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.transform.BaseIterator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.utils.Throwables;

public abstract class BaseRows<R extends Unfiltered, I extends BaseRowIterator<? extends Unfiltered>>
extends BaseIterator<Unfiltered, I, R>
implements BaseRowIterator<R> {
    private Row staticRow;
    private DecoratedKey partitionKey;

    public BaseRows(I input) {
        super(input);
        this.staticRow = input.staticRow();
        this.partitionKey = input.partitionKey();
    }

    BaseRows(BaseRows<?, ? extends I> copyFrom) {
        super(copyFrom);
        this.staticRow = copyFrom.staticRow;
        this.partitionKey = copyFrom.partitionKey();
    }

    @Override
    public CFMetaData metadata() {
        return ((BaseRowIterator)this.input).metadata();
    }

    @Override
    public boolean isReverseOrder() {
        return ((BaseRowIterator)this.input).isReverseOrder();
    }

    @Override
    public PartitionColumns columns() {
        return ((BaseRowIterator)this.input).columns();
    }

    @Override
    public DecoratedKey partitionKey() {
        return ((BaseRowIterator)this.input).partitionKey();
    }

    @Override
    public Row staticRow() {
        return this.staticRow == null ? Rows.EMPTY_STATIC_ROW : this.staticRow;
    }

    @Override
    protected Throwable runOnClose(int length) {
        Throwable fail = null;
        Transformation[] fs = this.stack;
        for (int i = 0; i < length; ++i) {
            try {
                fs[i].onPartitionClose();
                continue;
            }
            catch (Throwable t) {
                fail = Throwables.merge(fail, t);
            }
        }
        return fail;
    }

    @Override
    void add(Transformation transformation) {
        transformation.attachTo(this);
        super.add(transformation);
        if (this.staticRow != null) {
            this.staticRow = transformation.applyToStatic(this.staticRow);
        }
        this.next = this.applyOne((Unfiltered)this.next, transformation);
        this.partitionKey = transformation.applyToPartitionKey(this.partitionKey);
    }

    @Override
    protected Unfiltered applyOne(Unfiltered value, Transformation transformation) {
        return value == null ? null : (value instanceof Row ? transformation.applyToRow((Row)value) : transformation.applyToMarker((RangeTombstoneMarker)value));
    }

    @Override
    public final boolean hasNext() {
        BaseIterator.Stop stop = this.stop;
        while (this.next == null) {
            Transformation[] fs = this.stack;
            int len = this.length;
            while (!stop.isSignalled && !this.stopChild.isSignalled && ((BaseRowIterator)this.input).hasNext()) {
                int i;
                Unfiltered next = (Unfiltered)((BaseRowIterator)this.input).next();
                if (next.isRow()) {
                    Row row = (Row)next;
                    for (i = 0; row != null && i < len; ++i) {
                        row = fs[i].applyToRow(row);
                    }
                    next = row;
                } else {
                    RangeTombstoneMarker rtm = (RangeTombstoneMarker)next;
                    for (i = 0; rtm != null && i < len; ++i) {
                        rtm = fs[i].applyToMarker(rtm);
                    }
                    next = rtm;
                }
                if (next == null) continue;
                this.next = next;
                return true;
            }
            if (!stop.isSignalled && !this.stopChild.isSignalled && this.hasMoreContents()) continue;
            return false;
        }
        return true;
    }
}

