/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.junit.AggregateTransformer;
import org.apache.tools.ant.taskdefs.optional.junit.DOMUtil;
import org.apache.tools.ant.taskdefs.optional.junit.XMLConstants;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.DOMElementWriter;
import org.apache.tools.ant.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XMLResultAggregator
extends Task
implements XMLConstants {
    protected Vector filesets = new Vector();
    protected String toFile;
    protected File toDir;
    protected Vector transformers = new Vector();
    public static final String DEFAULT_DIR = ".";
    public static final String DEFAULT_FILENAME = "TESTS-TestSuites.xml";

    public AggregateTransformer createReport() {
        AggregateTransformer transformer = new AggregateTransformer(this);
        this.transformers.addElement(transformer);
        return transformer;
    }

    public void setTofile(String value) {
        this.toFile = value;
    }

    public void setTodir(File value) {
        this.toDir = value;
    }

    public void addFileSet(FileSet fs) {
        this.filesets.addElement(fs);
    }

    public void execute() throws BuildException {
        Element rootElement = this.createDocument();
        File destFile = this.getDestinationFile();
        try {
            this.writeDOMTree(rootElement.getOwnerDocument(), destFile);
        }
        catch (IOException e) {
            throw new BuildException("Unable to write test aggregate to '" + destFile + "'", (Throwable)e);
        }
        Enumeration enumeration = this.transformers.elements();
        while (enumeration.hasMoreElements()) {
            AggregateTransformer transformer = (AggregateTransformer)enumeration.nextElement();
            transformer.setXmlDocument(rootElement.getOwnerDocument());
            transformer.transform();
        }
    }

    protected File getDestinationFile() {
        if (this.toFile == null) {
            this.toFile = DEFAULT_FILENAME;
        }
        if (this.toDir == null) {
            this.toDir = ((ProjectComponent)this).project.resolveFile(DEFAULT_DIR);
        }
        return new File(this.toDir, this.toFile);
    }

    protected File[] getFiles() {
        Vector<File> v = new Vector<File>();
        int size = this.filesets.size();
        for (int i = 0; i < size; ++i) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(((ProjectComponent)this).project);
            ds.scan();
            String[] f = ds.getIncludedFiles();
            for (int j = 0; j < f.length; ++j) {
                String pathname = f[j];
                if (!pathname.endsWith(".xml")) continue;
                File file = new File(ds.getBasedir(), pathname);
                file = ((ProjectComponent)this).project.resolveFile(file.getPath());
                v.addElement(file);
            }
        }
        Object[] files = new File[v.size()];
        v.copyInto(files);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeDOMTree(Document doc, File file) throws IOException {
        FileOutputStream out = null;
        PrintWriter wri = null;
        try {
            out = new FileOutputStream(file);
            wri = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF8"));
            wri.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            new DOMElementWriter().write(doc.getDocumentElement(), (Writer)wri, 0, "  ");
            wri.flush();
            if (wri.checkError()) {
                throw new IOException("Error while writing DOM content");
            }
            Object var6_5 = null;
            if (wri != null) {
                wri.close();
                return;
            }
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (wri != null) {
                wri.close();
                out = null;
            }
            if (out == null) throw throwable;
            ((OutputStream)out).close();
            throw throwable;
        }
        ((OutputStream)out).close();
    }

    protected Element createDocument() {
        DocumentBuilder builder = XMLResultAggregator.getDocumentBuilder();
        Document doc = builder.newDocument();
        Element rootElement = doc.createElement("testsuites");
        doc.appendChild(rootElement);
        File[] files = this.getFiles();
        for (int i = 0; i < files.length; ++i) {
            try {
                this.log("Parsing file: '" + files[i] + "'", 3);
                Document testsuiteDoc = builder.parse("file:///" + files[i].getAbsolutePath());
                Element elem = testsuiteDoc.getDocumentElement();
                if ("testsuite".equals(elem.getNodeName())) {
                    this.addTestSuite(rootElement, elem);
                    continue;
                }
                this.log("the file " + files[i] + " is not a valid testsuite XML document", 1);
                continue;
            }
            catch (SAXException e) {
                this.log("The file " + files[i] + " is not a valid XML document. It is possibly corrupted.", 1);
                this.log(StringUtils.getStackTrace((Throwable)e), 4);
                continue;
            }
            catch (IOException e) {
                this.log("Error while accessing file " + files[i] + ": " + e.getMessage(), 0);
            }
        }
        return rootElement;
    }

    protected void addTestSuite(Element root, Element testsuite) {
        String fullclassname = testsuite.getAttribute("name");
        int pos = fullclassname.lastIndexOf(46);
        String pkgName = pos == -1 ? "" : fullclassname.substring(0, pos);
        String classname = pos == -1 ? fullclassname : fullclassname.substring(pos + 1);
        Element copy = (Element)DOMUtil.importNode(root, testsuite);
        copy.setAttribute("name", classname);
        copy.setAttribute("package", pkgName);
    }

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }
}

