/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.filter.selector;

import java.util.ArrayList;
import java.util.List;
import net.loomchild.maligna.coretypes.Alignment;
import net.loomchild.maligna.filter.Filter;
import net.loomchild.maligna.util.Util;

public class ProbabilitySelector
implements Filter {
    private double scoreThreshold;

    public ProbabilitySelector(double probabilityThreshold) {
        assert (probabilityThreshold >= 0.0 && probabilityThreshold <= 1.0);
        this.scoreThreshold = Util.toScore(probabilityThreshold);
    }

    @Override
    public List<Alignment> apply(List<Alignment> alignmentList) {
        ArrayList<Alignment> selectedAlignmentList = new ArrayList<Alignment>();
        for (Alignment alignment : alignmentList) {
            if (!((double)alignment.getScore() <= this.scoreThreshold)) continue;
            selectedAlignmentList.add(alignment);
        }
        return selectedAlignmentList;
    }
}

