/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AncillaryDataSupport;
import org.newsclub.net.unix.CleanableState;
import org.newsclub.net.unix.NativeUnixSocket;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class AFUNIXCore
extends CleanableState {
    private static final ThreadLocal<ByteBuffer> DATAGRAMPACKET_BUFFER_TL = new ThreadLocal();
    private static final int DATAGRAMPACKET_BUFFER_MIN_CAPACITY = 8192;
    private static final int DATAGRAMPACKET_BUFFER_MAX_CAPACITY = 0x100000;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    protected final FileDescriptor fd;
    protected final AncillaryDataSupport ancillaryDataSupport;

    protected AFUNIXCore(Object observed, FileDescriptor fd, AncillaryDataSupport ancillaryDataSupport) {
        super(observed);
        this.fd = fd == null ? new FileDescriptor() : fd;
        this.ancillaryDataSupport = ancillaryDataSupport;
    }

    protected AFUNIXCore(Object observed, FileDescriptor fd) {
        this(observed, fd, null);
    }

    @Override
    protected void doClean() {
        if (this.fd != null && this.fd.valid()) {
            try {
                this.doClose();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.ancillaryDataSupport != null) {
            this.ancillaryDataSupport.close();
        }
    }

    protected boolean isClosed() {
        return this.closed.get();
    }

    protected void doClose() throws IOException {
        NativeUnixSocket.close(this.fd);
        this.closed.set(true);
    }

    protected FileDescriptor validFdOrException() throws SocketException {
        FileDescriptor fdesc = this.validFd();
        if (fdesc == null) {
            this.closed.set(true);
            throw new SocketException("Not open");
        }
        return fdesc;
    }

    protected synchronized FileDescriptor validFd() {
        if (this.isClosed()) {
            return null;
        }
        FileDescriptor descriptor = this.fd;
        if (descriptor != null && descriptor.valid()) {
            return descriptor;
        }
        return null;
    }

    int read(ByteBuffer dst) throws IOException {
        return this.read(dst, null, 0);
    }

    int read(ByteBuffer dst, ByteBuffer socketAddressBuffer, int options) throws IOException {
        ByteBuffer buf;
        int remaining = dst.remaining();
        if (remaining == 0) {
            return 0;
        }
        FileDescriptor fdesc = this.validFdOrException();
        if (dst.isDirect()) {
            buf = dst;
        } else {
            buf = this.getThreadLocalDirectByteBuffer(remaining);
            remaining = Math.min(remaining, buf.remaining());
        }
        int pos = dst.position();
        int count = NativeUnixSocket.receive(fdesc, buf, pos, remaining, socketAddressBuffer, options, this.ancillaryDataSupport, 0);
        if (buf != dst) {
            buf.limit(count);
            dst.put(buf);
        } else {
            if (count < 0) {
                throw new IllegalStateException();
            }
            dst.position(pos + count);
        }
        return count;
    }

    int write(ByteBuffer src) throws IOException {
        return this.write(src, null, 0);
    }

    int write(ByteBuffer src, SocketAddress target, int options) throws IOException {
        ByteBuffer buf;
        ByteBuffer addressTo;
        int remaining = src.remaining();
        if (remaining == 0) {
            return 0;
        }
        FileDescriptor fdesc = this.validFdOrException();
        if (target == null) {
            addressTo = null;
        } else {
            addressTo = AFUNIXSocketAddress.SOCKETADDRESS_BUFFER_TL.get();
            AFUNIXSocketAddress.unwrapAddressDirectBufferInternal(addressTo, target);
        }
        options |= 4;
        if (src.isDirect()) {
            buf = src;
        } else {
            buf = this.getThreadLocalDirectByteBuffer(remaining);
            remaining = Math.min(remaining, buf.remaining());
            buf.put(src);
            buf.position(0);
        }
        int pos = buf.position();
        int written = NativeUnixSocket.send(fdesc, buf, pos, remaining, addressTo, options, this.ancillaryDataSupport);
        if (written > 0) {
            src.position(pos + written);
        }
        return written;
    }

    ByteBuffer getThreadLocalDirectByteBuffer(int capacity) {
        if (capacity > 0x100000) {
            capacity = 0x100000;
        } else if (capacity < 8192) {
            capacity = 8192;
        }
        ByteBuffer datagramPacketBuffer = DATAGRAMPACKET_BUFFER_TL.get();
        if (datagramPacketBuffer == null || capacity > datagramPacketBuffer.capacity()) {
            datagramPacketBuffer = ByteBuffer.allocateDirect(capacity);
            DATAGRAMPACKET_BUFFER_TL.set(datagramPacketBuffer);
        }
        datagramPacketBuffer.clear();
        return datagramPacketBuffer;
    }

    void implConfigureBlocking(boolean block) throws IOException {
        NativeUnixSocket.configureBlocking(this.validFdOrException(), block);
    }
}

