#%% Fedora style spec file written by Michael A. Peters
#%% It is released under Public Domain
#%% May be redistributed without this notice.
#%%
#%% THIS FILE IS JUST AN EXAMPLE!
#%%  it is not actively used (thus not guaranteed to work),
#%%  but offered to show typical changes needed when dependencies change
#%%
#%%  c.f. with the equivalent mingw64-viking.spec file as this is used
#%%  (currently to generate the Windows build)
Name:      viking
Version:   1.11
Release:   1

Summary:   GPS data editor and analyzer

Group:     Applications/Productivity
License:   GPL-2.0-or-later
URL:       http://sourceforge.net/projects/viking/
Source0:   %{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-build

BuildRequires:  curl-devel
BuildRequires:  file-devel
BuildRequires:  expat-devel
BuildRequires:  glib2-devel
BuildRequires:  gtk3-devel >= 3.22
BuildRequires:  pkgconfig
BuildRequires:  gpsd-devel
BuildRequires:  gettext perl(XML::Parser)
BuildRequires:  intltool
BuildRequires:  libxslt
BuildRequires:  libgexiv2-devel
BuildRequires:  libbz2-devel
BuildRequires:  libmagic-devel
BuildRequires:  libsqlite3-devel
BuildRequires:  libmapnik-devel
BuildRequires:  libzip-devel
BuildRequires:  liboauth-devel
BuildRequires:  json-glib-devel
BuildRequires:  libnova-devel
BuildRequires:  xz-devel
BuildRequires:  yelp-tools

%description
Viking is a free/open source program to manage GPS data.
You can import, plot and create tracks, routes and waypoints, show OSM and other maps, see real-time GPS position, control items, etc.
Other advanced capabilities include Geotagging Images, generate Maps (using Mapnik), Upload and Download tracks from OSM, Routing from OSRM, Name Searches from OSM Nominatim or Geonames and more.
It is written in mainly in C with some C++ and uses the GTK+3 toolkit.

%prep
%setup -q

%build
%configure
make %{?_smp_mflags}

%install
%make_install
%find_lang %{name}

%check
make test

%files -f %{name}.lang
%defattr(-,root,root,-)
%license COPYING
%doc AUTHORS ChangeLog COPYING NEWS README.md TODO doc/
%{_bindir}/viking
%{_datadir}/viking
%{_datadir}/applications/viking.desktop
%{_datadir}/icons/hicolor/48x48/apps/viking.png
%{_mandir}/man1/*

%changelog
* Thu Feb 21 2008 Michael A. Peters <mpeters@mac.com> - 0.9.3.20080220-1
- change License field from GPL to GPLv2
- BR gpsd-devel
- BR gettext perl(XML::Parser) - needed for intltool
- use find_land macro to package mo files

* Sun Sep  4 2007 Guilhem Bonnefille <guilhem.bonnefille> - 0.9.2-1
- Update to upstream version 0.9.2.

* Sun Sep  2 2007 Guilhem Bonnefille <guilhem.bonnefille> - 0.9.1-1
- Update to upstream version 0.9.1.

* Fri Jul 13 2007 Guilhem Bonnefille <guilhem.bonnefille> - 0.9-1
- Update to upstream version 0.9.

* Thu May 18 2007 Quy Tonthat <qtonthat@gmail.com>
- Added curl-devel to BuildRequires list.

* Thu May 15 2007 Guilhem Bonnefille <guilhem.bonnefille> - 0.1.3-1
- Update to upstream version 0.1.3.

* Wed Feb 14 2007 Michael A. Peters <mpeters@mac.com> - 0.1.2-1
- Initial Fedora style spec file.
