/*
 * Simulator of microcontrollers (dcmovrr.h)
 *
 * Copyright (C) 2022 Drotos Daniel
 * 
 * To contact author send email to dr.dkdb@gmail.com
 *
 */

/* This file is part of microcontroller simulator: ucsim.

UCSIM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

UCSIM is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with UCSIM; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA. */
/*@1@*/

#ifndef DCMOVRR_HEADER
#define DCMOVRR_HEADER

#define MOV_AA	instruction_7f
#define MOV_AB	instruction_78
#define MOV_AC	instruction_79
#define MOV_AD	instruction_7a
#define MOV_AE	instruction_7b
#define MOV_AH	instruction_7c
#define MOV_AL	instruction_7d
#define MOV_AM	instruction_7e

#define MOV_BA	instruction_47
#define MOV_BB	instruction_40
#define MOV_BC	instruction_41
#define MOV_BD	instruction_42
#define MOV_BE	instruction_43
#define MOV_BH	instruction_44
#define MOV_BL	instruction_45
#define MOV_BM	instruction_46

#define MOV_CA	instruction_4f
#define MOV_CB	instruction_48
#define MOV_CC	instruction_49
#define MOV_CD	instruction_4a
#define MOV_CE	instruction_4b
#define MOV_CH	instruction_4c
#define MOV_CL	instruction_4d
#define MOV_CM	instruction_4e

#define MOV_DA	instruction_57
#define MOV_DB	instruction_50
#define MOV_DC	instruction_51
#define MOV_DD	instruction_52
#define MOV_DE	instruction_53
#define MOV_DH	instruction_54
#define MOV_DL	instruction_55
#define MOV_DM	instruction_56

#define MOV_EA	instruction_5f
#define MOV_EB	instruction_58
#define MOV_EC	instruction_59
#define MOV_ED	instruction_5a
#define MOV_EE	instruction_5b
#define MOV_EH	instruction_5c
#define MOV_EL	instruction_5d
#define MOV_EM	instruction_5e

#define MOV_HA	instruction_67
#define MOV_HB	instruction_60
#define MOV_HC	instruction_61
#define MOV_HD	instruction_62
#define MOV_HE	instruction_63
#define MOV_HH	instruction_64
#define MOV_HL	instruction_65
#define MOV_HM	instruction_66

#define MOV_LA	instruction_6f
#define MOV_LB	instruction_68
#define MOV_LC	instruction_69
#define MOV_LD	instruction_6a
#define MOV_LE	instruction_6b
#define MOV_LH	instruction_6c
#define MOV_LL	instruction_6d
#define MOV_LM	instruction_6e

#define MOV_MA	instruction_77
#define MOV_MB	instruction_70
#define MOV_MC	instruction_71
#define MOV_MD	instruction_72
#define MOV_ME	instruction_73
#define MOV_MH	instruction_74
#define MOV_ML	instruction_75

#endif

/* End of i8085.src/dcmovrr.h */
