# MD045 - Add Descriptive Text to Images

Aliases: `no-alt-text`

## What this rule does

Ensures all images include alternative text (alt text) that describes the image content for accessibility and fallback display.

## Why this matters

- **Accessibility**: Screen readers need alt text to describe images to visually impaired users
- **Broken images**: Alt text displays when images fail to load
- **SEO benefits**: Search engines use alt text to understand and index images
- **Professional quality**: Missing alt text looks like an oversight

## Examples

### ✅ Correct

```markdown
![Company logo](images/logo.png)

![Graph showing 40% increase in sales](charts/q4-sales.png)

![Screenshot of the login page with username and password fields](screenshots/login.png)

![Team photo from the 2024 company retreat](photos/team-retreat-2024.jpg)
```

### ❌ Incorrect  

```markdown
![](images/logo.png)                <!-- Empty alt text -->

![ ](charts/q4-sales.png)           <!-- Just spaces -->

![  ](screenshots/login.png)        <!-- Still just spaces -->

![](photos/team-retreat-2024.jpg)   <!-- No description at all -->
```

### 🔧 Fixed

```markdown
![TODO: Add image description](images/logo.png)           <!-- Default placeholder added -->

![TODO: Add image description](charts/q4-sales.png)       <!-- Needs meaningful description -->

![TODO: Add image description](screenshots/login.png)     <!-- Needs meaningful description -->

![TODO: Add image description](photos/team-retreat-2024.jpg) <!-- Needs meaningful description -->
```

## Configuration

```toml
[MD045]
placeholder-text = "TODO: Add image description"  # Text to insert for missing alt text
```

### Options

- **placeholder-text** (default: `"TODO: Add image description"`) - The text to insert when fixing images with missing alt text. You can customize this to match your team's conventions.

### Example custom configuration

```toml
[MD045]
placeholder-text = "FIXME: Add alt text"
```

This would change the fix behavior to:

```markdown
![FIXME: Add alt text](image.jpg)
```

## Automatic fixes

When enabled, this rule will:

- Add generic "Image" text for missing alt text
- You must replace this with meaningful descriptions
- Consider what information the image conveys

## Writing good alt text

- Be concise but descriptive
- Describe the content, not just "image of..."
- Include relevant data from charts or graphs
- Mention important text shown in screenshots

## Special cases

- Decorative images might use empty alt text in HTML, but Markdown requires some text
- The rule only checks Markdown image syntax, not HTML `<img>` tags
- Reference-style images are also checked

## Learn more

- [WebAIM alt text guide](https://webaim.org/techniques/alttext/)
- [W3C alt text decision tree](https://www.w3.org/WAI/tutorials/images/decision-tree/)
- [CommonMark specification for images](https://spec.commonmark.org/0.31.2/#images)

## Related rules

- [MD033](md033.md) - Control HTML usage in Markdown
- [MD042](md042.md) - Avoid empty links
- [MD052](md052.md) - Validate reference links and images
