# MD041 - Start Your Document with a Clear Title

Aliases: `first-line-heading`, `first-line-h1`

## What this rule does

Ensures every document begins with a top-level heading (like `# Title`), giving your document a clear title and purpose from the start.

## Why this matters

- **Professional appearance**: Documents without titles look incomplete and unprofessional
- **Better navigation**: Readers and tools can quickly identify what the document is about
- **Improved SEO**: Search engines and documentation systems rely on document titles
- **Consistent structure**: All documents in your project will have a uniform starting point

## Examples

### ✅ Correct

```markdown
# Getting Started Guide

Welcome to our documentation! This guide will help you...
```

```markdown
# Project README

This project provides tools for...
```

Also correct with HTML headings:

```markdown
<h1>Getting Started Guide</h1>

Welcome to our documentation! This guide will help you...
```

Also correct with HTML comments before the heading:

```markdown
<!-- This is a comment -->
# Getting Started Guide

Welcome to our documentation! This guide will help you...
```

### ❌ Incorrect

```markdown
Welcome to our documentation! This guide will help you...

## Installation

First, install the dependencies...
```

```markdown
This project provides tools for...

Some more content here.
```

### 🔧 Fixed

```markdown
# Documentation

Welcome to our documentation! This guide will help you...

## Installation

First, install the dependencies...
```

## Configuration

```toml
[MD041]
level = 1  # Heading level required (1-6, default: 1)
front-matter-title = "title"  # Front matter field to use as title
front-matter-title-pattern = "^(title|header):"  # Regex pattern to match title fields in front matter
fix = false  # Enable auto-fix (default: false)
```

## Automatic fixes

By default, this rule does not provide automatic fixes because adding a document title is typically a content decision. However, you can enable opt-in auto-fix with `fix = true`.

When enabled, the fixer will:

1. **Fix wrong heading level**: If the first content is a heading with the wrong level (e.g., `## Title` when level 1 is required), rewrite it to the correct level (`# Title`)
2. **Move heading above preamble**: If a heading appears after only "preamble" (blank lines, HTML comments), move it to the start of the content

The fixer will **not** change content when:

- There is no heading in the document (cannot invent content)
- Real content appears before the first heading (unsafe to move)
- The document already has the correct heading at the correct position

## Special cases

- Documents with front matter containing a title field are considered valid
- Empty documents are not checked
- HTML comments at the start are ignored when checking
- HTML heading tags (e.g., `<h1>Title</h1>`) are recognized as valid headings
- The `front_matter_title_pattern` allows custom regex patterns for matching title fields
- In MkDocs flavor, anchor lines like `[](){ #anchor }` are skipped as non-content

## Learn more

- [CommonMark specification for headings](https://spec.commonmark.org/0.31.2/#atx-headings)
- [Writing good documentation titles](https://www.writethedocs.org/guide/writing/beginners-guide-to-docs/#structure)

## Related rules

- [MD001](md001.md) - Keep heading levels organized
- [MD003](md003.md) - Use consistent heading styles
- [MD025](md025.md) - Use only one main title per document
