# MD038 - Remove extra spaces in code

Aliases: `no-space-in-code`

## What this rule does

Removes unnecessary spaces between backticks and code content in inline code spans.

## Why this matters

- **Clean formatting**: Extra spaces make code snippets look unpolished
- **Accurate code**: Leading/trailing spaces might be mistaken as part of the code
- **Consistent appearance**: Code should be formatted the same way throughout
- **Better readability**: Clear boundaries between code and regular text

## Examples

<!-- rumdl-disable MD038 -->

### ✅ Correct

Code directly touches the backticks:

```markdown
Use the `print()` function to display output.

Call `getUserName()` to get the current user.

The variable `isEnabled` stores the state.
```

### ❌ Incorrect

Extra spaces inside backticks:

```markdown
Use the ` print()` function to display output.

Call `getUserName() ` to get the current user.

The variable ` isEnabled ` stores the state.
```

### 🔧 Fixed

Spaces removed from edges:

```markdown
Use the `print()` function to display output.

Call `getUserName()` to get the current user.

The variable `isEnabled` stores the state.
```

<!-- rumdl-enable MD038 -->

## Configuration

This rule has no configuration options.

## Flavor-specific behavior

### Obsidian flavor

When using `--flavor obsidian`, this rule recognizes **Dataview plugin** inline queries and does not flag them as spacing errors:

<!-- rumdl-disable MD038 -->
- **Inline DQL**: `` `= expression` `` - Queries that start with `= `
- **Inline DataviewJS**: `` `$= expression` `` - JavaScript expressions that start with `$= `
<!-- rumdl-enable MD038 -->

Examples that are valid in Obsidian flavor:

```markdown
The file name is `= this.file.name` and it was modified on `= this.file.mtime`.

Page count: `$= dv.pages('#project').length` projects found.

Status: `= choice(this.done, "✅", "⏳")`
```

Note: These expressions don't have leading whitespace issues in practice since the `=` or `$=` comes directly after the opening backtick. The Dataview check serves as additional protection for edge cases.

### MkDocs flavor

When using `--flavor mkdocs`, this rule allows **InlineHilite** syntax for syntax-highlighted inline code:

```markdown
Use `#!python print("hello")` for inline Python highlighting.
```

### Quarto flavor

When using `--flavor quarto`, this rule allows inline R code expressions:

```markdown
The result is `r nchar("test")` which equals 4.
```

## Automatic fixes

This rule will:

- Remove spaces after opening backticks
- Remove spaces before closing backticks
- Preserve spaces within the code itself
- Handle multiple code spans on the same line

## Learn more

- [CommonMark specification for code spans](https://spec.commonmark.org/0.31.2/#code-spans)

## Related rules

- [MD037 - Spaces inside emphasis markers](md037.md) - Similar rule for bold and italic text
