# MD069 - No duplicate list markers

Aliases: `no-duplicate-list-markers`

## What this rule does

Detects duplicate list markers that typically occur from copy-paste with editor auto-list-continuation, such as `- - text` instead of `- text`.

## Why this matters

- **Unintended nesting**: CommonMark parses `- - text` as a nested list, which is almost never the intended behavior
- **Visual confusion**: The extra marker clutters the document and creates unexpected formatting
- **Copy-paste artifacts**: This pattern commonly occurs when copying list items while editors auto-continue lists
- **Easy to overlook**: The duplicate marker blends in and can be missed during review

## Examples

### ✅ Correct

```markdown
- First item
- Second item
- Third item
```

### ❌ Incorrect

<!-- rumdl-disable MD069 -->

```markdown
- - First item (accidental duplicate)
* * Second item
- * Mixed markers
```

<!-- rumdl-enable MD069 -->

### 🔧 Fixed

```markdown
- First item
* Second item
* Mixed markers
```

## How this happens

This pattern typically occurs when:

1. **Copy-paste in editors**: You copy a list item, move to the next line (where the editor auto-inserts a list marker), then paste. Result: two markers.

2. **Double keystroke**: Accidentally pressing the marker key twice.

3. **Merge conflicts**: Git merge artifacts can create duplicate markers.

## Configuration

This rule has no configuration options.

## Automatic fixes

This rule automatically removes the first list marker, keeping the second one. For example:

- `- - text` becomes `- text`
- `* * text` becomes `* text`
- `- * text` becomes `* text` (keeps the second marker)

Indentation is preserved during the fix.

## What this rule does NOT flag

- `- --flag` - CLI flags (the second `-` is not followed by a space)
- `* *emphasis*` - Emphasis markers (the second `*` starts emphasis, not a list)
- `- **bold**` - Bold text starting a list item
- Properly indented nested lists - these are intentional

## Learn more

- [CommonMark list specification](https://spec.commonmark.org/0.31.2/#lists) - How lists are parsed
- [Nested lists](https://www.markdownguide.org/basic-syntax/#nested-lists) - How to create intentional nested lists

## Related rules

- [MD004](md004.md) - Consistent unordered list style
- [MD007](md007.md) - Unordered list indentation
- [MD030](md030.md) - Spaces after list markers
