

#ifndef __STACKING_H
#define __STACKING_H

typedef enum {
	LAYER_DESKTOP,
	LAYER_BELOW,
	LAYER_NORMAL,
	LAYER_ABOVE,
	LAYER_FULLSCREEN
} WindowLayer;

extern GList *clients;
extern GArray *client_list, *client_list_stacking;


WindowLayer client_layer(Client * c);
void put_on_top_of_stack(Client * c);
void shuffle_below_normal_layer(Client * c);
void client_lower(Client * c);
void client_lower_force(Client * c);
void cancel_pending_raise(void);
void apply_raise_policy(Client *c);
gboolean delayed_raise(gpointer data);
void client_raise(Client * c);
void client_inc_layer(Client * c);
void client_dec_layer(Client * c);

Client *clientGetTopMost(int layer);
Client *clientGetBottomMost(int layer);

#endif
