---
authors: "sosukesuzuki"
title: "Prettier 3.3: New Flow features and a lot of bug fixes"
---

This release includes support for new Flow features such as component and hook declarations. All of these features were implemented by the engineers on the Flow team, thank you.

If you appreciate Prettier and would like to support our work, please consider sponsoring us directly via [our OpenCollective](https://opencollective.com/prettier) or by sponsoring the projects we depend on, such as [typescript-eslint](https://opencollective.com/typescript-eslint), [remark](https://opencollective.com/unified), and [Babel](https://opencollective.com/babel). Thank you for your continued support!

<!-- truncate -->

## Highlights

### Flow

#### `declare namespace` printing support ([#16066](https://github.com/prettier/prettier/pull/16066) by [@SamChou19815](https://github.com/SamChou19815))

<!-- prettier-ignore -->
```jsx
// Input
declare namespace foo {
  declare var bar: string;
}

// Prettier 3.2
// does not parse

// Prettier 3.3
declare namespace foo {
  declare var bar: string;
}
```

#### Component syntax printing support ([#16191](https://github.com/prettier/prettier/pull/16191) by [@SamChou19815](https://github.com/SamChou19815))

<!-- prettier-ignore -->
```jsx
// Input
component MyComponent(a: string, b: number) renders SomeComponent {
  return <OtherComponent />;
}
hook useMyHook(a: string) {
  return useState(a);
}

// Prettier 3.2
// does not parse

// Prettier 3.3
component MyComponent(a: string, b: number) renders SomeComponent {
  return <OtherComponent />;
}
hook useMyHook(a: string) {
  return useState(a);
}
```

#### Support big int Enums ([#16268](https://github.com/prettier/prettier/pull/16268) by [@gkz](https://github.com/gkz))

Adds support for big int [Flow Enums](https://flow.org/en/docs/enums/).

<!-- prettier-ignore -->
```jsx
// Input
enum E {
  A = 0n,
  B = 1n,
}

// Prettier 3.2
// error

// Prettier 3.3
enum E {
  A = 0n,
  B = 1n,
}
```

#### Support inexact tuple types ([#16271](https://github.com/prettier/prettier/pull/16271) by [@gkz](https://github.com/gkz))

Adds support for Flow's inexact tuple types.

<!-- prettier-ignore -->
```jsx
// Input
type T = [number, ...];

// Prettier 3.2
type T = [number];

// Prettier 3.3
type T = [number, ...];
```

#### Support 'implies' type guard variant ([#16272](https://github.com/prettier/prettier/pull/16272) by [@gkz](https://github.com/gkz))

Adds support for Flow's `implies` type guard variant. Also updates the `flow-parser` dependency.

<!-- prettier-ignore -->
```jsx
// Input
declare function f(x: mixed): implies x is T;

// Prettier 3.2
// error

// Prettier 3.3
declare function f(x: mixed): implies x is T;
```

## Other Changes

### JavaScript

#### Unquote keys in import attributes ([#15888](https://github.com/prettier/prettier/pull/15888) by [@sosukesuzuki](https://github.com/sosukesuzuki))

<!-- prettier-ignore -->
```jsx
// Input
import json from "./mod.json" with { "type": "json" };

// Prettier 3.2
import json from "./mod.json" with { "type": "json" };

// Prettier 3.3
import json from "./mod.json" with { type: "json" };
```

#### Fix unstable object print ([#16058](https://github.com/prettier/prettier/pull/16058) by [@fisker](https://github.com/fisker))

<!-- prettier-ignore -->
```jsx
// Input
a = {"\a": 1, "b": 2}

// Prettier 3.2 (--quote-props consistent)
a = { "a": 1, "b": 2 };

// Prettier 3.2 (--quote-props as-needed)
a = { "a": 1, b: 2 };

// Prettier 3.3
a = { a: 1, b: 2 };
```

#### Format embedded GQL in template literal statements ([#16064](https://github.com/prettier/prettier/pull/16064) by [@keithlayne](https://github.com/keithlayne))

<!-- prettier-ignore -->
```jsx
// Input
/* GraphQL */ `
  query foo { id }
`;

// Prettier 3.2
/* GraphQL */ `
  query foo { id }
`;

// Prettier 3.3
/* GraphQL */ `
  query foo {
    id
  }
`;
```

#### Improve formatting of React `useImperativeHandle` hook ([#16070](https://github.com/prettier/prettier/pull/16070) by [@Jaswanth-Sriram-Veturi](https://github.com/Jaswanth-Sriram-Veturi))

<!-- prettier-ignore -->
```jsx
// Input
useImperativeHandle(ref, () => {
  /* Function body */
}, []);

// Prettier 3.2
useImperativeHandle(
  ref,
  () => {
    /* Function body */
  },
  [],
);

// Prettier 3.3
useImperativeHandle(ref, () => {
  /* Function body */
}, []);
```

#### Allow linebreaks in member expressions in template interpolations ([#16116](https://github.com/prettier/prettier/pull/16116) by [@bakkot](https://github.com/bakkot))

When there is already a linebreak in a template interpolation, allow it to stay there even if it is a member expression. Note that (as of [#15209](https://github.com/prettier/prettier/pull/15209)) Prettier will not insert a linebreak inside an interpolation when one is not already present.

<!-- prettier-ignore -->
```jsx
// Input
`template with ${
    very.very.very.very.very.very.very.very.very.very.very.long.chain
}`;

// Prettier 3.2
`template with ${very.very.very.very.very.very.very.very.very.very.very.long.chain}`;

// Prettier 3.3
`template with ${
  very.very.very.very.very.very.very.very.very.very.very.long.chain
}`;
```

#### Fix dynamic import when the module source is a template string ([#16267](https://github.com/prettier/prettier/pull/16267) by [@fisker](https://github.com/fisker))

<!-- prettier-ignore -->
```jsx
// Input
const module = await import(`data:text/javascript,
  console.log("RUN");
`);

// Prettier 3.2
const module = await (`data:text/javascript,
  console.log("RUN");
`);

// Prettier 3.3
const module = await import(`data:text/javascript,
  console.log("RUN");
`);
```

### TypeScript

#### Add missing parentheses to `TSInferType` ([#16031](https://github.com/prettier/prettier/pull/16031) by [@fisker](https://github.com/fisker))

<!-- prettier-ignore -->
```jsx
// Input
type Foo<T> = T extends (infer U extends number) | { a: infer U extends number }
  ? U
  : never;

// Prettier 3.2
type Foo<T> = T extends infer U extends number | { a: infer U extends number }
  ? U
  : never;

// Prettier 3.3
type Foo<T> = T extends (infer U extends number) | { a: infer U extends number }
  ? U
  : never;
```

#### Throw errors for duplicated accessibility modifiers ([#16040](https://github.com/prettier/prettier/pull/16040) by [@fisker](https://github.com/fisker), [@auvred](https://github.com/auvred))

<!-- prettier-ignore -->
```jsx
// Input
class Foo {
  public public bar() {};
}

// Prettier 3.2
class Foo {
  public bar() {}
}

// Prettier 3.3
SyntaxError: Accessibility modifier already seen. (2:10)
  1 | class Foo {
> 2 |   public public bar() {};
    |          ^^^^^^
  3 | }
```

#### Respect `--no-semi` for readonly class field ([#16133](https://github.com/prettier/prettier/pull/16133) by [@sxzz](https://github.com/sxzz))

<!-- prettier-ignore -->
```tsx
// Input
class A {
  field
  readonly [expr] = true
}

// Prettier 3.2
class A {
  field;
  readonly [expr] = true
}

// Prettier 3.3
class A {
  field
  readonly [expr] = true
}
```

#### Add necessary parentheses to yield expressions ([#16194](https://github.com/prettier/prettier/pull/16194) by [@kirkwaiblinger](https://github.com/kirkwaiblinger))

Add parentheses around yield expressions if parent is an angle-bracket type assertion.

<!-- prettier-ignore -->
```ts
// Input
function* g() {
  const y = <T>(yield x);
}

// Prettier 3.2
function* g() {
  const y = <T>yield x;
}

// Prettier 3.3
function* g() {
  const y = <T>(yield x);
}
```

### Markdown

#### Improve wrapping for code block in markdown and jsx in mdx ([#15993](https://github.com/prettier/prettier/pull/15993) by [@seiyab](https://github.com/seiyab))

<!-- prettier-ignore -->
````md
<!-- Input -->
```css
img {
  filter: drop-shadow(2px 2px 0 hsl(300deg 100% 50%)) drop-shadow(
      -2px -2px 0 hsl(210deg 100% 50%)
)
    drop-shadow(2px 2px 0 hsl(120deg 100% 50%)) drop-shadow(
      -2px -2px 0 hsl(30deg 100% 50%)
    );
}
```

<!-- Prettier 3.2 -->
```css
img {
  filter: drop-shadow(2px 2px 0 hsl(300deg 100% 50%)) drop-shadow(
      -2px -2px 0 hsl(210deg 100% 50%)
    )
    drop-shadow(2px 2px 0 hsl(120deg 100% 50%)) drop-shadow(
      -2px -2px 0 hsl(30deg 100% 50%)
    );
}
```

<!-- Prettier 3.3 -->
```css
img {
  filter: drop-shadow(2px 2px 0 hsl(300deg 100% 50%))
    drop-shadow(-2px -2px 0 hsl(210deg 100% 50%))
    drop-shadow(2px 2px 0 hsl(120deg 100% 50%))
    drop-shadow(-2px -2px 0 hsl(30deg 100% 50%));
}
```
````

<!-- prettier-ignore -->
```md
<!-- Input -->
<ExternalLink href="http://example.com">Prettier</ExternalLink> is an opinionated-code-formatter-that-support-many-languages-and-integrate-with-most-editors

<!-- Prettier 3.2 -->
<ExternalLink href="http://example.com">Prettier</ExternalLink> is an opinionated-code-formatter-that-support-many-languages-and-integrate-with-most-editors

<!-- Prettier 3.3 -->
<ExternalLink href="http://example.com">Prettier</ExternalLink> is an
opinionated-code-formatter-that-support-many-languages-and-integrate-with-most-editors
```

#### Add newline between markdown footnote definitions ([#16063](https://github.com/prettier/prettier/pull/16063) by [@Atema](https://github.com/Atema))

<!-- prettier-ignore -->
```md
<!-- Input -->
[^a]: Footnote A

[^b]: Footnote B

<!-- Prettier 3.2 -->
[^a]: Footnote A
[^b]: Footnote B

<!-- Prettier 3.3 -->
[^a]: Footnote A

[^b]: Footnote B
```

#### Improve wrapping for markdown / mdx ([#16158](https://github.com/prettier/prettier/pull/16158) by [@seiyab](https://github.com/seiyab))

```json
{ "proseWrap": "always" }
```

<!-- prettier-ignore -->
```md
<!-- Input -->
\
word very-very-very-very-very-very-very-very-very-very-long-word very-very-very-very-very-very-very-very-very-very-long-word

<!-- Prettier 3.2 -->
\
word very-very-very-very-very-very-very-very-very-very-long-word very-very-very-very-very-very-very-very-very-very-long-word

<!-- Prettier 3.3 -->
\
word very-very-very-very-very-very-very-very-very-very-long-word
very-very-very-very-very-very-very-very-very-very-long-word
```

### API

#### Add support for `package.yaml` config ([#16157](https://github.com/prettier/prettier/pull/16157) by [@danielbayley](https://github.com/danielbayley))

Enable support for reading `prettier` configuration from [`package.yaml`](https://github.com/pnpm/pnpm/pull/1799).

```yaml
# package.yaml
prettier:
  semi: false
  singleQuote: true
```
