---
authors: "sosukesuzuki"
title: "Prettier 2.8: improve --cache CLI option and TypeScript 4.9 satisfies operator!"
---

This release includes improvements to the `--cache` option added in 2.7. A new `--cache-location` option has been added, and a bug that saved the cache even when `--write` wasn't specified has been fixed.

We're also adding support for TypeScript 4.9 `satisfies` operator!

If you enjoy Prettier and would like to support our work, consider sponsoring us directly via [our OpenCollective](https://opencollective.com/prettier) or by sponsoring the projects we depend on, including [typescript-eslint](https://opencollective.com/typescript-eslint), [remark](https://opencollective.com/unified), and [Babel](https://opencollective.com/babel).

The Prettier team plans to release 3.0 within the next few months. If you are a plugin developer, get ready for the migration. Visit [the migration guide](https://github.com/prettier/prettier/wiki/How-to-migrate-my-plugin-to-support-Prettier-v3%3F) and issue [#13606](https://github.com/prettier/prettier/issues/13616) for more information.

<!-- truncate -->

## Highlights

### TypeScript

#### Support TypeScript 4.9 [`satisfies` operator](https://devblogs.microsoft.com/typescript/announcing-typescript-4-9/#satisfies) ([#13764](https://github.com/prettier/prettier/pull/13764), [#13783](https://github.com/prettier/prettier/pull/13783), [#13872](https://github.com/prettier/prettier/pull/13872) by [@sosukesuzuki](https://github.com/sosukesuzuki))

<!-- prettier-ignore -->
```tsx
const palette = {
  red: [255, 0, 0],
  green: "#00ff00",
  blue: [0, 0, 255]
} satisfies Record<Colors, string | RGB>;
```

[Auto-Accessors in Classes](https://devblogs.microsoft.com/typescript/announcing-typescript-4-9/#auto-accessors-in-classes) will be supported in an upcoming 2.8 patch release. We have de-scoped them for now to ship `satisfies` operator sooner.

### CLI

#### Do not save the cache if the `--write` option wasn't specified ([#13016](https://github.com/prettier/prettier/pull/13016) by [@Milly](https://github.com/Milly))

<!-- prettier-ignore -->
```bash
# Prettier 2.7
$ prettier --cache foo.js
# This shows formatted contents of `foo.js`.
# Then cache is created and `foo.js` is flagged as already formatted.

$ prettier --cache --write foo.js
foo.js 2ms (cached)
# "... (cached)" means the file is already formatted, so nothing is done this time.

# Prettier 2.8
$ prettier --cache foo.js
# Show formatted contents of `foo.js`.

$ prettier --cache --write foo.js
foo.js 2ms
# `foo.js` is formatted now.
```

#### Add `--cache-location` option ([#13019](https://github.com/prettier/prettier/pull/13019) by [@sosukesuzuki](https://github.com/sosukesuzuki))

By default, Prettier CLI saves the cache file for the `--cache` option at `./node_modules/.cache/prettier/.prettier-cache`. This can be overridden now:

```bash
prettier --write --cache --cache-location=my_cache_file src
```

## Other Changes

### JavaScript

#### Fix docblock parsing ([#13054](https://github.com/prettier/prettier/pull/13054) by [@fisker](https://github.com/fisker))

<!-- prettier-ignore -->
```jsx
// With `--insert-pragma` flag

// Input
/* comment */
foo()

// Prettier 2.7
/**
 * /* comment
 *
 * @format
 */

foo();

// Prettier 2.8
/**
 * comment
 *
 * @format
 */

foo();
```

#### Fix range format for function bodies ([#13173](https://github.com/prettier/prettier/pull/13173) by [@thorn0](https://github.com/thorn0))

<!-- prettier-ignore -->
```jsx
// Input
let fn = (() => {
  return; //
//^^^^^^^^^^ - range
});

// Prettier 2.7
let fn = (() => {
  return; //
};);

// Prettier 2.8
let fn = (() => {
  return; //
});
```

#### Fix inconsistent formatting for multiline strings ([#13274](https://github.com/prettier/prettier/pull/13274) by [@GlebDolzhikov](https://github.com/GlebDolzhikov))

<!-- prettier-ignore -->
```jsx
// Input
const loremIpsumFooBazBar1 = 'Multiline string\
         Multiline string\
'

const loremIpsumFooBazBar2 = 'Multiline string\
         Multiline string\
         Multiline string'

// Prettier 2.7
const loremIpsumFooBazBar1 = "Multiline string\
         Multiline string\
";

const loremIpsumFooBazBar2 =
  "Multiline string\
         Multiline string\
         Multiline string";

// Prettier 2.8
const loremIpsumFooBazBar1 =
  "Multiline string\
         Multiline string\
";

const loremIpsumFooBazBar2 =
  "Multiline string\
         Multiline string\
         Multiline string";
```

### TypeScript

#### Fix parens in inferred function return types with `extends` ([#13289](https://github.com/prettier/prettier/pull/13289) by [@GlebDolzhikov](https://github.com/GlebDolzhikov))

<!-- prettier-ignore -->
```ts
// Input
type Foo<T> = T extends (...a: any[]) => (infer R extends string) ? R : never;

// Prettier 2.7
type Foo<T> = T extends (...a: any[]) => infer R extends string ? R : never;

// Prettier 2.8
type Foo<T> = T extends ((...a: any[]) => infer R extends string) ? R : never;
```

### CSS

#### Fix formatting of long `:is`, `:where`, and `:not` selectors ([#13577](https://github.com/prettier/prettier/pull/13577) by [@j-f1](https://github.com/j-f1))

Pseudo-selectors like `:is`, `:where`, and `:not` that can take multiple selectors as arguments are now formatted like function calls are in other languages. Previously, no special significance was attached to the commas between their “arguments,” leading to confusing wrapping behavior. There are likely still improvements to be made here — please open an issue with some example code if you find something that doesn’t look as expected.

<!-- prettier-ignore -->
```css
/* Input */
:where(
  label > input:valid,
  label > textarea:not(:empty),
  label > button[disabled]
) ~ .errors > .error { display: none; }

/* Prettier 2.7 */
:where(label > input:valid, label > textarea:not(:empty), label
    > button[disabled])
  ~ .errors
  > .error {
  display: none;
}

/* Prettier 2.8 */
:where(
    label > input:valid,
    label > textarea:not(:empty),
    label > button[disabled]
  )
  ~ .errors
  > .error {
  display: none;
}
```

### SCSS

#### Fix: extra space between '#' and '\{' ([#13286](https://github.com/prettier/prettier/pull/13286) by [@jspereiramoura](https://github.com/jspereiramoura))

<!-- prettier-ignore -->
```scss
// Input
padding: var(--spacer#{(1) + 2});

// Prettier 2.7
padding: var(--spacer# {(1) + 2});

// Prettier 2.8
padding: var(--spacer#{(1) + 2});
```

### Angular

#### Insert spaces in pipe ([#13100](https://github.com/prettier/prettier/pull/13100) by [@sosukesuzuki](https://github.com/sosukesuzuki))

<!-- prettier-ignore -->
```html
<!-- Input -->
<tui-line-chart
  [value]="chart | tuiFilter : filter : range | tuiMapper : toNumbers : range"
></tui-line-chart>

<!-- Prettier 2.7 -->
<tui-line-chart
  [value]="chart | tuiFilter: filter:range | tuiMapper: toNumbers:range"
></tui-line-chart>

<!-- Prettier 2.8 -->
<tui-line-chart
  [value]="chart | tuiFilter : filter : range | tuiMapper : toNumbers : range"
></tui-line-chart>
```

### Ember / Handlebars

#### Correctly format custom "else if" blocks ([#13507](https://github.com/prettier/prettier/pull/13507) by [@jamescdavis](https://github.com/jamescdavis))

A template transform can be used to create custom block keywords that behave similar to `if`. This updates printer-glimmer to correctly recognize and format the "else if" case when "if" is a custom keyword.

<!-- prettier-ignore -->
```hbs
{{! Input }}
{{#when isAtWork}}
  Ship that code!
{{else when isReading}}
  You can finish War and Peace eventually...
{{else}}
  Go to bed!
{{/when}}

{{! Prettier 2.7 }}
{{#when isAtWork}}
  Ship that code!
{{else}}{{#when isReading}}
    You can finish War and Peace eventually...
  {{else}}
    Go to bed!
  {{/when}}{{/when}}

{{! Prettier 2.8 }}
{{#when isAtWork}}
  Ship that code!
{{else when isReading}}
  You can finish War and Peace eventually...
{{else}}
  Go to bed!
{{/when}}
```

### Markdown

#### Preserve inline code line breaks if `--prose-wrap=preserve` ([#11373](https://github.com/prettier/prettier/pull/11373) by [@andersk](https://github.com/andersk))

<!-- prettier-ignore -->
```markdown
<!-- Input -->
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod `tempor
incididunt` ut labore et dolore magna aliqua.

<!-- Prettier 2.7 -->
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod `tempor incididunt` ut labore et dolore magna aliqua.

<!-- Prettier 2.8 -->
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod `tempor
incididunt` ut labore et dolore magna aliqua.
```

### MDX

#### Improve MDX range ignore support ([#12208](https://github.com/prettier/prettier/pull/12208) by [@nickrttn](https://github.com/nickrttn))

Adds support for using Markdown [range ignore](https://prettier.io/docs/ignore#range-ignore) directives in MDX, using JSX comments.

<!-- prettier-ignore -->
```mdx
// Input
{/* prettier-ignore-start */}

export const Hello = () => {
  return (<p>
  Hello</p>)
}

{/* prettier-ignore-end */}

// Prettier 2.7 (throws an error)
TypeError: Cannot read properties of undefined (reading 'type')

// Prettier 2.8
{/* prettier-ignore-start */}

export const Hello = () => {
  return (<p>
  Hello</p>)
}

{/* prettier-ignore-end */}
```

### API

#### "Doc Explorer" mode for the Playground ([#10183](https://github.com/prettier/prettier/pull/10183) by [@thorn0](https://github.com/thorn0))

Switch the `parser` option to the special `doc-explorer` value to play with Prettier's intermediate representation and see how it's printed with different options.

#### Fix doc printer issue when using `ifBreak` inside `group` ([#12362](https://github.com/prettier/prettier/pull/12362) by [@fisker](https://github.com/fisker))

<!-- prettier-ignore -->
```jsx
// Input
//                                                                              |80
for (const number of [123_123_123, 123_123_123, 123_123_123, 123_123_123, 12]) {
}

// Prettier 2.7
for (const number of [
  123_123_123, 123_123_123, 123_123_123, 123_123_123, 12,
]) {
}

// Prettier 2.8
for (const number of [123_123_123, 123_123_123, 123_123_123, 123_123_123, 12]) {
}
```

#### "Rethrow embed errors" checkbox on the Playground ([#13227](https://github.com/prettier/prettier/pull/13227) by [@thorn0](https://github.com/thorn0))

Previously, the behavior of the Playground was confusingly inconsistent with the local behavior of Prettier in that it surfaced parsing errors in embedded languages for debug purposes. Now this behavior is controlled by a checkbox and disabled by default.

### CLI

#### Infer parser for `.lintstagedrc` ([#13081](https://github.com/prettier/prettier/pull/13081) by [@OrRosenblatt](https://github.com/OrRosenblatt))

A `.lintstagedrc` file (without extension) is handled using `json` and `yaml` parsers.
