import { hardline, join, replaceEndOfLine } from "../../document/index.js";
import { locEnd, locStart } from "../loc.js";
import isBlockComment from "../utilities/is-block-comment.js";
import isIndentableBlockComment from "../utilities/is-indentable-block-comment.js";
import isLineComment from "../utilities/is-line-comment.js";

function printComment(path, options) {
  const comment = path.node;

  if (isLineComment(comment)) {
    // Supports `//`, `#!`, `<!--`, and `-->`
    return options.originalText
      .slice(locStart(comment), locEnd(comment))
      .trimEnd();
  }

  if (isIndentableBlockComment(comment)) {
    return printIndentableBlockComment(comment);
  }

  if (isBlockComment(comment)) {
    return ["/*", replaceEndOfLine(comment.value), "*/"];
  }

  /* c8 ignore next */
  throw new Error("Not a comment: " + JSON.stringify(comment));
}

function printIndentableBlockComment(comment) {
  const lines = comment.value.split("\n");

  return [
    "/*",
    join(
      hardline,
      lines.map((line, index) =>
        index === 0
          ? line.trimEnd()
          : " " + (index < lines.length - 1 ? line.trim() : line.trimStart()),
      ),
    ),
    "*/",
  ];
}

export { printComment };
