//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

//
// QEMU Virtual System Controller
//

#pragma once

#include "device.h"

class QemuSysCtlrDevice : public IODevice
{
	using inherited = IODevice;

	static const uint32 FEATURES = 0x00000001;

 public:
	QemuSysCtlrDevice();
	~QemuSysCtlrDevice() override;

 protected:
	// BusIO インタフェース
	static const uint32 NPORT = 0x100 >> 2;
	busdata ReadPort(uint32 offset);
	busdata WritePort(uint32 offset,  uint32 data);
	busdata PeekPort(uint32 offset);
};
