//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// 文字列操作
//

#pragma once

#include "header.h"
#include <vector>

extern std::string string_format(const char *fmt, ...) __printflike(1, 2);

// 先頭の連続する空白文字列を取り除いた新しい文字列を返す
extern std::string string_ltrim(const std::string& str);

// 末尾の連続する空白文字列を取り除く
extern void string_rtrim(std::string& str);

// 末尾の連続する空白文字列を取り除く (char *版)
extern void rtrim(char *str);

// 文字列 str から先頭と末尾の連続する空白文字を取り除いた新しい文字列を返す。
extern std::string string_trim(const std::string& str);

// 文字列中の ASCII 大文字を小文字に、小文字を大文字にした新しい文字列を返す。
extern std::string string_tolower(const std::string& str);
extern std::string string_toupper(const std::string& str);

// 文字列 lhs の先頭が rhs と大文字小文字の区別なしで一致すれば true を返す。
// ASCII 専用。
extern bool
starts_with_ignorecase(const std::string& lhs, const std::string& rhs);

// 文字列 str (長さ len) を文字 c で分割したリストを返す
// (実際には以下2つのどちらかを呼ぶことになるはず)。
//
// str に c が含まれてなければ str 全体が1つの要素。
// c が str の先頭あるいは末尾にあれば、先頭(末尾) に空要素が出来る。
// 連続する c は同一の区切りとはみなさない。
// c は ',' のようなのを想定している。
// nlimit は戻り値リストの最大要素数で、0 なら指定なし。
extern std::vector<std::string> string_split(const char *str, int len, char c,
	int nlimit = 0);

// 文字列 str を文字 c で分割したリストを返す。
inline std::vector<std::string> string_split(const char *str, char c,
	int nlimit = 0) {
	return string_split(str, strlen(str), c, nlimit);
}
// 文字列 str を文字 c で分割したリストを返す。
inline std::vector<std::string> string_split(const std::string& str,
		char c, int nlimit = 0) {
	return string_split(str.c_str(), str.size(), c, nlimit);
}

// val を3桁ずつカンマ区切りした文字列にして返す。
extern std::string format_number(uint64 val);

// val を width 桁ゼロ埋めした 16進数文字列にして返す。
extern std::string strhex(uint32 val, int width = 8);

// 経過時刻 t を文字列にして返す。(フル版)
extern const std::string TimeToStr(uint64 t);
// 経過時刻 t を文字列にして返す。(10秒未満のみの短縮版)
extern const std::string SecToStr(uint64 t);
