/*
 * Copyright (C) 2020 isaki@NetBSD.org
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

//
// autofd
//

#pragma once

#include <unistd.h>

// 自動変数みたいな生存期間を持つディスクリプタ
class autofd
{
 public:
	autofd() {
		fd = -1;
	}
	autofd(int fd_) {
		fd = fd_;
	}

	~autofd() {
		Close();
	}

	autofd& operator=(int fd_) {
		fd = fd_;
		return *this;
	}
	operator int() const {
		return fd;
	}

	// 明示的にクローズする
	int Close() {
		int rv = 0;
		if (Valid()) {
			rv = close(fd);
			fd = -1;
		}
		return rv;
	}

	// fd が有効なら true を返す
	bool Valid() const {
		return (fd >= 0);
	}

 private:
	int fd;
};
