//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// シリアルポートのドライバ(基本クラス)
//

#pragma once

#include "driver.h"

class COMDriver : public Driver
{
	using inherited = Driver;

 protected:
	COMDriver(HostDevice *hostdev_, const char *drivername_);
 public:
	~COMDriver() override;

	// VM に送信するデータを返す。送信しないなら負数(NODATA)を返す。
	virtual int Read() = 0;

	// データを外部に出力する。
	virtual void Write(uint32 data) = 0;
};
