//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// デバッガ (HD64180 依存部分)
//

#pragma once

#include "debugger_private.h"
#include "mpu64180.h"
#include "hd64180disasm.h"

class DebuggerMD_hd64180 : public DebuggerMD
{
	using inherited = DebuggerMD;
 public:
	explicit DebuggerMD_hd64180(Debugger *parent_);
	~DebuggerMD_hd64180() override;

	CPUState GetCPUState() const override;
	bool IsSuper() const override		{ return true; }	// ?
	bool MMUEnabled() const override	{ return true; }
	busaddr TranslateAddr(busaddr laddr) const override;
	uint32 GetPC() const override { return cpu->reg.pc; }
	int32 GetAndResetLastVector() override {
		return cpu->GetAndResetLastVector();
	}

	void SetStepOut() override;
	bool IsStepOut() const override;
	bool IsOpStepIn(DebuggerMemoryStream& mem) override;

	uint64 GetRegAddr(const char *name) const override;
	void BackupRegs() override;
	bool ShowRegister(FILE *, const std::vector<std::string>& args) override;
	const HelpMessages& GetHelpListReg() const override;
	const HelpMessages& GetHelpReg() const override;

	bool CheckLEA(uint32 laddr) override { return false; }

	std::string Disassemble(DebuggerMemoryStream& mem) override;
	std::string ParseInst(const std::string&) const override;

 private:
	std::string FlagStr(const hd64180flag& f);
	bool ShowRegMain(FILE *);
	bool ShowRegOther(FILE *);
	const char *CondStr(const std::vector<uint8>&) const;

	MPU64180Device *cpu {};
	hd64180reg prev {};			// 前回のレジスタセットのコピー
	uint8 prev_i {};

	uint16 so_sp {};		// ステップアウト判定用

	static const HelpMessages HelpListReg;
	static const HelpMessages HelpReg;
};
