// SPDX-License-Identifier: GPL-2.0-only
/*
 * libstring.h -- String manipulation library header
 * (C)Copyright 2000-2024 by Hiroshi Takekawa
 * This file is part of multiskkserv.
 *
 * Last Modified: Sat Feb 24 15:52:31 2024.
 */

#ifndef _LIBSTRING_H
#define _LIBSTRING_H

typedef struct _string String;

struct _string {
  unsigned int len;
  unsigned int buffer_size;
  char *buffer;

  char *(*get)(String *);
  unsigned int (*length)(String *);
  int (*set)(String *, const char *);
  int (*copy)(String *, String *);
  int (*cat_ch)(String *, char);
  int (*cat)(String *, const char *);
  int (*append)(String *, String *);
  void (*shrink)(String *, unsigned int);
  String *(*dup)(String *);
  void (*destroy)(String *);
};

#define string_buffer_size(s) (s)->buffer_size
#define string_buffer(s) (s)->buffer
#define string_length(s) (s)->len

#define string_get(s) (s)->get((s))
#define string_set(s, p) (s)->set((s), (p))
#define string_copy(s1, s2) (s1)->copy((s1), (s2))
#define string_cat_ch(s, c) (s)->cat_ch((s), (c))
#define string_cat(s, p) (s)->cat((s), (p))
#define string_append(s1, s2) (s1)->append((s1), (s2))
#define string_shrink(s, l) (s)->shrink((s), l)
#define string_dup(s) (s)->dup(s)
#define string_destroy(s) (s)->destroy(s)

String *string_create(void);

#endif
