/* move all the encoder related functions into this file */
#include "liveice.h"
/* replace all those execlp calls with execvp */
/* Gogo supports added by Steve j. Kodnik */


int check_executable(char *filename){
	int result;
	if(fork()){
		wait(&result);
	} else {
		close(0);
		close(1);
		close(2);
		open("/dev/null", O_RDONLY);
		open("/dev/null", O_WRONLY);
		open("/dev/null", O_WRONLY);
		execlp(filename,filename,NULL);
		exit(31337);
	}
	if(result==31337){
		result= 0;
	} else {
		result=1;
	}
	return result;
}


/* take a stirng and figure out how many parts are needed */
int count_command_args(char *cmd){
        int num_args;
	char *ptr;
	num_args=0;
	ptr=cmd;
	/* figure out how many fields we have... */
	while(*ptr){
	          if(isspace(*ptr)){
		          ptr++;
		  } 
		  if(isgraph(*ptr)){
		          num_args++;	    
			  while(isgraph(*ptr)){
			          ptr++;
			  }
		  }
	}
	return num_args;
}

char * get_next_arg(char **cmd){
        char *ptr,*arg,*c_arg;
	int len;

	if(*cmd==NULL){
	        return NULL;
	}
	
	ptr=*cmd;
	/* skip any whitespace */
	while(isspace(*ptr)){
	        ptr++;
	}
 
	/* check for end of line */
	if(!*ptr){
	        return NULL;
	}
	arg=ptr;
	
	while(isgraph(*ptr)){
 	        ptr++;
	}
	len=ptr-arg;
	c_arg=malloc(len +2);
	
	strncpy(c_arg,arg,len);
	c_arg[len]=0;
	/* now shift forward */
	*cmd=ptr;
	return c_arg;	
}


/* OK.... this is the routine to launch the old l3enc encoder */
int exec_encoder_l3enc(enc_struct *e_stream){
	char sr[256], br[32],ch[32];
	char *vars[64]; /* scott you lazy sod - do it right some time */
	int enc,varnum;
	char *args,*arg;
	switch(enc=fork()){
	case 0:
	  /*isolate the IO so it doesn't clobber the level meter*/
	  if(g_conf.debug<10){
	    close(0);
	    close(1);
	    close(2);
	    open("/dev/null", O_RDONLY);
	    open("/dev/null", O_WRONLY);
	    open("/dev/null", O_WRONLY);
	  }
	  nice(-10);

	  sprintf(sr, "%d", e_stream->sample_rate);
	  sprintf(br, "%d", e_stream->bitrate);
	  if(e_stream->stereo)
	    sprintf(ch,"2");
	  else
	    sprintf(ch,"1");
	  
	  varnum=0;
	  vars[varnum++]=strdup(e_stream->encoder_cmd);
	  vars[varnum++]=strdup(e_stream->sound_pipe);
	  vars[varnum++]=strdup(e_stream->mpeg_pipe);
	  vars[varnum++]=strdup("-br");
	  vars[varnum++]=br;
	  vars[varnum++]=strdup("-sr");
	  vars[varnum++]=sr;
	  vars[varnum++]=strdup("-tfc");
	  vars[varnum++]=ch;

	  /* now we get the extra vars */
	  if(e_stream->encoding_quality>90)
	    vars[varnum++]=strdup("-hq");

	  /* now stick the commands in here */
	  args=e_stream->encoder_args;
	  do {
	          arg=get_next_arg(&args);
		  if(arg) {
		          vars[varnum++]=arg;
		  }
	  } while ( arg );

	  /* now put in the null */
	  vars[varnum]=NULL;
	  execvp(e_stream->encoder_cmd,vars);	

	  /*
	  if (e_stream->encoding_quality>90) 
		  execlp(e_stream->encoder_cmd, e_stream->encoder_cmd, e_stream->sound_pipe, e_stream->mpeg_pipe, "-br", br, "-sr", sr, "-tfc", ch ,"-hq", NULL);
	  else 
	  execlp(e_stream->encoder_cmd, e_stream->encoder_cmd, e_stream->sound_pipe, e_stream->mpeg_pipe, "-br", br, "-sr", sr, "-tfc", ch, NULL);
	  */

	  sprintf(sr,"execution of %s failed - make sure it's in your $PATH moron!",e_stream->encoder_cmd);	  
	  fatal(sr);

	  break;
	case -1:
	  fatal("unable to fork() a new process for the encoder");
	}
	e_stream->enc=enc;
	return enc;
}


/* OK.... this is the routine to launch the new Fraunhoffer code */
/* this is the choice for the professional with lots of money */
int exec_encoder_mp3enc(enc_struct *e_stream){
	char sr[256], br[32],ch[32],qual[32];
	char *vars[64];
	int enc,varnum;
	char *args,*arg;
	switch(enc=fork()){
	case 0:
	  /*isolate the IO so it doesn't clobber the level meter*/
	  if(g_conf.debug<10){
	    close(2);
	    open("/dev/null", O_WRONLY);
	  }
	  close(0);
	  close(1);
	  open(e_stream->sound_pipe,O_RDONLY);
	  open(e_stream->mpeg_pipe,O_WRONLY);
	  nice(-10);
	  sprintf(sr, "%d", e_stream->sample_rate);
	  sprintf(br, "%d", e_stream->bitrate);
	  sprintf(qual, "%d", e_stream->encoding_quality/11);
	  if(e_stream->stereo)
	    sprintf(ch,"2");
	  else
	    sprintf(ch,"1");
	  varnum=0;

	  vars[varnum++]=strdup(e_stream->encoder_cmd);
	  vars[varnum++]=strdup("-br");
	  vars[varnum++]=br;
	  vars[varnum++]=strdup("-sr");
	  vars[varnum++]=sr;
	  vars[varnum++]=strdup("-nc");
	  vars[varnum++]=ch;
	  vars[varnum++]=strdup("-qual");
	  vars[varnum++]=qual;
	  vars[varnum++]=strdup("-sti");
	  vars[varnum++]=strdup("-sto");
	  /* extra variables */
	  /* now stick the commands in here */
	  args=e_stream->encoder_args;
	  do {
	          arg=get_next_arg(&args);
		  if(arg) {
		          vars[varnum++]=arg;
		  }
	  } while ( arg );

	  /* now the NULL */
	  vars[varnum]=NULL;

	  execvp(e_stream->encoder_cmd,vars);
	  /*
	  execlp(e_stream->encoder_cmd, e_stream->encoder_cmd, "-br" , br , "-sr" , sr , "-nc" , ch , "-qual" , qual , "-sti", "-sto", NULL);
	  */
	  sprintf(sr,"execution of %s failed - make sure it's in your $PATH moron!",e_stream->encoder_cmd);
	  fatal(sr);
	  break;
	case -1:
	  fatal("unable to fork() a new process for the encoder");
	}
	e_stream->enc=enc;
	return enc;
}


/* this is the version of dist10 by Andreas Johansson */
/* wopr.campus.luth.se:/pub/mpeg_layer_3 */
/* not worth bothering with any more */
int exec_encoder_AJ(enc_struct *e_stream){
	char sr[256], br[32],ch[32];
	char *vars[64];
	int enc,varnum;
	char *args,*arg;
	/*isolate the IO so it doesn't clobber the level meter*/
	switch(enc=fork()){
	case 0:
	  if(g_conf.debug<10){
	    close(1);
	    close(2);
	    open("/dev/null", O_WRONLY);
	    open("/dev/null", O_WRONLY);
	  }
	  close(0);
	  /* if you run as superuser then increase the priority */
	  nice(-10);
	  open(e_stream->sound_pipe,O_RDONLY);
	  sprintf(sr, "%f", e_stream->sample_rate/1000.0);
	  sprintf(br, "%d", e_stream->bitrate/1000);
	  if(e_stream->stereo)
	    sprintf(ch,"s");
	  else
	    sprintf(ch,"m");

	  varnum=0;
	  vars[varnum++]=strdup(e_stream->encoder_cmd);
	  vars[varnum++]=strdup("-m");
	  vars[varnum++]=ch;
	  vars[varnum++]=strdup("-s");
	  vars[varnum++]=sr;
	  vars[varnum++]=strdup("-b");
	  vars[varnum++]=br;
	  
	  /* now put extra args in here */
	  if(e_stream->copyright)
	    vars[varnum++]=strdup("-c");
	  /* now stick the commands in here */
	  args=e_stream->encoder_args;
	  do {
	          arg=get_next_arg(&args);
		  if(arg) {
		          vars[varnum++]=arg;
		  }
	  } while ( arg );
	  vars[varnum++]=strdup("-");
	  vars[varnum++]=strdup(e_stream->mpeg_pipe);
	  vars[varnum++]=NULL;

	  execvp(e_stream->encoder_cmd,vars);

	  /*
	  if(e_stream->copyright)
		  execlp(e_stream->encoder_cmd, e_stream->encoder_cmd, "-m" , ch , "-s" , sr , "-b" , br , "-c", "-" , e_stream->mpeg_pipe,  NULL);
	  else 
		  execlp(e_stream->encoder_cmd, e_stream->encoder_cmd, "-m" , ch , "-s" , sr , "-b" , br , "-" , e_stream->mpeg_pipe,  NULL);
	  */

	  sprintf(sr,"execution of %s failed - make sure it's in your $PATH moron!",e_stream->encoder_cmd);
	  fatal(sr);
	  break;
	case -1:
	  fatal("unable to fork() a new process for the encoder");
	  break;
	}
	e_stream->enc=enc;
	return enc;
}

/* LAME 3.01 support - LAME Ain't an Mp3 Encoder. */
/* Essentially a patch to dist 10 with a better psycho model */
/* http://www.sulaco.org/mp3  */
/* note the subtle change which is needed for recent versions */
/* the best free encoder */

int exec_encoder_old_lame3(enc_struct *e_stream){
	char sr[256], br[32],ch[32];
	char *vars[64];
	int enc,varnum;
	char *args,*arg;
	/*isolate the IO so it doesn't clobber the level meter*/
	switch(enc=fork()){
	case 0:
	  if(g_conf.debug<10){
	    close(1);
	    close(2);
	    open("/dev/null", O_WRONLY);
	    open("/dev/null", O_WRONLY);
	  }
	  /* if you run as superuser then increase the priority */
	  nice(-10);
	  sprintf(sr, "%f", e_stream->sample_rate/1000.0);
	  sprintf(br, "%d", e_stream->bitrate/1000);
	  if(e_stream->stereo)
	    sprintf(ch,"j");
	  else
	    sprintf(ch,"m");
	  
	  varnum=0;
	  vars[varnum++]=strdup(e_stream->encoder_cmd);
	  vars[varnum++]=strdup("-m");
	  vars[varnum++]=ch;
	  vars[varnum++]=strdup("-s");
	  vars[varnum++]=sr;
	  vars[varnum++]=strdup("-b");
	  vars[varnum++]=br;
	  
	  if(e_stream->copyright)
	    vars[varnum++]=strdup("-c");
	 
#ifdef NUMBER_LITTLE_ENDIAN
	  vars[varnum++]=strdup("-x");
#endif 
	  /* now stick the commands in here */
	  args=e_stream->encoder_args;
	  do {
	          arg=get_next_arg(&args);
		  if(arg) {
		          vars[varnum++]=arg;
		  }
	  } while ( arg );
	  
	  vars[varnum++]=strdup(e_stream->sound_pipe);
	  vars[varnum++]=strdup(e_stream->mpeg_pipe);
vars[varnum++]=NULL;
	  execvp(e_stream->encoder_cmd,vars);
	  /*
	  if(e_stream->copyright)
		  execlp(e_stream->encoder_cmd, e_stream->encoder_cmd, "-m" , ch , "-s" , sr , "-b" , br , "-c", "-x" , e_stream->sound_pipe , e_stream->mpeg_pipe,  NULL);
	  else 
		  execlp(e_stream->encoder_cmd, e_stream->encoder_cmd, "-m" , ch , "-s" , sr , "-b" , br , "-x" ,e_stream->sound_pipe , e_stream->mpeg_pipe,  NULL);
	  */
	  sprintf(sr,"execution of %s failed - make sure it's in your $PATH moron!",e_stream->encoder_cmd);
	  fatal(sr);
	  break;
	case -1:
	  fatal("unable to fork() a new process for the encoder");
	  break;
	}
	e_stream->enc=enc;
	return enc;
}

/* The GOGO assembly optomised encoder which despite being based on LAME
   decided to chenge the command line interface..... don't ask me why */

int exec_encoder_gogo(enc_struct *e_stream){
	char sr[256], br[32],ch[32];
	char *vars[64];
	int enc,varnum;
	char *args,*arg;
	/*isolate the IO so it doesn't clobber the level meter*/
	switch(enc=fork()){
	case 0:
	  if(g_conf.debug<10){
	    close(1);
	    close(2);
	    open("/dev/null", O_WRONLY);
	    open("/dev/null", O_WRONLY);
	  }
	  /* if you run as superuser then increase the priority */
	  nice(-10);
	  sprintf(sr, "%f", e_stream->sample_rate/1000.0);
	  sprintf(br, "%d", e_stream->bitrate/1000);
	  if(e_stream->stereo)
	    sprintf(ch,"j");
	  else
	    sprintf(ch,"m");
	  
	  varnum=0;
	  vars[varnum++]=strdup(e_stream->encoder_cmd);
	  vars[varnum++]=strdup(e_stream->sound_pipe);
	  vars[varnum++]=strdup(e_stream->mpeg_pipe);
	  vars[varnum++]=strdup("-m");
	  vars[varnum++]=ch;
	  vars[varnum++]=strdup("-s");
	  vars[varnum++]=sr;
	  vars[varnum++]=strdup("-d");
	  vars[varnum++]=sr;	  
	  vars[varnum++]=strdup("-b");
	  vars[varnum++]=br;
	  vars[varnum++]=strdup("-offset");
	  vars[varnum++]=strdup("0");
	  if(!e_stream->stereo)
	    vars[varnum++]=strdup("-mono");
	  /* 
	     still might need this for gogo - not sure 
	     #ifdef NUMBER_LITTLE_ENDIAN
	     vars[varnum++]=strdup("-x");
	     #endif 
	  */
	  
	  /* now stick the commands in here */
	  args=e_stream->encoder_args;
	  do {
	          arg=get_next_arg(&args);
		  if(arg) {
		          vars[varnum++]=arg;
		  }
	  } while ( arg );

	  vars[varnum++]=NULL;
	  execvp(e_stream->encoder_cmd,vars);

	  sprintf(sr,"execution of %s failed - make sure it's in your $PATH moron!",e_stream->encoder_cmd);
	  fatal(sr);
	  break;
	case -1:
	  fatal("unable to fork() a new process for the encoder");
	  break;
	}
	e_stream->enc=enc;
	return enc;
}


/* LAME 3.2+ support - LAME Ain't an Mp3 Encoder. */
/* Essentially a patch to dist 10 with a better psycho model */
/* http://www.sulaco.org/mp3  */
/* not the subtle change which is needed for recent versions */
int exec_encoder_lame3(enc_struct *e_stream){
	char sr[256], br[32],ch[32];
	char *vars[64];
	int enc,varnum;
	char *args,*arg;
	/*isolate the IO so it doesn't clobber the level meter*/
	switch(enc=fork()){
	case 0:
	  if(g_conf.debug<10){
	    close(1);
	    close(2);
	    open("/dev/null", O_WRONLY);
	    open("/dev/null", O_WRONLY);
	  }
	  /* if you run as superuser then increase the priority */
	  nice(-10);
	  sprintf(sr, "%f", e_stream->sample_rate/1000.0);
	  sprintf(br, "%d", e_stream->bitrate/1000);
	  if(e_stream->stereo)
	    sprintf(ch,"j");
	  else
	    sprintf(ch,"m");
	  
	  varnum=0;
	  vars[varnum++]=strdup(e_stream->encoder_cmd);

	  vars[varnum++]=strdup("-m");
	  vars[varnum++]=ch;
	  vars[varnum++]=strdup("-s");
	  vars[varnum++]=sr;
	  vars[varnum++]=strdup("-b");
	  vars[varnum++]=br;
	  vars[varnum++]=strdup("-r");
		  
	  if(e_stream->copyright)
	    vars[varnum++]=strdup("-c");
	  
#ifdef NUMBER_LITTLE_ENDIAN
	  vars[varnum++]=strdup("-x");
#endif 

	  /* now stick the commands in here */
	  args=e_stream->encoder_args;
	  do {
	          arg=get_next_arg(&args);
		  if(arg) {
		          vars[varnum++]=arg;
		  }
	  } while ( arg );

	  vars[varnum++]=strdup(e_stream->sound_pipe);
	  vars[varnum++]=strdup(e_stream->mpeg_pipe);
	  vars[varnum++]=NULL;
	  varnum=0;
	  /*while(vars[varnum]!=NULL){
	     fprintf(stderr,"%s\n",vars[varnum++]);
	    }*/

	  execvp(e_stream->encoder_cmd,vars);
	  
	  /*
	  if(e_stream->copyright)
		  execlp(e_stream->encoder_cmd, e_stream->encoder_cmd, "-m" , ch , "-s" , sr , "-b" , br , "-c", "-r", "-x" , e_stream->sound_pipe , e_stream->mpeg_pipe,  NULL);
	  else 
		  execlp(e_stream->encoder_cmd, e_stream->encoder_cmd, "-m" , ch , "-s" , sr , "-b" , br , "-r", "-x" ,e_stream->sound_pipe , e_stream->mpeg_pipe,  NULL);
	  */
	  sprintf(sr,"execution of %s failed - make sure it's in your $PATH moron!",e_stream->encoder_cmd);
	  fatal(sr);
	  break;
	case -1:
	  fatal("unable to fork() a new process for the encoder");
	  break;
	}
	e_stream->enc=enc;
	return enc;
}


/* LAME 3.10+   support - LAME Ain't an Mp3 Encoder. */
/* Essentially a patch to dist 10 with a better psycho model */
/* http://www.sulaco.org/mp3  */
int exec_encoder_lame31x(enc_struct *e_stream){
	char sr[256], br[32],ch[32];
	char *vars[64];
	int enc,varnum;
	char *args,*arg;
	/*isolate the IO so it doesn't clobber the level meter*/
	
	switch(enc=fork()){
	case 0:
	  if(g_conf.debug<10){
	    close(2);
	    open("/dev/null", O_WRONLY);
	  }

	  close(0);
	  close(1);
	  open(e_stream->sound_pipe,O_RDONLY);
	  open(e_stream->mpeg_pipe,O_WRONLY);
	  /* if you run as superuser then increase the priority */
	  nice(-10);
	  sprintf(sr, "%f", e_stream->sample_rate/1000.0);
	  sprintf(br, "%d", e_stream->bitrate/1000);
	  if(e_stream->stereo)
	    sprintf(ch,"j");
	  else
	    sprintf(ch,"m");

	  varnum=0;
	  vars[varnum++]=e_stream->encoder_cmd;
	  vars[varnum++]=strdup("-m");
	  vars[varnum++]=ch;
	  vars[varnum++]=strdup("-s");
	  vars[varnum++]=sr;
	  vars[varnum++]=strdup("-b");
	  vars[varnum++]=br;
			  
	  if(e_stream->copyright)
	    vars[varnum++]=strdup("-c");
	  
#ifdef NUMBER_LITTLE_ENDIAN
	  vars[varnum++]=strdup("-x");
#endif 
	  /* extra parameters */
	  	  /* now stick the commands in here */
	  args=e_stream->encoder_args;
	  do {
	          arg=get_next_arg(&args);
		  if(arg) {
		          vars[varnum++]=arg;
		  }
	  } while ( arg );
	  vars[varnum++]=strdup("-");
	  vars[varnum++]=strdup("-");
	  vars[varnum++]=NULL;
	  execvp(e_stream->encoder_cmd,vars);
	  
	  /*
	  if(e_stream->copyright)
		  execlp(e_stream->encoder_cmd, e_stream->encoder_cmd, "-m" , ch , "-s" , sr , "-b" , br , "-c", "-x" , "-" , "-",  NULL);
	  else 
		  execlp(e_stream->encoder_cmd, e_stream->encoder_cmd, "-m" , ch , "-s" , sr , "-b" , br , "-x" , "-"  , "-",  NULL);
	  */
	  sprintf(sr,"lame31x execution of %s failed - make sure it's in your $PATH moron!",e_stream->encoder_cmd);
	  fatal(sr);
	  break;
	case -1:
	  fatal("unable to fork() a new process for the encoder");
	  break;
	}
	e_stream->enc=enc;
	return enc;
}



/* the version of lamer which comes from Isaac Richard's  Scream */
/* http://mizar.cwru.edu/screamer/                               */
/* unfortunately it's dropped off the face of the earth          */
/* I'd suggest usign LAME instead                                */
int exec_encoder_screamer(enc_struct *e_stream){
	char sr[256], br[32],ch[32];
	char *vars[64];
	int enc,varnum;
	char *args,*arg;
	switch(enc=fork()){
	case 0:
	  /*isolate the IO so it doesn't clobber the level meter*/
	    if(g_conf.debug<10){
		    close(1);
		    close(2);
		    open("/dev/null", O_WRONLY);
		    open("/dev/null", O_WRONLY);	    
	    }
	  close(0);
	  open(e_stream->sound_pipe,O_RDONLY);
	  nice(-10);
	  sprintf(sr, "%f", e_stream->sample_rate/1000.0);
	  sprintf(br, "%f", e_stream->bitrate/1000.0);
	  if(e_stream->stereo)
	    sprintf(ch,"s");
	  else
	    sprintf(ch,"m");
	  
	  varnum=0;
	  vars[varnum++]=strdup(e_stream->encoder_cmd);
	  if(e_stream->copyright)
	    vars[varnum++]=strdup("-c");
	  vars[varnum++]=strdup("-b");
	  vars[varnum++]=br;
	  vars[varnum++]=strdup("-s");
	  vars[varnum++]=sr;
	  vars[varnum++]=strdup("-m");
	  vars[varnum++]=ch;

	  	  /* now stick the commands in here */
	  args=e_stream->encoder_args;
	  do {
	          arg=get_next_arg(&args);
		  if(arg) {
		          vars[varnum++]=arg;
		  }
	  } while ( arg );

	  vars[varnum++]=strdup("-");
	  vars[varnum++]=strdup(e_stream->mpeg_pipe);
vars[varnum++]=NULL;
	  execvp(e_stream->encoder_cmd,vars);
	  
	  /*
	  if(e_stream->copyright)
		  execlp(e_stream->encoder_cmd, e_stream->encoder_cmd, "-b" , br , "-s" , sr ,  "-m" , ch , "-", e_stream->mpeg_pipe , NULL);
	  else 
		  execlp(e_stream->encoder_cmd, e_stream->encoder_cmd, "-c" , "-b" , br , "-s" , sr ,  "-m" , ch , "-", e_stream->mpeg_pipe , NULL);
	  */

	  sprintf(sr,"execution of %s failed - make sure it's in your $PATH moron!",e_stream->encoder_cmd);
	  fatal(sr);
	  break;
	case -1:
	  fatal("unable to fork() a new process for the encoder");
	}
	e_stream->enc=enc;
	return enc;
}



/* The Xing Technologies encoder, needs to be cheated by puting a .wav header*/
/* at the start, the programme still truies to seek past it but doesn't      */
/* instantly crash unlike other encoders */
/* the beta used bitrate per channel - but the produciton verison saw sense  */
/* since stereo is a bitch to work with in either version I've set it up for */
/* the produacion version fo the encoder */
/* the steroe mode is broken - but astute kernel hackers might want to try a */
/* special kernel patch I've created to fool this into doing what I want */
int exec_encoder_xing(enc_struct *e_stream)
{
  char br[256];
  char ch[32];
  char copyright[32];
  char algorithm[32];
  int enc,varnum;
  char *vars[64];
	char *args,*arg;
  sprintf(br,"-B%d",e_stream->bitrate / 1000 );
  sprintf(ch,"-M%d",(e_stream->stereo ? 0 : 3));

  sprintf(copyright,"-C%d",(e_stream->copyright ? 1 : 0) );
  
  /* let the encoder choose the sample rate */
  if(e_stream->bitrate<=32000){
	  sprintf(algorithm,"-A2");
  } else if(e_stream->sample_rate<=24000){
	  sprintf(algorithm,"-A2");
  } else {
	  sprintf(algorithm,"-A1");
  }
	  
		  
  switch(enc=fork()){
  case 0:
	  /* close those fd's */
	  if(g_conf.debug<10){
		  close(0);
		  close(1);
		  close(2);
		  open("/dev/null", O_RDONLY);
		  open("/dev/null", O_WRONLY);
		  open("/dev/null", O_WRONLY);
	  }
	  varnum=0;
	  vars[varnum++]=strdup(e_stream->encoder_cmd);
	  vars[varnum++]=algorithm;
	  vars[varnum++]=ch;
	  vars[varnum++]=br;
	  vars[varnum++]=copyright;
	  if(e_stream->encoding_quality<30){
	    vars[varnum++]=strdup("-Nhf");
	  } 
	  /* extra vars go in here */
	  /* now stick the commands in here */
	  args=e_stream->encoder_args;
	  do {
	          arg=get_next_arg(&args);
		  if(arg) {
		          vars[varnum++]=arg;
		  }
	  } while ( arg );
	  /* now the pipes */
	  vars[varnum++]=strdup(e_stream->sound_pipe);
	  vars[varnum++]=strdup(e_stream->mpeg_pipe);
	  
	  vars[varnum++]=NULL;
	  
	  execvp(e_stream->encoder_cmd,vars);
	  
	  /*
	  if(e_stream->encoding_quality<30)
		  execlp(e_stream->encoder_cmd,e_stream->encoder_cmd,algorithm,"-Nhf",ch,br,copyright,e_stream->sound_pipe,e_stream->mpeg_pipe,NULL);
	  else
	  execlp(e_stream->encoder_cmd,e_stream->encoder_cmd,algorithm,ch,br,copyright,e_stream->sound_pipe,e_stream->mpeg_pipe,NULL);
	  */

	  sprintf(br,"execution of %s failed - make sure it's in your $PATH moron!",e_stream->encoder_cmd);
	  fatal(br);
	  break;
  case -1:
	  fatal("unable to fork() new process for the encoder");
  }
  e_stream->enc=enc;
  return enc;
}

/*The Beta Version of Xing - It uses a bitrate per channel */
int exec_encoder_xing_beta(enc_struct *e_stream)
{
  char br[256];
  char ch[32];
  char copyright[32];
  char algorithm[32];
  int enc,varnum;
  char *vars[64];
  	char *args,*arg;

	sprintf(br,"-B%d",e_stream->bitrate / 2000 );
  sprintf(ch,"-M%d",(e_stream->stereo ? 0 : 3));

  sprintf(copyright,"-C%d",(e_stream->copyright ? 1 : 0) );
  
  /* let the encoder choose the sample rate */
  if(e_stream->bitrate<=32000){
	  sprintf(algorithm,"-A2");
  } else if(e_stream->sample_rate<=24000){
	  sprintf(algorithm,"-A2");
  } else {
	  sprintf(algorithm,"-A1");
  }
	  
		  
  switch(enc=fork()){
  case 0:
	  /* close those fd's */
	  if(g_conf.debug<10){
		  close(0);
		  close(1);
		  close(2);
		  open("/dev/null", O_RDONLY);
		  open("/dev/null", O_WRONLY);
		  open("/dev/null", O_WRONLY);
	  }

	  varnum=0;
	  vars[varnum++]=strdup(e_stream->encoder_cmd);
	  vars[varnum++]=algorithm;
	  vars[varnum++]=ch;
	  vars[varnum++]=br;
	  vars[varnum++]=copyright;
	  if(e_stream->encoding_quality<30){
	    vars[varnum++]=strdup("-Nhf");
	  } 
	  /* extra vars go in here */
	  /* now stick the commands in here */
	  args=e_stream->encoder_args;
	  do {
	          arg=get_next_arg(&args);
		  if(arg) {
		          vars[varnum++]=arg;
		  }
	  } while ( arg );
	  /* now the pipes */
	  vars[varnum++]=strdup(e_stream->sound_pipe);
	  vars[varnum++]=strdup(e_stream->mpeg_pipe);
	  
	  vars[varnum++]=NULL;
	  
	  execvp(e_stream->encoder_cmd,vars);


	  /*
	  if(e_stream->encoding_quality<30)
		  execlp(e_stream->encoder_cmd,e_stream->encoder_cmd,algorithm,"-Nhf",ch,br,copyright,e_stream->sound_pipe,e_stream->mpeg_pipe,NULL);
	  else
		  execlp(e_stream->encoder_cmd,e_stream->encoder_cmd,algorithm,ch,br,copyright,e_stream->sound_pipe,e_stream->mpeg_pipe,NULL);
	  */
	  sprintf(br,"execution of %s failed - make sure it's in your $PATH moron!",e_stream->encoder_cmd);
	  fatal(br);
	  break;
  case -1:
	  fatal("unable to fork() new process for the encoder");
  }
  e_stream->enc=enc;
  return enc;
}



/* The Xing encoder in Variable bitrate mode */
int exec_encoder_xing_vbr(enc_struct *e_stream)
{
	
  char br[256];
  char ch[32];
  char copyright[32];
  /*  char algorithm[32];*/
  int enc,varnum;
  char *vars[64];
	char *args,*arg;

  sprintf(br,"-V%d",e_stream->vbr_quality);
  sprintf(ch,"-M%d",(e_stream->stereo ? 0 : 3));

  sprintf(copyright,"-C%d",(e_stream->copyright ? 1 : 0) );
  
  /* it can be a good idea to let the encoder choose the sample_rate */
  /*if(e_stream->bitrate<=32000){
	  sprintf(algorithm,"-A0");
  } else if(e_stream->sample_rate<=24000){
	  sprintf(algorithm,"-A0");
  } else {
	  sprintf(algorithm,"-A1");
	  }*/


  switch(enc=fork()){
  case 0:
	  /* close those fd's */
	  if(g_conf.debug<10){
		  close(0);
		  close(1);
		  close(2);
		  open("/dev/null", O_RDONLY);
		  open("/dev/null", O_WRONLY);
		  open("/dev/null", O_WRONLY);
	  }

	  varnum=0;
	  vars[varnum++]=strdup(e_stream->encoder_cmd);
	  vars[varnum++]=ch;
	  vars[varnum++]=br;
	  vars[varnum++]=copyright;
	  if(e_stream->encoding_quality<30){
	    vars[varnum++]=strdup("-Nhf");
	  } 
	  /* extra vars go in here */
	  /* now stick the commands in here */
	  args=e_stream->encoder_args;
	  do {
	          arg=get_next_arg(&args);
		  if(arg) {
		          vars[varnum++]=arg;
		  }
	  } while ( arg );
	  /* now the pipes */
	  vars[varnum++]=strdup(e_stream->sound_pipe);
	  vars[varnum++]=strdup(e_stream->mpeg_pipe);
	  
	  vars[varnum++]=NULL;
	  
	  execvp(e_stream->encoder_cmd,vars);
	  sprintf(br,"execution of %s failed - make sure it's in your $PATH moron!",e_stream->encoder_cmd);
	  fatal(br);
	  break;
  case -1:
	  fatal("unable to fork() new process for the encoder");
  }
  e_stream->enc=enc;
  return enc;
}





int spawn_encoder_process(enc_struct *e_stream){
	switch(e_stream->encoder){
	case L3ENC:
		return exec_encoder_l3enc(e_stream);
	case MP3ENC:
		return exec_encoder_mp3enc(e_stream);
	case AJ_ENCODER:
		return exec_encoder_AJ(e_stream);
	case SCREAMER:
		return exec_encoder_screamer(e_stream);
	case XING:
	        return exec_encoder_xing(e_stream);
	case XING_BETA:
		return exec_encoder_xing_beta(e_stream);
	case XING_VBR:
		return exec_encoder_xing_vbr(e_stream);
	case OLD_LAME3:
	        return exec_encoder_old_lame3(e_stream);
	case LAME3:
		return exec_encoder_lame3(e_stream);
	case LAME31x:
		return exec_encoder_lame31x(e_stream);
	case GOGO:
		return exec_encoder_gogo(e_stream);
		
	default:
		fatal("Selected encoder Not Currently Supported - Sorry\n supported encoders are -\n L3ENC, MP3ENC, XING, XING_VBR, LAME3, SREAMER and AJ_ENCODER or GOGO");
		return -1;
	}
}

int check_encoder_l3enc(enc_struct *e_stream){
	if(e_stream->copyright)
		write_message("Warning: l3enc doesn't support copyright flag",0);
	switch(e_stream->bitrate){
	case 8000:
	case 16000:
	case 24000:
	case 32000:
	case 56000:
	case 64000:
	case 96000:
	case 112000:
	case 128000:
	case 192000:
	case 256000:
		break;
	default:
		write_message("Error: invalid bitrate for l3enc selected",0);
		return -1;
	}
	return 0;
}

int check_encoder_mp3enc(enc_struct *e_stream){
	if(e_stream->copyright)
		write_message("Warning: mp3enc doesn't support copyright flag",0);
	switch(e_stream->bitrate){
	case 8000:
	case 16000:
	case 18000:
		if(e_stream->stereo){
			write_message("Error: mp3enc stereo mode only works for bitrates >= 20Kbit/s",0);
			return -1;
		}
	case 20000:
	case 24000:
	case 32000:
	case 40000:
	case 48000:
	case 56000:
	case 64000:
	case 96000:
	case 112000:
	case 128000:
	case 160000:
	case 192000:
	case 256000:
		break;
	default:
		write_message("Error: invalid bitrate for mp3enc selected",0);
		return -1;
	}
	
	return 0;
}

int check_encoder_AJ(enc_struct *e_stream){
	switch(e_stream->bitrate){
	case 32000:
	case 40000:
	case 48000:
	case 56000:
	case 64000:
	case 80000:
	case 96000:
	case 112000:
	case 128000:
	case 160000:
	case 192000:
	case 224000:
	case 256000:
	case 320000:
		break;
	default:
		write_message("Error: invalid bitrate for encoder",0);
		return -1;
	}
	if(e_stream->sample_rate<32000){
		write_message("Error: AJ_ENCODER can't run at less than 32kHz",0);
		return -1;
	}
	return 0;
}


int check_encoder_screamer(enc_struct *e_stream){
	if(e_stream->sample_rate<=11025){
		write_message("Error: Screamer doesn't support sample rates <=11kHz",0);
		return -1;
	}
		
	switch(e_stream->bitrate){
	case 8000:
		if(e_stream->stereo){
			write_message("Error: Screamer only support mono for 8kbit/s streams",0);
			return -1;
		}
	case 16000:
	case 24000:
		if(e_stream->sample_rate>24000){
			write_message("Error: Screamer only supports sample rates <=24kHz for low bitrates",0);
			return -1;
		}
	case 32000:
	case 40000:
	case 48000:
	case 56000:
	case 64000:
	case 80000:
	case 96000:
	case 112000:
	case 128000:
	case 160000:
	case 192000:
	case 224000:
	case 256000:
	case 320000:
		break;
	default:
		write_message("Error: invalid bitrate for encoder",0);
		return -1;
	}
	return 0;
}


int check_encoder_old_lame3(enc_struct *e_stream){
	if(e_stream->sample_rate<=11025){
		write_message("Error: LAME3.x doesn't support sample rates <=11kHz",0);
		return -1;
	}
	if(e_stream->sample_rate<=24000){
		write_message("Warning: LAME3.x doesn't use GPsycho for low sample rates",0);
	}
		
	switch(e_stream->bitrate){
	case 8000:
	case 16000:
	case 24000:
		write_message("Warning: Low Bitrates only work in recent versions of LAME3.x",0);
		if(e_stream->sample_rate>24000){
			write_message("Error: LAME3.x only supports sample rates <=24kHz for low bitrates",0);
			return -1;
		}
	case 32000:
	case 40000:
	case 48000:
	case 56000:
	case 64000:
	case 80000:
	case 96000:
	case 112000:
	case 128000:
	case 160000:
	case 192000:
	case 224000:
	case 256000:
	case 320000:
		break;
	default:
		write_message("Error: invalid bitrate for encoder",0);
		return -1;
	}
	return 0;
}


int check_encoder_lame3(enc_struct *e_stream){
	switch(e_stream->bitrate){
	case 8000:
	case 16000:
	case 24000:
		write_message("Warning: Low Bitrates only work in recent versions of LAME3.x",0);
		if(e_stream->sample_rate>24000){
			write_message("Error: mpeg only supports sample rates >24kHz for bitrates >= 32000",0);
			return -1;
		}
	case 32000:
	case 40000:
	case 48000:
	case 56000:
	case 64000:
	case 80000:
	case 96000:
	case 112000:
	case 128000:
	case 160000:
	case 192000:
	case 224000:
	case 256000:
	case 320000:
		break;
	default:
		write_message("Error: invalid bitrate for encoder",0);
		return -1;
	}
	return 0;
}

int check_encoder_gogo(enc_struct *e_stream){
	if(e_stream->sample_rate<=11025){
		write_message("Error: Gogo doesn't support sample rates <=11kHz",0);
		return -1;
	}
	
	switch(e_stream->bitrate){
	case 8000:
	case 16000:
	case 24000:

		if(e_stream->sample_rate>24000){
			write_message("Error: Gogo only supports sample rates <=24kHz for low bitrates",0);
			return -1;
		}
	case 32000:
	case 40000:
	case 48000:
	case 56000:
	case 64000:
	case 80000:
	case 96000:
	case 112000:
	case 128000:
	case 160000:
	case 192000:
	case 224000:
	case 256000:
	case 320000:
		break;
	default:
		write_message("Error: invalid bitrate for encoder",0);
		return -1;
	}
	return 0;
}

int check_encoder_lame31x(enc_struct *e_stream){
	if(e_stream->sample_rate<=11025){
		write_message("Error: LAME3.x doesn't support sample rates <=11kHz",0);
		return -1;
	}
	if(e_stream->sample_rate<=24000){
		write_message("Warning: LAME3.x doesn't use GPsycho for low sample rates",0);
	}
		
	switch(e_stream->bitrate){
	case 8000:
	case 16000:
	case 24000:
		write_message("Warning: Low Bitrates only work in recent versions of LAME3.x",0);
		if(e_stream->sample_rate>24000){
			write_message("Error: LAME3.x only supports sample rates <=24kHz for low bitrates",0);
			return -1;
		}
	case 32000:
	case 40000:
	case 48000:
	case 56000:
	case 64000:
	case 80000:
	case 96000:
	case 112000:
	case 128000:
	case 160000:
	case 192000:
	case 224000:
	case 256000:
	case 320000:
		break;
	default:
		write_message("Error: invalid bitrate for encoder",0);
		return -1;
	}
	return 0;
}



int check_encoder_xing(enc_struct *e_stream){
	write_message("Warning: You have selected the Xing mp3 encoder,",0);
	write_message(" currently only the beta version works easily with liveice",0);
	write_message(" the production version has a numebr of bugs which have made",0);
	write_message(" using it with LiveIce a non-trivial task",0);
	write_message(" Stereo mode only works with a special patch to the linux Kernel",0);
	write_message(" if you don't know what I'm talking about then read the docs",0);
	write_message(" But of course you know all this because you've read the Documenation!",0);


	/* now bitrates - different ones for different modes */
	switch(e_stream->bitrate){
	case 16000:
		if(e_stream->sample_rate>=44100){
			write_message("Error: Xing won't do >=44100KHz at 16Kbit",0);
			return -1;
		}
	case 24000:
	case 56000:
	case 80000:
		if(e_stream->stereo){
			write_message("Error: Invalid bitrate in stereo mode",0);
			return -1;
		}
		break;
	case 32000:
	case 48000:
	case 64000:
	case 96000:
	case 112000:
	case 128000:
	case 160000:
	case 192000:
	case 224000:
	case 256000:
	case 320000:
		break;
	default:
		write_message("Error: invalid bitrate for stereo xing_encoder",0);
		return -1;
	}


	if(e_stream->sample_rate<=11025){
		write_message("Error: Xing does not support <=11kHz streams",0);
		return -1;
	}

	return 0;
}



int check_encoder_xing_vbr(enc_struct *e_stream){
	write_message("Warning: You have selected the Xing mp3 encoder",0);
	write_message(" currently only the beta version works easily with liveice",0);
	write_message(" the production version has a numebr of bugs which have made",0);
	write_message(" using it with LiveIce a non-trivial task",0);
	write_message(" But of course you know all this because you've read the Documenation!",0);

	if(e_stream->stereo){
		write_message("Warning:",0);
		write_message(" Stereo mode only works with a special patch to the linux Kernel",0);
		write_message(" if you don't know what I'm talking about then read the docs",0);
	}
	
	if((e_stream->vbr_quality>150)||(e_stream->vbr_quality<0)){
		write_message("Error: Xing VBR quality setting should be between 0-150",0);
		write_message("       modify VBR_QUALITY in the config file",0);
		return -1;
	}

	if(e_stream->sample_rate<=11025){
		write_message("Error: Xing does not support <=11kHz streams",0);
		return -1;
	}

	

	return 0;
}




/* stupidity check on a per encoder basis */
int check_encoder_parameters(enc_struct *e_stream){
	char error_msg[4096];
	if(!check_executable(e_stream->encoder_cmd)){
		sprintf(error_msg,"It appears that we cannot find %s in you path, or cannot execut it\n",e_stream->encoder_cmd);
		write_message(error_msg,0);
		return -1;
	}
	switch(e_stream->encoder){
	case L3ENC:
		return check_encoder_l3enc(e_stream);
		break;
	case MP3ENC:
		return check_encoder_mp3enc(e_stream);
		break;
	case AJ_ENCODER:
		return check_encoder_AJ(e_stream);
		break;
	case SCREAMER:
		return check_encoder_screamer(e_stream);
		break;
	case XING:
		return check_encoder_xing(e_stream);
		break;
	case XING_VBR:
		return check_encoder_xing_vbr(e_stream);
		break;
	case XING_BETA:
		return check_encoder_xing(e_stream);
		break;
	case OLD_LAME3:
		return check_encoder_old_lame3(e_stream);
		break;	
	case LAME3:
		return check_encoder_lame3(e_stream);
		break;
	case LAME31x:
		return check_encoder_lame31x(e_stream);
		break;
	case GOGO:
		return check_encoder_gogo(e_stream);
		break;		
	default:
		write_message("Error: Unsupported encoder selected",0);
		return -1;
	}

}



