/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Consumer;
import org.jivesoftware.smack.util.LazyStringBuilder;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jxmpp.util.XmppDateTime;

public class XmlStringBuilder
implements Appendable,
CharSequence,
Element {
    public static final String RIGHT_ANGLE_BRACKET = Character.toString('>');
    private final LazyStringBuilder sb = new LazyStringBuilder();
    private final XmlEnvironment effectiveXmlEnvironment;
    private static AppendApproach APPEND_APPROACH = AppendApproach.SINGLE;

    public XmlStringBuilder() {
        this.effectiveXmlEnvironment = null;
    }

    public XmlStringBuilder(ExtensionElement pe) {
        this(pe, null);
    }

    public XmlStringBuilder(NamedElement e) {
        this();
        this.halfOpenElement(e.getElementName());
    }

    public XmlStringBuilder(FullyQualifiedElement element, XmlEnvironment enclosingXmlEnvironment) {
        this(element.getElementName(), element.getNamespace(), element.getLanguage(), enclosingXmlEnvironment);
    }

    public XmlStringBuilder(String elementName, String xmlNs, String xmlLang, XmlEnvironment enclosingXmlEnvironment) {
        this.halfOpenElement(elementName);
        if (enclosingXmlEnvironment == null) {
            this.xmlnsAttribute(xmlNs);
            this.xmllangAttribute(xmlLang);
        } else {
            if (!enclosingXmlEnvironment.effectiveNamespaceEquals(xmlNs)) {
                this.xmlnsAttribute(xmlNs);
            }
            if (!enclosingXmlEnvironment.effectiveLanguageEquals(xmlLang)) {
                this.xmllangAttribute(xmlLang);
            }
        }
        this.effectiveXmlEnvironment = XmlEnvironment.builder().withNamespace(xmlNs).withLanguage(xmlLang).withNext(enclosingXmlEnvironment).build();
    }

    public XmlEnvironment getXmlEnvironment() {
        return this.effectiveXmlEnvironment;
    }

    public XmlStringBuilder escapedElement(String name, String escapedContent) {
        assert (escapedContent != null);
        this.openElement(name);
        this.append(escapedContent);
        this.closeElement(name);
        return this;
    }

    public XmlStringBuilder element(String name, String content) {
        if (content.isEmpty()) {
            return this.emptyElement(name);
        }
        this.openElement(name);
        this.escape(content);
        this.closeElement(name);
        return this;
    }

    public XmlStringBuilder element(String name, Date content) {
        assert (content != null);
        return this.element(name, XmppDateTime.formatXEP0082Date((Date)content));
    }

    public XmlStringBuilder element(String name, CharSequence content) {
        return this.element(name, content.toString());
    }

    public XmlStringBuilder element(String name, Enum<?> content) {
        assert (content != null);
        this.element(name, content.toString());
        return this;
    }

    @Deprecated
    public XmlStringBuilder element(Element element) {
        assert (element != null);
        return this.append(element.toXML());
    }

    public XmlStringBuilder optElement(String name, String content) {
        if (content != null) {
            this.element(name, content);
        }
        return this;
    }

    public XmlStringBuilder optElement(String name, Date content) {
        if (content != null) {
            this.element(name, content);
        }
        return this;
    }

    public XmlStringBuilder optElement(String name, CharSequence content) {
        if (content != null) {
            this.element(name, content.toString());
        }
        return this;
    }

    public XmlStringBuilder optElement(Element element) {
        if (element != null) {
            this.append(element);
        }
        return this;
    }

    public XmlStringBuilder optElement(String name, Enum<?> content) {
        if (content != null) {
            this.element(name, content);
        }
        return this;
    }

    public XmlStringBuilder optElement(String name, Object object) {
        if (object != null) {
            this.element(name, object.toString());
        }
        return this;
    }

    public XmlStringBuilder optIntElement(String name, int value) {
        if (value >= 0) {
            this.element(name, String.valueOf(value));
        }
        return this;
    }

    public XmlStringBuilder halfOpenElement(String name) {
        assert (StringUtils.isNotEmpty((CharSequence)name));
        this.sb.append('<').append(name);
        return this;
    }

    public XmlStringBuilder halfOpenElement(NamedElement namedElement) {
        return this.halfOpenElement(namedElement.getElementName());
    }

    public XmlStringBuilder openElement(String name) {
        this.halfOpenElement(name).rightAngleBracket();
        return this;
    }

    public XmlStringBuilder closeElement(String name) {
        this.sb.append("</").append(name);
        this.rightAngleBracket();
        return this;
    }

    public XmlStringBuilder closeElement(NamedElement e) {
        this.closeElement(e.getElementName());
        return this;
    }

    public XmlStringBuilder closeEmptyElement() {
        this.sb.append("/>");
        return this;
    }

    public XmlStringBuilder rightAngleBracket() {
        this.sb.append(RIGHT_ANGLE_BRACKET);
        return this;
    }

    public XmlStringBuilder attribute(String name, String value) {
        assert (value != null);
        this.sb.append(' ').append(name).append("='");
        this.escapeAttributeValue(value);
        this.sb.append('\'');
        return this;
    }

    public XmlStringBuilder attribute(String name, boolean bool) {
        return this.attribute(name, Boolean.toString(bool));
    }

    public XmlStringBuilder attribute(String name, Date value) {
        assert (value != null);
        return this.attribute(name, XmppDateTime.formatXEP0082Date((Date)value));
    }

    public XmlStringBuilder attribute(String name, CharSequence value) {
        return this.attribute(name, value.toString());
    }

    public XmlStringBuilder attribute(String name, Enum<?> value) {
        assert (value != null);
        this.attribute(name, value.toString());
        return this;
    }

    public <E extends Enum<?>> XmlStringBuilder attribute(String name, E value, E implicitDefault) {
        if (value == null || value == implicitDefault) {
            return this;
        }
        this.attribute(name, value.toString());
        return this;
    }

    public XmlStringBuilder attribute(String name, int value) {
        assert (name != null);
        return this.attribute(name, String.valueOf(value));
    }

    public XmlStringBuilder attribute(String name, long value) {
        assert (name != null);
        return this.attribute(name, String.valueOf(value));
    }

    public XmlStringBuilder optAttribute(String name, String value) {
        if (value != null) {
            this.attribute(name, value);
        }
        return this;
    }

    public XmlStringBuilder optAttribute(String name, Long value) {
        if (value != null) {
            this.attribute(name, value);
        }
        return this;
    }

    public XmlStringBuilder optAttribute(String name, Date value) {
        if (value != null) {
            this.attribute(name, value);
        }
        return this;
    }

    public XmlStringBuilder optAttribute(String name, CharSequence value) {
        if (value != null) {
            this.attribute(name, value.toString());
        }
        return this;
    }

    public XmlStringBuilder optAttribute(String name, Enum<?> value) {
        if (value != null) {
            this.attribute(name, value.toString());
        }
        return this;
    }

    public XmlStringBuilder optAttribute(String name, Number number) {
        if (number != null) {
            this.attribute(name, number.toString());
        }
        return this;
    }

    public XmlStringBuilder optAttributeCs(String name, CharSequence value) {
        return this.optAttribute(name, value);
    }

    public XmlStringBuilder optIntAttribute(String name, int value) {
        if (value >= 0) {
            this.attribute(name, Integer.toString(value));
        }
        return this;
    }

    public XmlStringBuilder optIntAttribute(String name, Integer value) {
        if (value != null) {
            this.attribute(name, value.toString());
        }
        return this;
    }

    public XmlStringBuilder optLongAttribute(String name, Long value) {
        if (value != null && value >= 0L) {
            this.attribute(name, Long.toString(value));
        }
        return this;
    }

    public XmlStringBuilder optBooleanAttribute(String name, boolean bool) {
        if (bool) {
            this.sb.append(' ').append(name).append("='true'");
        }
        return this;
    }

    public XmlStringBuilder optBooleanAttributeDefaultTrue(String name, boolean bool) {
        if (!bool) {
            this.sb.append(' ').append(name).append("='false'");
        }
        return this;
    }

    public XmlStringBuilder xmlnsAttribute(String value) {
        if (value == null || this.effectiveXmlEnvironment != null && this.effectiveXmlEnvironment.effectiveNamespaceEquals(value)) {
            return this;
        }
        XmlNsAttribute xmlNsAttribute = new XmlNsAttribute(value);
        this.append(xmlNsAttribute);
        return this;
    }

    public XmlStringBuilder xmllangAttribute(String value) {
        this.optAttribute("xml:lang", value);
        return this;
    }

    public XmlStringBuilder optXmlLangAttribute(String lang) {
        if (!StringUtils.isNullOrEmpty((CharSequence)lang)) {
            this.xmllangAttribute(lang);
        }
        return this;
    }

    public XmlStringBuilder text(CharSequence text) {
        assert (text != null);
        CharSequence escapedText = StringUtils.escapeForXmlText(text);
        this.sb.append(escapedText);
        return this;
    }

    public XmlStringBuilder escape(String text) {
        assert (text != null);
        this.sb.append(StringUtils.escapeForXml(text));
        return this;
    }

    public XmlStringBuilder escapeAttributeValue(String value) {
        assert (value != null);
        this.sb.append(StringUtils.escapeForXmlAttributeApos(value));
        return this;
    }

    public XmlStringBuilder optEscape(CharSequence text) {
        if (text == null) {
            return this;
        }
        return this.escape(text);
    }

    public XmlStringBuilder escape(CharSequence text) {
        return this.escape(text.toString());
    }

    protected XmlStringBuilder prelude(FullyQualifiedElement pe) {
        return this.prelude(pe.getElementName(), pe.getNamespace());
    }

    protected XmlStringBuilder prelude(String elementName, String namespace) {
        this.halfOpenElement(elementName);
        this.xmlnsAttribute(namespace);
        return this;
    }

    public XmlStringBuilder optAppend(Element element) {
        if (element != null) {
            this.append(element.toXML(this.effectiveXmlEnvironment));
        }
        return this;
    }

    public XmlStringBuilder optAppend(Collection<? extends Element> elements) {
        if (elements != null) {
            this.append(elements);
        }
        return this;
    }

    public XmlStringBuilder optTextChild(CharSequence sqc, NamedElement parentElement) {
        if (sqc == null) {
            return this.closeEmptyElement();
        }
        this.rightAngleBracket();
        this.escape(sqc);
        this.closeElement(parentElement);
        return this;
    }

    public XmlStringBuilder append(XmlStringBuilder xsb) {
        assert (xsb != null);
        this.sb.append(xsb.sb);
        return this;
    }

    public XmlStringBuilder append(Element element) {
        return this.append(element.toXML(this.effectiveXmlEnvironment));
    }

    public XmlStringBuilder append(Collection<? extends Element> elements) {
        for (Element element : elements) {
            this.append(element);
        }
        return this;
    }

    public XmlStringBuilder emptyElement(Enum<?> element) {
        return this.emptyElement(element.toString());
    }

    public XmlStringBuilder emptyElement(String element) {
        this.halfOpenElement(element);
        return this.closeEmptyElement();
    }

    public XmlStringBuilder condEmptyElement(boolean condition, String element) {
        if (condition) {
            this.emptyElement(element);
        }
        return this;
    }

    public XmlStringBuilder condAttribute(boolean condition, String name, String value) {
        if (condition) {
            this.attribute(name, value);
        }
        return this;
    }

    public static void setAppendMethod(AppendApproach appendApproach) {
        Objects.requireNonNull(appendApproach);
        APPEND_APPROACH = appendApproach;
    }

    @Override
    public XmlStringBuilder append(CharSequence csq) {
        assert (csq != null);
        switch (APPEND_APPROACH) {
            case SINGLE: {
                this.sb.append(csq);
                break;
            }
            case FLAT: {
                if (csq instanceof XmlStringBuilder) {
                    this.sb.append(((XmlStringBuilder)csq).sb);
                    break;
                }
                if (csq instanceof LazyStringBuilder) {
                    this.sb.append((LazyStringBuilder)csq);
                    break;
                }
                this.sb.append(csq);
            }
        }
        return this;
    }

    @Override
    public XmlStringBuilder append(CharSequence csq, int start, int end) {
        assert (csq != null);
        this.sb.append(csq, start, end);
        return this;
    }

    @Override
    public XmlStringBuilder append(char c) {
        this.sb.append(c);
        return this;
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public char charAt(int index) {
        return this.sb.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.sb.subSequence(start, end);
    }

    @Override
    public String toString() {
        try {
            StringWriter sw = new StringWriter();
            this.write(sw, XmlEnvironment.EMPTY);
            return sw.toString();
        }
        catch (IOException e) {
            return this.sb.toString();
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof CharSequence)) {
            return false;
        }
        CharSequence otherCharSequenceBuilder = (CharSequence)other;
        return this.toString().equals(otherCharSequenceBuilder.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void write(Writer writer, XmlEnvironment enclosingXmlEnvironment) throws IOException {
        try {
            this.appendXmlTo(csq -> {
                try {
                    writer.append((CharSequence)csq);
                }
                catch (IOException e) {
                    throw new WrappedIoException(e);
                }
            }, enclosingXmlEnvironment);
        }
        catch (WrappedIoException e) {
            throw e.wrappedIoException;
        }
    }

    public List<CharSequence> toList(XmlEnvironment enclosingXmlEnvironment) {
        ArrayList<CharSequence> res = new ArrayList<CharSequence>(this.sb.getAsList().size());
        this.appendXmlTo(csq -> res.add((CharSequence)csq), enclosingXmlEnvironment);
        return res;
    }

    @Override
    public StringBuilder toXML(XmlEnvironment enclosingXmlEnvironment) {
        int potentialLength = this.length();
        StringBuilder res = new StringBuilder(potentialLength);
        this.appendXmlTo(csq -> res.append((CharSequence)csq), enclosingXmlEnvironment);
        return res;
    }

    private void appendXmlTo(Consumer<CharSequence> charSequenceSink, XmlEnvironment enclosingXmlEnvironment) {
        for (CharSequence csq : this.sb.getAsList()) {
            if (csq instanceof XmlStringBuilder) {
                ((XmlStringBuilder)csq).appendXmlTo(charSequenceSink, enclosingXmlEnvironment);
                continue;
            }
            if (csq instanceof XmlNsAttribute) {
                XmlNsAttribute xmlNsAttribute = (XmlNsAttribute)csq;
                if (xmlNsAttribute.value.equals(enclosingXmlEnvironment.getEffectiveNamespace())) continue;
                charSequenceSink.accept(xmlNsAttribute);
                enclosingXmlEnvironment = new XmlEnvironment(xmlNsAttribute.value);
                continue;
            }
            charSequenceSink.accept(csq);
        }
    }

    private static final class WrappedIoException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final IOException wrappedIoException;

        private WrappedIoException(IOException wrappedIoException) {
            this.wrappedIoException = wrappedIoException;
        }
    }

    static enum AppendApproach {
        SINGLE,
        FLAT;

    }

    private static final class XmlNsAttribute
    implements CharSequence {
        private final String value;
        private final String xmlFragment;

        private XmlNsAttribute(String value) {
            this.value = StringUtils.requireNotNullNorEmpty(value, "Value must not be null");
            this.xmlFragment = " xmlns='" + value + '\'';
        }

        @Override
        public String toString() {
            return this.xmlFragment;
        }

        @Override
        public int length() {
            return this.xmlFragment.length();
        }

        @Override
        public char charAt(int index) {
            return this.xmlFragment.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.xmlFragment.subSequence(start, end);
        }
    }
}

