/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.impl.SipParser;
import java.io.IOException;

public class SipUserHostInfo {
    private final Buffer user;
    private final Buffer host;
    private final Buffer port;

    public static SipUserHostInfo frame(Buffer buffer) throws SipParseException, IOException {
        Parser parser = new Parser(buffer);
        return parser.parse();
    }

    private SipUserHostInfo(Buffer user, Buffer host, Buffer port) {
        this.user = user;
        this.host = host;
        this.port = port;
    }

    public Buffer getUser() {
        return this.user;
    }

    public Buffer getHost() {
        return this.host;
    }

    public Buffer getPort() {
        return this.port;
    }

    private static class Parser {
        private final Buffer buffer;
        private final int bufferStartIndex;
        private Buffer user;
        private Buffer host;
        private Buffer port;
        private HostPortParseState parseState;
        private int stateStartIndex;
        private int stateCount;
        private int hostPortEndIndex;
        private int errorIndex;
        private HostType hostType;
        private boolean isIPv6BracketsClosed;
        private HostnameParseState hostnameParseState;
        private boolean hostnameValidTLD;
        private IPv4ParseState ipv4ParseState;
        private int ipv4NumDigits;
        private int ipv4NumSegments;
        private IPv6Parser ipv6Parser;

        private Parser(Buffer buffer) {
            this.buffer = buffer;
            this.bufferStartIndex = buffer.getReaderIndex();
        }

        private SipUserHostInfo parse() throws SipParseException, IOException {
            byte b;
            this.resetHostPortParser();
            while (this.user == null && this.buffer.hasReadableBytes() && this.stateCount < 1024) {
                b = this.buffer.readByte();
                if (b == 64) {
                    int userCount = this.buffer.getReaderIndex() - this.bufferStartIndex;
                    this.buffer.setReaderIndex(this.bufferStartIndex);
                    if (userCount - 1 == 0) {
                        throw new SipParseException(userCount - 1, "No user portion in URI despite the presence of a '@'");
                    }
                    this.user = this.buffer.readBytes(userCount - 1);
                    this.buffer.readByte();
                    this.resetHostPortParser();
                    continue;
                }
                this.processHostPortCharacter(b);
            }
            while (this.parseState != HostPortParseState.INVALID && this.parseState != HostPortParseState.END && this.buffer.hasReadableBytes() && this.stateCount < 1024) {
                b = this.buffer.readByte();
                this.processHostPortCharacter(b);
            }
            if (this.parseState != HostPortParseState.END && this.parseState != HostPortParseState.INVALID && this.buffer.hasReadableBytes()) {
                int charsRead = this.buffer.getReaderIndex() - this.bufferStartIndex;
                throw new SipParseException(charsRead, "Was never able to find the end of the SIP URI. Gave up after %d characters");
            }
            this.processOutOfCharacters();
            if (this.parseState == HostPortParseState.INVALID) {
                int charsReadBeforeError = this.errorIndex - this.bufferStartIndex;
                throw new SipParseException(charsReadBeforeError, "The SIP URI does not specify a valid host. Error encountered after %d characters.");
            }
            this.buffer.setReaderIndex(this.hostPortEndIndex);
            return new SipUserHostInfo(this.user, this.host, this.port);
        }

        private void resetHostPortParser() {
            this.parseState = HostPortParseState.HOST;
            this.hostType = HostType.HOSTNAME_OR_IPV4;
            this.isIPv6BracketsClosed = false;
            this.hostnameParseState = HostnameParseState.BEGIN;
            this.ipv4ParseState = IPv4ParseState.BEGIN;
            this.ipv4NumSegments = 0;
            this.ipv6Parser = new IPv6Parser();
            this.stateStartIndex = this.buffer.getReaderIndex();
            this.stateCount = 0;
            this.host = null;
            this.port = null;
            this.hostPortEndIndex = 0;
            this.errorIndex = -1;
        }

        private void enterHostPortParseState(HostPortParseState newState) throws IOException {
            HostPortParseState oldState = this.parseState;
            int separatorChars = newState == HostPortParseState.OUT_OF_CHARS || newState == HostPortParseState.INVALID ? 0 : 1;
            this.buffer.setReaderIndex(this.stateStartIndex);
            Buffer res = this.buffer.readBytes(this.stateCount);
            switch (oldState) {
                case HOST: {
                    this.host = res;
                    switch (this.hostType) {
                        case HOSTNAME_OR_IPV4: {
                            this.host = res;
                            break;
                        }
                        case IPV6: {
                            res.setReaderIndex(1);
                            this.host = res.readBytes(this.stateCount - 2);
                        }
                    }
                    this.hostPortEndIndex = this.buffer.getReaderIndex();
                    break;
                }
                case PORT: {
                    this.port = res;
                    this.hostPortEndIndex = this.buffer.getReaderIndex();
                }
            }
            this.buffer.readBytes(separatorChars);
            if (newState == HostPortParseState.INVALID && this.errorIndex < 0) {
                this.errorIndex = this.stateStartIndex;
            } else if (newState != HostPortParseState.INVALID) {
                this.errorIndex = -1;
            }
            this.parseState = newState;
            this.stateStartIndex += this.stateCount + separatorChars;
            this.stateCount = -1;
        }

        private void processHostPortCharacter(byte b) throws IOException {
            switch (this.parseState) {
                case HOST: {
                    switch (this.hostType) {
                        case HOSTNAME_OR_IPV4: {
                            if (b == 91 && this.stateCount == 0) {
                                this.hostType = HostType.IPV6;
                                this.isIPv6BracketsClosed = false;
                                break;
                            }
                            if (b == 58) {
                                if (this.hostPortIsValid()) {
                                    this.enterHostPortParseState(HostPortParseState.PORT);
                                    break;
                                }
                                this.enterHostPortParseState(HostPortParseState.INVALID);
                                break;
                            }
                            if (b == 59 || b == 63) {
                                if (this.hostPortIsValid()) {
                                    this.enterHostPortParseState(HostPortParseState.END);
                                    break;
                                }
                                this.enterHostPortParseState(HostPortParseState.INVALID);
                                break;
                            }
                            this.processHostnameCharacter(b);
                            this.processIPv4Character(b);
                            break;
                        }
                        case IPV6: {
                            if (this.isIPv6BracketsClosed) {
                                if (b == 58) {
                                    if (this.hostPortIsValid()) {
                                        this.enterHostPortParseState(HostPortParseState.PORT);
                                        break;
                                    }
                                    this.enterHostPortParseState(HostPortParseState.INVALID);
                                    break;
                                }
                                if (b == 59 || b == 63) {
                                    if (this.hostPortIsValid()) {
                                        this.enterHostPortParseState(HostPortParseState.END);
                                        break;
                                    }
                                    this.enterHostPortParseState(HostPortParseState.INVALID);
                                    break;
                                }
                                this.enterHostPortParseState(HostPortParseState.INVALID);
                                break;
                            }
                            if (b == 93) {
                                this.isIPv6BracketsClosed = true;
                                if (this.ipv6Parser.state == IPv6Parser.State.INVALID || this.hostIsValidIPv6()) break;
                                this.errorIndex = this.buffer.getReaderIndex() - 1;
                                this.ipv6Parser.state = IPv6Parser.State.INVALID;
                                this.enterHostPortParseState(HostPortParseState.INVALID);
                                break;
                            }
                            this.processIPv6Character(b);
                        }
                    }
                    break;
                }
                case PORT: {
                    if (b == 59 || b == 63) {
                        if (this.hostPortIsValid()) {
                            this.enterHostPortParseState(HostPortParseState.END);
                            break;
                        }
                        this.enterHostPortParseState(HostPortParseState.INVALID);
                        break;
                    }
                    if (SipParser.isDigit(b)) break;
                    this.errorIndex = this.buffer.getReaderIndex() - 1;
                    this.enterHostPortParseState(HostPortParseState.INVALID);
                }
            }
            ++this.stateCount;
        }

        private boolean hostPortIsValid() {
            switch (this.parseState) {
                case HOST: {
                    return this.hostIsValidHostname() || this.hostIsValidIPv4() || this.hostIsValidIPv6();
                }
                case PORT: {
                    return this.stateCount > 0;
                }
                case END: 
                case OUT_OF_CHARS: {
                    return true;
                }
            }
            return false;
        }

        private void processOutOfCharacters() throws IOException {
            if (this.hostPortIsValid()) {
                this.enterHostPortParseState(HostPortParseState.OUT_OF_CHARS);
            } else {
                this.enterHostPortParseState(HostPortParseState.INVALID);
            }
        }

        private void processHostnameCharacter(byte b) throws IOException {
            switch (this.hostnameParseState) {
                case AT_SEPARATOR: 
                case BEGIN: {
                    if (SipParser.isAlpha(b)) {
                        this.hostnameParseState = HostnameParseState.IN_LABEL;
                        this.hostnameValidTLD = true;
                        break;
                    }
                    if (SipParser.isDigit(b)) {
                        this.hostnameParseState = HostnameParseState.IN_LABEL;
                        this.hostnameValidTLD = false;
                        this.errorIndex = this.buffer.getReaderIndex() - 1;
                        break;
                    }
                    this.errorIndex = this.buffer.getReaderIndex() - 1;
                    this.hostnameParseState = HostnameParseState.INVALID;
                    break;
                }
                case IN_LABEL: {
                    if (b == 45) {
                        this.hostnameParseState = HostnameParseState.IN_LABEL_DASH;
                        break;
                    }
                    if (b == 46) {
                        this.hostnameParseState = HostnameParseState.AT_SEPARATOR;
                        break;
                    }
                    if (SipParser.isAlphaNum(b)) break;
                    this.errorIndex = this.buffer.getReaderIndex() - 1;
                    this.hostnameParseState = HostnameParseState.INVALID;
                    break;
                }
                case IN_LABEL_DASH: {
                    if (b == 45) break;
                    if (SipParser.isAlphaNum(b)) {
                        this.hostnameParseState = HostnameParseState.IN_LABEL;
                        break;
                    }
                    this.errorIndex = this.buffer.getReaderIndex() - 1;
                    this.hostnameParseState = HostnameParseState.INVALID;
                }
            }
        }

        private boolean hostIsValidHostname() {
            return (this.hostnameParseState == HostnameParseState.IN_LABEL || this.hostnameParseState == HostnameParseState.AT_SEPARATOR) && this.hostnameValidTLD;
        }

        private void processIPv4Character(byte b) throws IOException {
            switch (this.ipv4ParseState) {
                case AT_SEPARATOR: 
                case BEGIN: {
                    if (SipParser.isDigit(b)) {
                        this.ipv4ParseState = IPv4ParseState.ACCUMULATE_DIGITS;
                        ++this.ipv4NumSegments;
                        this.ipv4NumDigits = 1;
                        break;
                    }
                    this.errorIndex = this.buffer.getReaderIndex() - 1;
                    this.ipv4ParseState = IPv4ParseState.INVALID;
                    break;
                }
                case ACCUMULATE_DIGITS: {
                    if (b == 46) {
                        this.ipv4ParseState = IPv4ParseState.AT_SEPARATOR;
                        break;
                    }
                    if (SipParser.isDigit(b) && ++this.ipv4NumDigits <= 3) break;
                    this.errorIndex = this.buffer.getReaderIndex() - 1;
                    this.ipv4ParseState = IPv4ParseState.INVALID;
                }
            }
        }

        private boolean hostIsValidIPv4() {
            return this.ipv4ParseState == IPv4ParseState.ACCUMULATE_DIGITS && this.ipv4NumSegments == 4;
        }

        private void processIPv6Character(byte b) throws IOException {
            char c = (char)b;
            switch (this.ipv6Parser.state) {
                case INVALID: {
                    return;
                }
                case HEX_PART: {
                    if (SipParser.isHexDigit(b) && this.ipv6Parser.numColons == 0) {
                        ++this.ipv6Parser.numHexDigits;
                        if (SipParser.isDigit(b)) {
                            ++this.ipv6Parser.numDigits;
                        }
                        this.ipv6Parser.state = IPv6Parser.State.HEX_SEQ;
                        return;
                    }
                    if (b != 58) break;
                    if (this.ipv6Parser.numColons == 0) {
                        this.ipv6Parser.numColons = 1;
                        return;
                    }
                    if (this.ipv6Parser.numColons != 1) break;
                    this.ipv6Parser.numColons = 0;
                    ++this.ipv6Parser.numDoubleColons;
                    this.ipv6Parser.state = IPv6Parser.State.HEX_SEQ;
                    return;
                }
                case HEX_SEQ: {
                    if (SipParser.isHexDigit(b)) {
                        ++this.ipv6Parser.numHexDigits;
                        if (SipParser.isDigit(b)) {
                            ++this.ipv6Parser.numDigits;
                        }
                        this.ipv6Parser.numColons = 0;
                        if (this.ipv6Parser.numHexDigits > 4) break;
                        return;
                    }
                    if (b == 58 && this.ipv6Parser.numHexDigits > 0) {
                        ++this.ipv6Parser.numColons;
                        this.ipv6Parser.numDigits = 0;
                        this.ipv6Parser.numHexDigits = 0;
                        return;
                    }
                    if (b == 58 && this.ipv6Parser.numColons == 0 && this.ipv6Parser.numDoubleColons == 1) {
                        this.ipv6Parser.state = IPv6Parser.State.IPV4;
                        this.ipv6Parser.numPeriods = 0;
                        this.ipv6Parser.numDigits = 0;
                        this.ipv6Parser.numHexDigits = 0;
                        return;
                    }
                    if (b == 58 && this.ipv6Parser.numColons == 1 && this.ipv6Parser.numDoubleColons == 0) {
                        this.ipv6Parser.numColons = 0;
                        ++this.ipv6Parser.numDoubleColons;
                        return;
                    }
                    if (b != 46 || this.ipv6Parser.numDigits <= 0 || this.ipv6Parser.numDigits > 3) break;
                    this.ipv6Parser.state = IPv6Parser.State.IPV4;
                    this.ipv6Parser.numPeriods = 1;
                    this.ipv6Parser.numDigits = 0;
                    this.ipv6Parser.numHexDigits = 0;
                    return;
                }
                case IPV4: {
                    if (SipParser.isDigit(b)) {
                        ++this.ipv6Parser.numDigits;
                        if (this.ipv6Parser.numDigits > 3) break;
                        return;
                    }
                    if (b != 46 || this.ipv6Parser.numDigits <= 0 || this.ipv6Parser.numDigits > 3 || this.ipv6Parser.numPeriods > 3) break;
                    this.ipv6Parser.state = IPv6Parser.State.IPV4;
                    ++this.ipv6Parser.numPeriods;
                    this.ipv6Parser.numDigits = 0;
                    if (this.ipv6Parser.numPeriods > 3) break;
                    return;
                }
            }
            this.errorIndex = this.buffer.getReaderIndex() - 1;
            this.ipv6Parser.state = IPv6Parser.State.INVALID;
        }

        private boolean hostIsValidIPv6() {
            switch (this.ipv6Parser.state) {
                case INVALID: 
                case HEX_PART: {
                    return false;
                }
                case HEX_SEQ: {
                    return this.ipv6Parser.numHexDigits > 0 || this.ipv6Parser.numDoubleColons == 1;
                }
                case IPV4: {
                    return this.ipv6Parser.numPeriods == 3 && this.ipv6Parser.numDigits > 0;
                }
            }
            return false;
        }

        private static class IPv6Parser {
            public State state = State.HEX_PART;
            public int numDigits = 0;
            public int numHexDigits = 0;
            public int numDoubleColons = 0;
            public int numColons = 0;
            public int numPeriods = 0;

            private IPv6Parser() {
            }

            public static enum State {
                INVALID,
                HEX_PART,
                HEX_SEQ,
                IPV4;

            }
        }

        private static enum IPv4ParseState {
            BEGIN,
            INVALID,
            ACCUMULATE_DIGITS,
            AT_SEPARATOR;

        }

        private static enum HostnameParseState {
            BEGIN,
            INVALID,
            IN_LABEL,
            IN_LABEL_DASH,
            AT_SEPARATOR;

        }

        private static enum HostType {
            HOSTNAME_OR_IPV4,
            IPV6;

        }

        private static enum HostPortParseState {
            HOST,
            PORT,
            INVALID,
            END,
            OUT_OF_CHARS;

        }
    }
}

