/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipMessage;
import io.pkts.packet.sip.header.ContentLengthHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.impl.SipHeaderImpl;
import io.pkts.packet.sip.impl.ImmutableSipMessage;
import io.pkts.packet.sip.impl.ImmutableSipRequest;
import io.pkts.packet.sip.impl.ImmutableSipResponse;
import io.pkts.packet.sip.impl.SipInitialLine;
import io.pkts.packet.sip.impl.SipParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class SipMessageStreamBuilder {
    private final Configuration config;
    private State state = State.INIT;
    private int start;
    private SipInitialLine sipInitialLine;
    private Buffer buffer;
    private Buffer payload = Buffers.EMPTY_BUFFER;
    private Buffer headerName = null;
    private Map<String, List<SipHeader>> headers = new HashMap<String, List<SipHeader>>();
    private int contentLength;
    private SipHeader toHeader;
    private SipHeader fromHeader;
    private SipHeader cSeqHeader;
    private SipHeader callIdHeader;
    private SipHeader maxForwardsHeader;
    private SipHeader viaHeader;
    private SipHeader routeHeader;
    private SipHeader recordRouteHeader;
    private SipHeader contactHeader;
    private final SipParser.HeaderValueState headerValueState;
    private final Function<Buffer, State>[] actions = new Function[State.values().length];

    public SipMessageStreamBuilder(Configuration config) {
        this.config = config;
        this.resetBuffer();
        this.reset();
        this.headerValueState = new SipParser.HeaderValueState(0);
        this.actions[State.INIT.ordinal()] = this::onInit;
        this.actions[State.GET_INITIAL_LINE.ordinal()] = this::onInitialLine;
        this.actions[State.GET_HEADER_NAME.ordinal()] = this::onHeaderName;
        this.actions[State.CONSUME_HCOLON.ordinal()] = this::onConsumeHColon;
        this.actions[State.CONSUME_SWS_AFTER_HCOLON.ordinal()] = this::onConsumeSWSAfterHColon;
        this.actions[State.GET_HEADER_VALUES.ordinal()] = this::onHeaderValues;
        this.actions[State.CHECK_FOR_END_OF_HEADER_SECTION.ordinal()] = this::onCheckEndHeaderSection;
        this.actions[State.GET_PAYLOAD.ordinal()] = this::onPayload;
        this.actions[State.DONE.ordinal()] = this::onDone;
    }

    private void resetBuffer() {
        this.buffer = Buffers.createBuffer((int)(this.config.getMaxAllowedInitialLineSize() + this.config.getMaxAllowedHeadersSize() + this.config.getMaxAllowedContentLength()));
    }

    private void reset() {
        this.state = State.INIT;
        this.payload = Buffers.EMPTY_BUFFER;
        this.sipInitialLine = null;
        this.start = 0;
        this.headerName = null;
        this.headers = new HashMap<String, List<SipHeader>>();
        this.contentLength = 0;
        this.toHeader = null;
        this.fromHeader = null;
        this.cSeqHeader = null;
        this.callIdHeader = null;
        this.maxForwardsHeader = null;
        this.viaHeader = null;
        this.routeHeader = null;
        this.recordRouteHeader = null;
        this.contactHeader = null;
    }

    public SipMessage build() throws IllegalStateException {
        if (this.state != State.DONE) {
            throw new IllegalStateException("We have not framed enough data for a complete message yet");
        }
        int extraDataStart = this.buffer.getReaderIndex();
        int length = this.buffer.getWriterIndex() - extraDataStart;
        Buffer msg = this.buffer;
        msg.setWriterIndex(msg.getReaderIndex());
        msg.setReaderIndex(this.start);
        this.resetBuffer();
        byte[] oldData = msg.getRawArray();
        byte[] newData = this.buffer.getRawArray();
        System.arraycopy(oldData, extraDataStart, newData, 0, length);
        this.buffer.setWriterIndex(length);
        ImmutableSipMessage sipMessage = null;
        sipMessage = this.sipInitialLine.isRequestLine() ? new ImmutableSipRequest(msg, this.sipInitialLine.toRequestLine(), this.headers, this.toHeader, this.fromHeader, this.cSeqHeader, this.callIdHeader, this.maxForwardsHeader, this.viaHeader, this.routeHeader, this.recordRouteHeader, this.contactHeader, this.payload) : new ImmutableSipResponse(msg, this.sipInitialLine.toResponseLine(), this.headers, this.toHeader, this.fromHeader, this.cSeqHeader, this.callIdHeader, this.maxForwardsHeader, this.viaHeader, this.routeHeader, this.recordRouteHeader, this.contactHeader, this.payload);
        this.reset();
        return sipMessage;
    }

    public int getWriterIndex() {
        return this.buffer.getWriterIndex();
    }

    public int getWritableBytes() {
        return this.buffer.getWritableBytes();
    }

    public boolean hasUnprocessData() {
        return this.buffer.hasReadableBytes();
    }

    public boolean process() {
        return this.process(null);
    }

    public boolean process(byte[] newData) {
        if (newData != null) {
            this.buffer.write(newData);
        }
        boolean done = false;
        while (!done) {
            int index = this.buffer.getReaderIndex();
            State currentState = this.state;
            this.state = this.actions[this.state.ordinal()].apply(this.buffer);
            done = this.state == currentState && this.buffer.getReaderIndex() == index;
        }
        return this.state == State.DONE;
    }

    public boolean isDone() {
        return this.state == State.DONE;
    }

    private final State onDone(Buffer buffer) {
        return State.DONE;
    }

    private final State onInit(Buffer buffer) {
        try {
            while (buffer.hasReadableBytes()) {
                byte b = buffer.peekByte();
                if (b == 32 || b == 9 || b == 13 || b == 10) {
                    buffer.readByte();
                    continue;
                }
                this.start = buffer.getReaderIndex();
                return State.GET_INITIAL_LINE;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read from stream due to IOException", e);
        }
        return State.INIT;
    }

    private final State onInitialLine(Buffer buffer) {
        try {
            buffer.markReaderIndex();
            Buffer part1 = buffer.readUntilSafe(this.config.getMaxAllowedInitialLineSize(), new byte[]{32});
            Buffer part2 = buffer.readUntilSafe(this.config.getMaxAllowedInitialLineSize(), new byte[]{32});
            Buffer part3 = buffer.readUntilSingleCRLF();
            if (part1 == null || part2 == null || part3 == null) {
                buffer.resetReaderIndex();
                return State.GET_INITIAL_LINE;
            }
            this.sipInitialLine = SipInitialLine.parse(part1, part2, part3);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read from stream due to IOException", e);
        }
        return State.GET_HEADER_NAME;
    }

    private final State onHeaderName(Buffer buffer) {
        this.headerName = SipParser.nextHeaderNameDontCheckHColon(buffer);
        if (this.headerName == null) {
            return State.GET_HEADER_NAME;
        }
        return State.CONSUME_HCOLON;
    }

    private final State onConsumeHColon(Buffer buffer) {
        if (SipParser.expectHCOLONStreamFriendly(buffer) == -1) {
            return State.CONSUME_HCOLON;
        }
        return State.CONSUME_SWS_AFTER_HCOLON;
    }

    private final State onConsumeSWSAfterHColon(Buffer buffer) {
        try {
            SipParser.consumeSWSAfterHColon(buffer);
            if (buffer.hasReadableBytes()) {
                this.headerValueState.reset(buffer.getReaderIndex());
                return State.GET_HEADER_VALUES;
            }
            return State.CONSUME_SWS_AFTER_HCOLON;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read from stream due to IOException", e);
        }
    }

    private final State onHeaderValues(Buffer buffer) {
        try {
            SipParser.readHeaderValues(this.headerValueState, this.headerName, buffer);
            if (this.headerValueState.done) {
                List<Buffer> values = this.headerValueState.values;
                for (Buffer value : values) {
                    SipHeader header = new SipHeaderImpl(this.headerName, value);
                    if (header.isContentLengthHeader()) {
                        ContentLengthHeader l = header.ensure().toContentLengthHeader();
                        this.contentLength = l.getContentLength();
                        header = l;
                    } else if (this.contactHeader == null && header.isContactHeader()) {
                        this.contactHeader = header = header.ensure();
                    } else if (this.cSeqHeader == null && header.isCSeqHeader()) {
                        this.cSeqHeader = header = header.ensure();
                    } else if (this.maxForwardsHeader == null && header.isMaxForwardsHeader()) {
                        this.maxForwardsHeader = header = header.ensure();
                    } else if (this.fromHeader == null && header.isFromHeader()) {
                        this.fromHeader = header = header.ensure();
                    } else if (this.toHeader == null && header.isToHeader()) {
                        this.toHeader = header = header.ensure();
                    } else if (this.viaHeader == null && header.isViaHeader()) {
                        this.viaHeader = header = header.ensure();
                    } else if (this.callIdHeader == null && header.isCallIdHeader()) {
                        this.callIdHeader = header = header.ensure();
                    } else if (this.routeHeader == null && header.isRouteHeader()) {
                        this.routeHeader = header = header.ensure();
                    } else if (this.recordRouteHeader == null && header.isRecordRouteHeader()) {
                        this.recordRouteHeader = header = header.ensure();
                    }
                    this.headers.computeIfAbsent(this.headerName.toString(), k -> new ArrayList()).add(header);
                }
                return State.CHECK_FOR_END_OF_HEADER_SECTION;
            }
            return State.GET_HEADER_VALUES;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read from stream due to IOException", e);
        }
    }

    private final State onCheckEndHeaderSection(Buffer buffer) {
        if (buffer.getReadableBytes() < 2) {
            return State.CHECK_FOR_END_OF_HEADER_SECTION;
        }
        if (SipParser.consumeCRLF(buffer) == 2) {
            return State.GET_PAYLOAD;
        }
        return State.GET_HEADER_NAME;
    }

    private final State onPayload(Buffer buffer) {
        if (this.contentLength == 0) {
            return State.DONE;
        }
        if (buffer.getReadableBytes() >= this.contentLength) {
            try {
                this.payload = buffer.readBytes(this.contentLength);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read from stream due to IOException", e);
            }
            return State.DONE;
        }
        return State.GET_PAYLOAD;
    }

    public byte[] getArray() {
        return this.buffer.getRawArray();
    }

    private static enum State {
        INIT,
        GET_INITIAL_LINE,
        GET_HEADER_NAME,
        CONSUME_HCOLON,
        CONSUME_SWS_AFTER_HCOLON,
        GET_HEADER_VALUES,
        CHECK_FOR_END_OF_HEADER_SECTION,
        GET_PAYLOAD,
        DONE;

    }

    public static class DefaultConfiguration
    implements Configuration {
        private int maxAllowedInitialLineSize = 1024;
        private int maxAllowedHeadersSize = 4096;
        private int maxAllowedContentLength = 4096;

        @Override
        public int getMaxAllowedInitialLineSize() {
            return this.maxAllowedInitialLineSize;
        }

        @Override
        public int getMaxAllowedHeadersSize() {
            return this.maxAllowedHeadersSize;
        }

        @Override
        public int getMaxAllowedContentLength() {
            return this.maxAllowedContentLength;
        }

        public void setMaxAllowedInitialLineSize(int value) {
            this.maxAllowedInitialLineSize = value;
        }

        public void setMaxAllowedHeadersSize(int value) {
            this.maxAllowedHeadersSize = value;
        }

        public void setMaxAllowedContentLength(int value) {
            this.maxAllowedContentLength = value;
        }
    }

    public static interface Configuration {
        public int getMaxAllowedInitialLineSize();

        public int getMaxAllowedHeadersSize();

        public int getMaxAllowedContentLength();
    }
}

