/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.Transport;
import io.pkts.packet.sip.header.Parameters;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.ViaHeader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public final class ViaHeaderImpl
implements ViaHeader,
SipHeader,
Parameters {
    private final Buffer original;
    private final Transport transport;
    private final Buffer host;
    private final int port;
    private final List<Buffer[]> params;
    private int indexOfBranch = -1;
    private int indexOfReceived = -1;
    private int indexOfRPort = -1;

    public ViaHeaderImpl(Buffer via, Transport transport, Buffer host, int port, List<Buffer[]> params, int indexOfBranch, int indexOfReceived, int indexOfRPort) {
        this.original = via;
        this.transport = transport;
        this.host = host;
        this.port = port;
        this.params = Collections.unmodifiableList(params);
        this.indexOfBranch = indexOfBranch;
        this.indexOfReceived = indexOfReceived;
        this.indexOfRPort = indexOfRPort;
    }

    @Override
    public Buffer getParameter(Buffer name) throws SipParseException, IllegalArgumentException {
        int index = this.findParameter(name);
        if (index == -1) {
            return null;
        }
        return this.params.get(index)[1];
    }

    @Override
    public Buffer getParameter(String name) throws SipParseException, IllegalArgumentException {
        return this.getParameter(Buffers.wrap((String)name));
    }

    @Override
    public void setParameter(Buffer name, Buffer value) throws SipParseException, IllegalArgumentException {
        throw new IllegalArgumentException("Forbidden");
    }

    @Override
    public void setParameter(Buffer name, Supplier<Buffer> value) throws SipParseException, IllegalArgumentException {
        throw new IllegalArgumentException("Forbidden");
    }

    @Override
    public Buffer getName() {
        return ViaHeader.NAME;
    }

    @Override
    public Buffer getTransport() {
        return this.transport.toUpperCaseBuffer();
    }

    @Override
    public int getTTL() {
        return -1;
    }

    @Override
    public Buffer getValue() {
        return this.original;
    }

    @Override
    public Buffer getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public Buffer getReceived() {
        if (this.indexOfReceived == -1) {
            return null;
        }
        return this.params.get(this.indexOfReceived)[1];
    }

    @Override
    public boolean hasRPort() {
        return this.indexOfRPort != -1;
    }

    @Override
    public int getRPort() {
        if (this.indexOfRPort == -1) {
            return -1;
        }
        Buffer port = this.params.get(this.indexOfRPort)[1];
        if (port == null) {
            return -1;
        }
        try {
            return port.parseToInt();
        }
        catch (NumberFormatException e) {
            return -1;
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Override
    public Buffer getBranch() {
        if (this.indexOfBranch == -1) {
            return null;
        }
        return this.params.get(this.indexOfBranch)[1];
    }

    private int findParameter(Buffer param) {
        for (int i = 0; i < this.params.size(); ++i) {
            Buffer[] keyValue = this.params.get(i);
            if (!keyValue[0].equals((Object)param)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isUDP() {
        return this.transport == Transport.udp;
    }

    @Override
    public boolean isTCP() {
        return this.transport == Transport.tcp;
    }

    @Override
    public boolean isTLS() {
        return this.transport == Transport.tls;
    }

    @Override
    public boolean isSCTP() {
        return this.transport == Transport.sctp;
    }

    @Override
    public boolean isWS() {
        return this.transport == Transport.ws;
    }

    @Override
    public boolean isWSS() {
        return this.transport == Transport.wss;
    }

    @Override
    public void verify() throws SipParseException {
    }

    public String toString() {
        return NAME.toString() + ": " + this.original.toString();
    }

    @Override
    public void getBytes(Buffer dst) {
        NAME.getBytes(0, dst);
        dst.write((byte)58);
        dst.write((byte)32);
        this.original.getBytes(0, dst);
    }

    @Override
    public ViaHeader clone() {
        return new ViaHeaderImpl(this.original, this.transport, this.host, this.port, this.params, this.indexOfBranch, this.indexOfReceived, this.indexOfRPort);
    }

    @Override
    public ViaHeader ensure() {
        return this;
    }

    @Override
    public ViaHeader.Builder copy() {
        return new ViaHeader.Builder(this.transport, this.host, this.port, new ArrayList<Buffer[]>(this.params), this.indexOfBranch, this.indexOfReceived, this.indexOfRPort);
    }
}

