/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.sonatype.spice.zapper.Parameters;
import org.sonatype.spice.zapper.internal.PayloadSupplier;
import org.sonatype.spice.zapper.internal.Protocol;
import org.sonatype.spice.zapper.internal.Transfer;
import org.sonatype.spice.zapper.internal.transport.AbstractChargerTrack;
import org.sonatype.spice.zapper.internal.transport.AbstractClient;
import org.sonatype.spice.zapper.internal.transport.State;
import org.sonatype.spice.zapper.internal.transport.TrackIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChargerClient<T extends AbstractChargerTrack>
extends AbstractClient<T> {
    public AbstractChargerClient(Parameters parameters, String remoteUrl) {
        super(parameters, remoteUrl);
    }

    @Override
    public void close() {
    }

    @Override
    protected void doUpload(Transfer transfer, Protocol protocol, int trackCount) throws IOException {
        ExecutorService executorService = Executors.newFixedThreadPool(this.getParameters().getMaximumTrackCount());
        PayloadSupplier payloadSupplier = transfer.getPayloadSupplier();
        ArrayList<Callable<State>> tracks = new ArrayList<Callable<State>>(trackCount);
        for (int i = 0; i < trackCount; ++i) {
            tracks.add(this.createCallable(transfer.getNextTrackIdentifier(), transfer, protocol, payloadSupplier));
        }
        try {
            List futures = executorService.invokeAll(tracks);
            for (Future future : futures) {
                future.get();
            }
        }
        catch (Exception e) {
            IOException ee = new IOException("Failure:" + e.toString());
            ee.initCause(e);
            throw ee;
        }
        finally {
            executorService.shutdownNow();
        }
    }

    protected abstract Callable<State> createCallable(TrackIdentifier var1, Transfer var2, Protocol var3, PayloadSupplier var4);
}

