/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.hash;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.sonatype.spice.zapper.hash.Hash;
import org.sonatype.spice.zapper.hash.HashAlgorithm;
import org.sonatype.spice.zapper.hash.HashAlgorithmIdentifier;
import org.sonatype.spice.zapper.hash.HashingInputStream;
import org.sonatype.spice.zapper.hash.HashingOutputStream;
import org.sonatype.spice.zapper.internal.AbstractIdentified;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageDigestHashAlgorithm
extends AbstractIdentified<HashAlgorithmIdentifier>
implements HashAlgorithm {
    public AbstractMessageDigestHashAlgorithm(HashAlgorithmIdentifier identifier) throws NoSuchAlgorithmException {
        super(identifier);
        MessageDigest.getInstance(((HashAlgorithmIdentifier)this.getIdentifier()).stringValue());
    }

    @Override
    public Hash hash(byte[] buffer) {
        return new Hash((HashAlgorithmIdentifier)this.getIdentifier(), this.getMessageDigest().digest(buffer));
    }

    @Override
    public HashingInputStream hashInput(InputStream input) {
        return new HashingInputStream(new DigestInputStream(input, this.getMessageDigest())){

            public Hash getHash() {
                return new Hash((HashAlgorithmIdentifier)AbstractMessageDigestHashAlgorithm.this.getIdentifier(), ((DigestInputStream)this.in).getMessageDigest().digest());
            }
        };
    }

    @Override
    public HashingOutputStream hashOutput(OutputStream output) {
        return new HashingOutputStream(new DigestOutputStream(output, this.getMessageDigest())){

            public Hash getHash() {
                return new Hash((HashAlgorithmIdentifier)AbstractMessageDigestHashAlgorithm.this.getIdentifier(), ((DigestOutputStream)this.out).getMessageDigest().digest());
            }
        };
    }

    protected MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(((HashAlgorithmIdentifier)this.getIdentifier()).stringValue());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No suitable MessageDigest available!", e);
        }
    }
}

