/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.workflow.rc;

import com.sonatype.nexus.staging.api.dto.StagingActionDTO;
import com.sonatype.nexus.staging.client.StagingWorkflowV2Service;
import com.sonatype.nexus.staging.client.StagingWorkflowV3Service;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.sonatype.nexus.maven.staging.StagingAction;
import org.sonatype.nexus.maven.staging.workflow.rc.AbstractStagingRcActionMojo;

@Mojo(name="rc-release", requiresProject=false, requiresDirectInvocation=true, requiresOnline=true)
public class RcReleaseStageRepositoryMojo
extends AbstractStagingRcActionMojo {
    @Parameter(property="autoDropAfterRelease", defaultValue="true")
    private boolean autoDropAfterRelease;

    @Override
    public void doExecute(StagingWorkflowV2Service stagingWorkflow) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("RC-Releasing staging repository with IDs=" + Arrays.toString(this.getStagingRepositoryIds())));
        String description = this.getDescriptionWithDefaultsForAction(StagingAction.RELEASE);
        if (stagingWorkflow instanceof StagingWorkflowV3Service) {
            StagingWorkflowV3Service v3 = (StagingWorkflowV3Service)stagingWorkflow;
            StagingActionDTO action = new StagingActionDTO();
            action.setDescription(description);
            action.setStagedRepositoryIds(Arrays.asList(this.getStagingRepositoryIds()));
            action.setAutoDropAfterRelease(this.autoDropAfterRelease);
            v3.releaseStagingRepositories(action);
        } else {
            stagingWorkflow.releaseStagingRepositories(description, this.getStagingRepositoryIds());
        }
        this.getLog().info((CharSequence)"Released");
    }
}

