/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.project.MavenProject;

@Named(value="requireActiveProfile")
public final class RequireActiveProfile
extends AbstractStandardEnforcerRule {
    private String profiles = null;
    private boolean all = true;
    private final MavenProject project;

    @Inject
    public RequireActiveProfile(MavenProject project) {
        this.project = Objects.requireNonNull(project);
    }

    public String getProfiles() {
        return this.profiles;
    }

    public void setProfiles(String profiles) {
        this.profiles = profiles;
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public void execute() throws EnforcerRuleException {
        ArrayList<String> missingProfiles = new ArrayList<String>();
        if (this.profiles != null && !this.profiles.isEmpty()) {
            String[] profileIds;
            for (String profileId : profileIds = this.profiles.split(",")) {
                if (this.isProfileActive(this.project, profileId)) continue;
                missingProfiles.add(profileId);
            }
            boolean fail = false;
            if (!missingProfiles.isEmpty() && (this.all || missingProfiles.size() == profileIds.length)) {
                fail = true;
            }
            if (fail) {
                String message = this.getMessage();
                StringBuilder buf = new StringBuilder();
                if (message != null) {
                    buf.append(message + System.lineSeparator());
                }
                for (String profile : missingProfiles) {
                    buf.append("Profile \"" + profile + "\" is not activated." + System.lineSeparator());
                }
                throw new EnforcerRuleException(buf.toString());
            }
        }
    }

    private boolean isProfileActive(MavenProject project, String profileId) {
        for (Map.Entry entry : project.getInjectedProfileIds().entrySet()) {
            if (!((List)entry.getValue()).contains(profileId)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("RequireActiveProfile[message=%s, profiles=%s, all=%b]", this.getMessage(), this.profiles, this.all);
    }
}

