/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.project.MavenProject;

@Named(value="banDistributionManagement")
public final class BanDistributionManagement
extends AbstractStandardEnforcerRule {
    private boolean allowRepository = false;
    private boolean allowSnapshotRepository = false;
    private boolean allowSite = false;
    private final MavenProject project;

    @Inject
    public BanDistributionManagement(MavenProject project) {
        this.project = Objects.requireNonNull(project);
    }

    public void execute() throws EnforcerRuleException {
        if (this.project.isExecutionRoot()) {
            if (this.project.getParent() == null) {
                this.getLog().debug((CharSequence)"We have no parent and in the root of a build we don't check anything,");
                this.getLog().debug((CharSequence)"because that is the location where we defined maven-enforcer-plugin.");
            } else {
                this.getLog().debug((CharSequence)"We are in the root of the execution and we have a parent.");
                DistributionManagementCheck check = new DistributionManagementCheck(this.project);
                check.execute(this.isAllowRepository(), this.isAllowSnapshotRepository(), this.isAllowSite());
            }
        } else {
            this.getLog().debug((CharSequence)"We are in a deeper level.");
            DistributionManagementCheck check = new DistributionManagementCheck(this.project);
            check.execute(this.isAllowRepository(), this.isAllowSnapshotRepository(), this.isAllowSite());
        }
    }

    public boolean isAllowRepository() {
        return this.allowRepository;
    }

    public void setAllowRepository(boolean allowRepository) {
        this.allowRepository = allowRepository;
    }

    public boolean isAllowSnapshotRepository() {
        return this.allowSnapshotRepository;
    }

    public void setAllowSnapshotRepository(boolean allowSnapshotRepository) {
        this.allowSnapshotRepository = allowSnapshotRepository;
    }

    public boolean isAllowSite() {
        return this.allowSite;
    }

    public void setAllowSite(boolean allowSite) {
        this.allowSite = allowSite;
    }

    public String toString() {
        return String.format("BanDistributionManagement[allowRepository=%b, allowSnapshotRepository=%b, allowSite=%b]", this.allowRepository, this.allowSnapshotRepository, this.allowSite);
    }

    private static class DistributionManagementCheck {
        private DistributionManagement distributionManagement;

        DistributionManagementCheck(MavenProject project) {
            this.distributionManagement = project.getOriginalModel().getDistributionManagement();
        }

        public void execute(boolean isAllowRepository, boolean isAllowSnapshotRepository, boolean isAllowSite) throws EnforcerRuleException {
            if (this.hasDistributionManagement()) {
                if (!isAllowRepository && this.hasRepository()) {
                    throw new EnforcerRuleException("You have defined a repository in distributionManagement.");
                }
                if (!isAllowSnapshotRepository && this.hasSnapshotRepository()) {
                    throw new EnforcerRuleException("You have defined a snapshotRepository in distributionManagement.");
                }
                if (!isAllowSite && this.hasSite()) {
                    throw new EnforcerRuleException("You have defined a site in distributionManagement.");
                }
            }
        }

        private boolean hasRepository() {
            return this.getDistributionManagement().getRepository() != null;
        }

        public DistributionManagement getDistributionManagement() {
            return this.distributionManagement;
        }

        public void setDistributionManagement(DistributionManagement distributionManagement) {
            this.distributionManagement = distributionManagement;
        }

        private boolean hasSnapshotRepository() {
            return this.getDistributionManagement().getSnapshotRepository() != null;
        }

        private boolean hasSite() {
            return this.getDistributionManagement().getSite() != null;
        }

        private boolean hasDistributionManagement() {
            return this.getDistributionManagement() != null;
        }
    }
}

