/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.core.condition.internal;

import org.sonatype.nexus.client.core.condition.internal.GenericVersion;
import org.sonatype.nexus.client.core.condition.internal.GenericVersionConstraint;
import org.sonatype.nexus.client.core.condition.internal.GenericVersionRange;
import org.sonatype.nexus.client.core.condition.internal.InvalidVersionSpecificationException;
import org.sonatype.nexus.client.core.condition.internal.Version;
import org.sonatype.nexus.client.core.condition.internal.VersionConstraint;
import org.sonatype.nexus.client.core.condition.internal.VersionRange;
import org.sonatype.nexus.client.core.condition.internal.VersionScheme;

public class GenericVersionScheme
implements VersionScheme {
    @Override
    public Version parseVersion(String version) throws InvalidVersionSpecificationException {
        return new GenericVersion(version);
    }

    @Override
    public VersionRange parseVersionRange(String range) throws InvalidVersionSpecificationException {
        return new GenericVersionRange(range);
    }

    @Override
    public VersionConstraint parseVersionConstraint(String constraint) throws InvalidVersionSpecificationException {
        GenericVersionConstraint result = new GenericVersionConstraint();
        String process = constraint;
        while (process.startsWith("[") || process.startsWith("(")) {
            int index2;
            int index1 = process.indexOf(41);
            int index = index2 = process.indexOf(93);
            if (index2 < 0 || index1 >= 0 && index1 < index2) {
                index = index1;
            }
            if (index < 0) {
                throw new InvalidVersionSpecificationException(constraint, "Unbounded version range " + constraint);
            }
            VersionRange range = this.parseVersionRange(process.substring(0, index + 1));
            result.addRange(range);
            if ((process = process.substring(index + 1).trim()).length() <= 0 || !process.startsWith(",")) continue;
            process = process.substring(1).trim();
        }
        if (process.length() > 0 && !result.getRanges().isEmpty()) {
            throw new InvalidVersionSpecificationException(constraint, "Invalid version range " + constraint + ", expected [ or ( but got " + process);
        }
        if (result.getRanges().isEmpty()) {
            result.setVersion(this.parseVersion(constraint));
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

