/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.Debug;
import gov.nist.core.LexerCore;
import gov.nist.core.NameValue;
import gov.nist.core.Token;
import java.text.ParseException;

public abstract class ParserCore {
    public static final boolean debug = Debug.parserDebug;
    static int nesting_level;
    protected LexerCore lexer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected NameValue nameValue(char separator) throws ParseException {
        if (debug) {
            this.dbg_enter("nameValue");
        }
        try {
            Token name;
            block10: {
                NameValue nameValue;
                this.lexer.match(4095);
                name = this.lexer.getNextToken();
                this.lexer.SPorHT();
                try {
                    boolean quoted = false;
                    char la = this.lexer.lookAhead(0);
                    if (la != separator) break block10;
                    this.lexer.consume(1);
                    this.lexer.SPorHT();
                    String str = null;
                    boolean isFlag = false;
                    if (this.lexer.lookAhead(0) == '\"') {
                        str = this.lexer.quotedString();
                        quoted = true;
                    } else {
                        this.lexer.match(4095);
                        Token value = this.lexer.getNextToken();
                        str = value.tokenValue;
                        if (str == null) {
                            str = "";
                            isFlag = true;
                        }
                    }
                    NameValue nv = new NameValue(name.tokenValue, str, isFlag);
                    if (quoted) {
                        nv.setQuotedValue();
                    }
                    nameValue = nv;
                }
                catch (ParseException ex) {
                    NameValue nameValue2 = new NameValue(name.tokenValue, null, false);
                    Object var10_14 = null;
                    if (!debug) return nameValue2;
                    this.dbg_leave("nameValue");
                    return nameValue2;
                }
                Object var10_12 = null;
                if (!debug) return nameValue;
                this.dbg_leave("nameValue");
                return nameValue;
            }
            NameValue nameValue = new NameValue(name.tokenValue, "", true);
            Object var10_13 = null;
            if (!debug) return nameValue;
            this.dbg_leave("nameValue");
            return nameValue;
        }
        catch (Throwable throwable2) {
            Object var10_15 = null;
            if (!debug) throw throwable2;
            this.dbg_leave("nameValue");
            throw throwable2;
        }
    }

    protected void dbg_enter(String rule) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nesting_level; ++i) {
            stringBuilder.append(">");
        }
        if (debug) {
            System.out.println(stringBuilder + rule + "\nlexer buffer = \n" + this.lexer.getRest());
        }
        ++nesting_level;
    }

    protected void dbg_leave(String rule) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nesting_level; ++i) {
            stringBuilder.append("<");
        }
        if (debug) {
            System.out.println(stringBuilder + rule + "\nlexer buffer = \n" + this.lexer.getRest());
        }
        --nesting_level;
    }

    protected NameValue nameValue() throws ParseException {
        return this.nameValue('=');
    }

    protected void peekLine(String rule) {
        if (debug) {
            Debug.println(rule + " " + this.lexer.peekLine());
        }
    }
}

