/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.dcsctp4j;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.dcsctp4j.DcSctp4j;
import org.jitsi.dcsctp4j.DcSctpMessage;
import org.jitsi.dcsctp4j.DcSctpOptions;
import org.jitsi.dcsctp4j.DcSctpSocketCallbacks;
import org.jitsi.dcsctp4j.DcSctpSocketInterface;
import org.jitsi.dcsctp4j.Metrics;
import org.jitsi.dcsctp4j.PacketObserver;
import org.jitsi.dcsctp4j.ResetStreamsStatus;
import org.jitsi.dcsctp4j.SendOptions;
import org.jitsi.dcsctp4j.SendStatus;
import org.jitsi.dcsctp4j.SocketState;
import smjni.jnigen.ExposeToNative;

@ExposeToNative
public class DcSctpSocketFactory {
    private final long ptr;

    public DcSctpSocketFactory() {
        long ptrCopy = this.ptr = DcSctpSocketFactory.construct();
        DcSctp4j.CLEANER.register(this, () -> DcSctpSocketFactory.destruct(ptrCopy));
    }

    private static native long construct();

    private static native void destruct(long var0);

    public DcSctpSocketInterface create(@NotNull String logPrefix, @NotNull DcSctpSocketCallbacks callbacks, @Nullable PacketObserver packetObserver, @NotNull DcSctpOptions options) {
        long socketPtr = this.create_(this.ptr, logPrefix, callbacks, packetObserver, options);
        return new NativeSctpSocket(callbacks, packetObserver, socketPtr);
    }

    private native long create_(long var1, @NotNull String var3, @NotNull DcSctpSocketCallbacks var4, @Nullable PacketObserver var5, @NotNull DcSctpOptions var6);

    static {
        DcSctp4j.init();
    }

    @ExposeToNative
    private static class NativeSctpSocket
    implements DcSctpSocketInterface {
        @NotNull
        DcSctpSocketCallbacks callbacks;
        @Nullable
        PacketObserver packetObserver;
        private final long ptr;

        NativeSctpSocket(@NotNull DcSctpSocketCallbacks callbacks, @Nullable PacketObserver packetObserver, long ptr) {
            this.callbacks = callbacks;
            this.packetObserver = packetObserver;
            this.ptr = ptr;
            DcSctp4j.CLEANER.register(this, () -> NativeSctpSocket.destruct(ptr));
        }

        private static native void destruct(long var0);

        @Override
        public synchronized void receivePacket(byte @NotNull [] data, int offset, int length) {
            if (offset + length > data.length) {
                throw new IllegalArgumentException("Array length " + data.length + " too short for offset " + offset + " length " + length);
            }
            this.receivePacket_(this.ptr, data, offset, length);
        }

        private native void receivePacket_(long var1, byte[] var3, int var4, int var5);

        @Override
        public synchronized void handleTimeout(long timeoutId) {
            this.handleTimeout_(this.ptr, timeoutId);
        }

        private native void handleTimeout_(long var1, long var3);

        @Override
        public synchronized void connect() {
            this.connect_(this.ptr);
        }

        private native void connect_(long var1);

        @Override
        public synchronized void shutdown() {
            this.shutdown_(this.ptr);
        }

        private native void shutdown_(long var1);

        @Override
        public synchronized void close() {
            this.close_(this.ptr);
        }

        private native void close_(long var1);

        @Override
        @NotNull
        public synchronized SocketState state() {
            return this.state_(this.ptr);
        }

        private native SocketState state_(long var1);

        @Override
        @NotNull
        public synchronized DcSctpOptions options() {
            return this.options_(this.ptr);
        }

        private native DcSctpOptions options_(long var1);

        @Override
        public synchronized void setStreamPriority(short streamId, short streamPriority) {
            this.setStreamPriority_(this.ptr, streamId, streamPriority);
        }

        private native void setStreamPriority_(long var1, short var3, short var4);

        @Override
        public synchronized short getStreamPriority(short streamId) {
            return this.getStreamPriority_(this.ptr, streamId);
        }

        private native short getStreamPriority_(long var1, short var3);

        @Override
        @NotNull
        public synchronized SendStatus send(@NotNull DcSctpMessage message, @NotNull SendOptions options) {
            int nativeStatus = this.send_(this.ptr, message.getPayload(), message.getPpid(), message.getStreamID(), options.isUnordered, options.lifetime, options.maxRetransmissions, options.lifecycleId);
            return SendStatus.fromNativeStatus(nativeStatus);
        }

        private native int send_(long var1, byte[] var3, int var4, short var5, boolean var6, Long var7, Long var8, long var9);

        @Override
        @NotNull
        public synchronized List<SendStatus> sendMany(@NotNull @NotNull List<@NotNull DcSctpMessage> messages, @NotNull SendOptions options) {
            int[] nativeStatuses = this.sendMany_(this.ptr, messages.toArray(new DcSctpMessage[0]), options);
            return Arrays.stream(nativeStatuses).mapToObj(SendStatus::fromNativeStatus).collect(Collectors.toList());
        }

        private native int[] sendMany_(long var1, DcSctpMessage[] var3, SendOptions var4);

        private short[] unboxList(List<Short> l) {
            short[] ret = new short[l.size()];
            int idx = 0;
            for (short s : l) {
                ret[idx++] = s;
            }
            return ret;
        }

        @Override
        @NotNull
        public synchronized ResetStreamsStatus resetStreams(@NotNull List<Short> outgoingStreams) {
            return this.resetStreams_(this.ptr, this.unboxList(outgoingStreams));
        }

        private native ResetStreamsStatus resetStreams_(long var1, short[] var3);

        @Override
        public synchronized long bufferedAmount(short streamId) {
            return this.bufferedAmount_(this.ptr, streamId);
        }

        private native long bufferedAmount_(long var1, short var3);

        @Override
        public synchronized long bufferedAmountLowThreshold(short streamId) {
            return this.bufferedAmountLowThreshold_(this.ptr, streamId);
        }

        private native long bufferedAmountLowThreshold_(long var1, short var3);

        @Override
        public synchronized void setBufferedAmountLowThreshold(short streamId, long bytes) {
            this.setBufferedAmountLowThreshold_(this.ptr, streamId, bytes);
        }

        private native void setBufferedAmountLowThreshold_(long var1, short var3, long var4);

        @Override
        @Nullable
        public synchronized Metrics getMetrics() {
            return this.getMetrics_(this.ptr);
        }

        private native Metrics getMetrics_(long var1);
    }
}

