/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sctp;

import io.pkts.buffer.Buffer;
import io.pkts.packet.sctp.impl.DefaultSctpChunk;
import io.pkts.packet.sctp.impl.SctpDataChunkImpl;

public interface SctpChunk {
    public static SctpChunk frame(Buffer buffer) {
        DefaultSctpChunk chunk = DefaultSctpChunk.frame(buffer);
        switch (chunk.getType()) {
            case DATA: {
                return SctpDataChunkImpl.of(chunk);
            }
        }
        return chunk;
    }

    public Type getType();

    public int getLength();

    public Buffer getHeader();

    public Buffer getValue();

    public int getPadding();

    public byte getFlags();

    public int getValueLength();

    public static Type lookup(short type) {
        switch (type) {
            case 0: {
                return Type.DATA;
            }
            case 1: {
                return Type.INIT;
            }
            case 2: {
                return Type.INIT_ACK;
            }
            case 3: {
                return Type.SACK;
            }
            case 4: {
                return Type.HEARTBEAT;
            }
            case 5: {
                return Type.HEARTBEAT_ACK;
            }
            case 6: {
                return Type.ABORT;
            }
            case 7: {
                return Type.SHUTDOWN;
            }
            case 8: {
                return Type.SHUTDOWN_ACK;
            }
            case 9: {
                return Type.ERROR;
            }
            case 10: {
                return Type.COOKIE_ECHO;
            }
            case 11: {
                return Type.COOKIE_ACK;
            }
            case 12: {
                return Type.ECNE;
            }
            case 13: {
                return Type.CWR;
            }
            case 14: {
                return Type.SHUTDOWN_COMPLETE;
            }
            case 15: {
                return Type.AUTH;
            }
            case 64: {
                return Type.I_DATA;
            }
            case 128: {
                return Type.ASCONF_ACK;
            }
            case 130: {
                return Type.RE_CONFIG;
            }
            case 132: {
                return Type.PAD;
            }
            case 192: {
                return Type.FORWARD_TSN;
            }
            case 193: {
                return Type.ASCONF;
            }
            case 194: {
                return Type.I_FORWARD_TSN;
            }
        }
        return null;
    }

    public static enum Type {
        DATA(0, "Payload data"),
        INIT(1, "Initiation"),
        INIT_ACK(2, "Initiation Acknowledgement"),
        SACK(3, "Selective Acknowledgement"),
        HEARTBEAT(4, "Heartbeat Request"),
        HEARTBEAT_ACK(5, "Heartbeat Acknowledgement"),
        ABORT(6, "Abort"),
        SHUTDOWN(7, "Shutdown"),
        SHUTDOWN_ACK(8, "Shutdown Acknowledgement"),
        ERROR(9, "Operation Error"),
        COOKIE_ECHO(10, "State Cookie"),
        COOKIE_ACK(11, "State Acknowledgement"),
        ECNE(12, "Explicit Congestion Notification Echo (reserved)"),
        CWR(13, "Congestion Window Reduced  (reserved)"),
        SHUTDOWN_COMPLETE(14, "Shutdown Complete"),
        AUTH(15, "Authentication"),
        I_DATA(64, "Payload data supporting packet interleaving"),
        ASCONF_ACK(128, "Address configuration change acknowledgement"),
        RE_CONFIG(130, "Stream reconfiguration"),
        PAD(132, "Packet Padding"),
        FORWARD_TSN(192, "Increment expected TSN"),
        ASCONF(193, "Address configuration change"),
        I_FORWARD_TSN(194, "Increment expected TSN, supporting packet interleaving");

        private final short type;
        private final String description;

        private Type(short type, String description) {
            this.type = type;
            this.description = description;
        }

        public short getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

