/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.framer.SctpFramer;
import io.pkts.framer.TCPFramer;
import io.pkts.framer.UDPFramer;
import io.pkts.packet.IPv4Packet;
import io.pkts.packet.Packet;
import io.pkts.packet.PacketParseException;
import io.pkts.packet.impl.AbstractPacket;
import io.pkts.protocol.Protocol;
import java.io.IOException;
import java.io.OutputStream;

public final class IPv4PacketImpl
extends AbstractPacket
implements IPv4Packet {
    private static final UDPFramer udpFramer = new UDPFramer();
    private static final TCPFramer tcpFramer = new TCPFramer();
    private static final SctpFramer sctpFramer = new SctpFramer();
    private final Packet parent;
    private final Buffer headers;
    private final int options;

    public IPv4PacketImpl(Packet parent, Buffer headers, int options, Buffer payload) {
        super(Protocol.IPv4, parent, payload);
        assert (parent != null);
        assert (headers != null);
        this.parent = parent;
        this.headers = headers;
        this.options = options;
    }

    @Override
    public int getIpChecksum() {
        return this.headers.getUnsignedShort(10);
    }

    private int calculateChecksum() {
        long sum = 0L;
        for (int i = 0; i < this.headers.capacity() - 1; i += 2) {
            if (i == 10) continue;
            sum += (long)this.headers.getUnsignedShort(i);
        }
        while (sum >> 16 != 0L) {
            sum = (sum & 0xFFFFL) + (sum >> 16);
        }
        return (int)(sum ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFF;
    }

    @Override
    public byte[] getRawSourceIP() {
        Buffer tmp = Buffers.createBuffer((int)4);
        this.headers.getBytes(12, tmp);
        return tmp.getArray();
    }

    public int getRawSourceIpInt() {
        return this.headers.getInt(12);
    }

    @Override
    public String getSourceIP() {
        short a = this.headers.getUnsignedByte(12);
        short b = this.headers.getUnsignedByte(13);
        short c = this.headers.getUnsignedByte(14);
        short d = this.headers.getUnsignedByte(15);
        return a + "." + b + "." + c + "." + d;
    }

    @Override
    public byte[] getRawDestinationIP() {
        Buffer tmp = Buffers.createBuffer((int)4);
        this.headers.getBytes(16, tmp);
        return tmp.getArray();
    }

    public int getRawDestinationIpInt() {
        return this.headers.getInt(16);
    }

    @Override
    public String getDestinationIP() {
        short a = this.headers.getUnsignedByte(16);
        short b = this.headers.getUnsignedByte(17);
        short c = this.headers.getUnsignedByte(18);
        short d = this.headers.getUnsignedByte(19);
        return a + "." + b + "." + c + "." + d;
    }

    @Override
    public void verify() {
    }

    @Override
    public long getArrivalTime() {
        return this.parent.getArrivalTime();
    }

    @Override
    public void write(OutputStream out, Buffer payload) throws IOException {
        int size = this.headers.getReadableBytes() + (payload != null ? payload.getReadableBytes() : 0);
        this.setTotalLength(size);
        this.reCalculateChecksum();
        Buffer pkt = Buffers.wrap((Buffer)this.headers, (Buffer)payload);
        this.parent.write(out, pkt);
    }

    @Override
    public int getTotalIPLength() {
        return this.headers.getUnsignedShort(2);
    }

    public void setTotalLength(int length) {
        this.headers.setUnsignedShort(2, length);
    }

    @Override
    public void setSourceIP(int a, int b, int c, int d) {
        this.headers.setByte(12, (byte)a);
        this.headers.setByte(13, (byte)b);
        this.headers.setByte(14, (byte)c);
        this.headers.setByte(15, (byte)d);
        this.reCalculateChecksum();
    }

    @Override
    public void setSourceIP(byte a, byte b, byte c, byte d) {
        this.headers.setByte(12, a);
        this.headers.setByte(13, b);
        this.headers.setByte(14, c);
        this.headers.setByte(15, d);
    }

    @Override
    public void setDestinationIP(int a, int b, int c, int d) {
        this.headers.setByte(16, (byte)a);
        this.headers.setByte(17, (byte)b);
        this.headers.setByte(18, (byte)c);
        this.headers.setByte(19, (byte)d);
        this.reCalculateChecksum();
    }

    @Override
    public void setDestinationIP(byte a, byte b, byte c, byte d) {
        this.headers.setByte(16, a);
        this.headers.setByte(17, b);
        this.headers.setByte(18, c);
        this.headers.setByte(19, d);
    }

    @Override
    public void setSourceIP(String sourceIp) {
        this.setIP(12, sourceIp);
    }

    @Override
    public void setDestinationIP(String destinationIP) {
        this.setIP(16, destinationIP);
    }

    private void setIP(int startIndex, String address) {
        String[] parts = address.split("\\.");
        this.headers.setByte(startIndex + 0, (byte)Integer.parseInt(parts[0]));
        this.headers.setByte(startIndex + 1, (byte)Integer.parseInt(parts[1]));
        this.headers.setByte(startIndex + 2, (byte)Integer.parseInt(parts[2]));
        this.headers.setByte(startIndex + 3, (byte)Integer.parseInt(parts[3]));
        this.reCalculateChecksum();
    }

    @Override
    public void reCalculateChecksum() {
        int checksum = this.calculateChecksum();
        this.headers.setUnsignedShort(10, checksum);
    }

    @Override
    public boolean verifyIpChecksum() {
        return this.calculateChecksum() == this.getIpChecksum();
    }

    @Override
    public IPv4Packet clone() {
        Packet parent = this.parent.clone();
        IPv4PacketImpl pkt = new IPv4PacketImpl(parent, this.headers.clone(), this.options, this.getPayload().clone());
        return pkt;
    }

    @Override
    public Packet getNextPacket() throws IOException {
        Buffer payload = this.getPayload();
        if (payload == null) {
            return null;
        }
        byte code = this.headers.getByte(9);
        Protocol protocol = Protocol.valueOf(code);
        if (protocol != null) {
            switch (protocol) {
                case UDP: {
                    return udpFramer.frame(this, payload);
                }
                case TCP: {
                    return tcpFramer.frame(this, payload);
                }
                case SCTP: {
                    return sctpFramer.frame(this, payload);
                }
            }
            throw new PacketParseException(9, String.format("Unsupported inner protocol %s for IPv4", protocol.getName()));
        }
        throw new PacketParseException(9, String.format("Unknown protocol %d inside IPv4 packet", code));
    }

    @Override
    public int getVersion() {
        return 4;
    }

    @Override
    public int getHeaderLength() {
        try {
            byte b = this.headers.getByte(0);
            return (b & 0xF) * 4;
        }
        catch (IOException e) {
            throw new RuntimeException("unable to get the header length of the IP packet due to IOException", e);
        }
    }

    @Override
    public boolean isFragmented() {
        return this.isMoreFragmentsSet() || this.getFragmentOffset() > 0;
    }

    @Override
    public boolean isReservedFlagSet() {
        try {
            byte b = this.headers.getByte(6);
            return (b & 0x80) == 128;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isDontFragmentSet() {
        try {
            byte b = this.headers.getByte(6);
            return (b & 0x40) == 64;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isMoreFragmentsSet() {
        try {
            byte b = this.headers.getByte(6);
            return (b & 0x20) == 32;
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    @Override
    public short getFragmentOffset() {
        try {
            byte a = this.headers.getByte(6);
            byte b = this.headers.getByte(7);
            return (short)((a & 0x1F) << 8 | b & 0xFF);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public short getDSCP() {
        try {
            byte a = this.headers.getByte(1);
            return (short)(a >> 2 & 0x3F);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public short getECN() {
        try {
            byte a = this.headers.getByte(1);
            return (short)(a & 3);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getTimeToLive() {
        return this.headers.getUnsignedByte(8);
    }

    @Override
    public int getIdentification() {
        return this.headers.getUnsignedShort(4);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IPv4 ");
        sb.append(" Total Length: ").append(this.getTotalIPLength()).append(" ID: ").append(this.getIdentification()).append(" DF: ").append(this.isDontFragmentSet() ? "Set" : "Not Set").append(" MF: ").append(this.isMoreFragmentsSet() ? "Set" : "Not Set").append(" Fragment Offset: ").append(this.getFragmentOffset());
        return sb.toString();
    }
}

