/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.framer;

import io.pkts.buffer.Buffer;
import io.pkts.framer.EthernetFramer;
import io.pkts.framer.Framer;
import io.pkts.packet.MACPacket;
import io.pkts.packet.PCapPacket;
import io.pkts.packet.impl.MACPacketImpl;
import io.pkts.protocol.Protocol;
import java.io.IOException;

public class SllFramer
implements Framer<PCapPacket, MACPacket> {
    private static final byte LINUX_SLL_HOST = 0;
    private static final byte LINUX_SLL_BROADCAST = 1;
    private static final byte LINUX_SLL_MULTICAST = 2;
    private static final byte LINUX_SLL_OTHERHOST = 3;
    private static final byte LINUX_SLL_OUTGOING = 4;
    private static final byte LINUX_SLL_P_802_3 = 1;
    private static final byte LINUX_SLL_P_802_2 = 4;

    @Override
    public Protocol getProtocol() {
        return Protocol.SLL;
    }

    @Override
    public MACPacket frame(PCapPacket parent, Buffer buffer) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("The parent frame cannot be null");
        }
        Buffer headers = buffer.readBytes(16);
        Buffer payload = buffer.slice(buffer.capacity());
        return new MACPacketImpl(Protocol.SLL, parent, headers, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(Buffer buffer) throws IOException {
        buffer.markReaderIndex();
        try {
            Buffer test = buffer.readBytes(16);
            byte b1 = test.getByte(0);
            byte b2 = test.getByte(1);
            byte b14 = test.getByte(14);
            byte b15 = test.getByte(15);
            boolean bl = this.validatePacketType(b1, b2) && this.isKnownEtherType(b14, b15);
            return bl;
        }
        catch (IndexOutOfBoundsException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            buffer.resetReaderIndex();
        }
    }

    private boolean isKnownEtherType(byte b1, byte b2) {
        return EthernetFramer.getEtherTypeSafe(b1, b2) != null;
    }

    private boolean validatePacketType(byte b1, byte b2) {
        if (b1 != 0) {
            return false;
        }
        return b2 == 0 || b2 == 1 || b2 == 2 || b2 == 3 || b2 == 4;
    }
}

