/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0002H\u0002JB\u0010\u0013\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u0012H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirRedundantLabelChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lcom/intellij/psi/PsiElement;", "()V", "checkLightTree", "", "element", "source", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkPsi", "Lorg/jetbrains/kotlin/KtPsiSourceElement;", "psi", "isRootLabelContainer", "", "reportRedundantLabels", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/lang/LighterASTNode;", "allTraversalRoots", "", "Lorg/jetbrains/kotlin/KtSourceElement;", "isChildNode", "checkers"})
public final class FirRedundantLabelChecker
extends FirDeclarationSyntaxChecker<FirDeclaration, PsiElement> {
    @NotNull
    public static final FirRedundantLabelChecker INSTANCE = new FirRedundantLabelChecker();

    private FirRedundantLabelChecker() {
    }

    @Override
    public void checkLightTree(@NotNull FirDeclaration element, @NotNull KtLightSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!this.isRootLabelContainer(element)) {
            return;
        }
        Set allTraversalRoots = new LinkedHashSet();
        element.accept(new FirVisitorVoid(allTraversalRoots){
            final /* synthetic */ Set<KtSourceElement> $allTraversalRoots;
            {
                this.$allTraversalRoots = $allTraversalRoots;
            }

            public void visitElement(@NotNull FirElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                element.acceptChildren(this);
            }

            public void visitBlock(@NotNull FirBlock block) {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                this.markTraversalRoot(block);
                super.visitBlock(block);
            }

            public void visitProperty(@NotNull FirProperty property2) {
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                this.markTraversalRoot(property2);
                super.visitProperty(property2);
            }

            public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction) {
                Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
                this.markTraversalRoot(simpleFunction);
                super.visitFunction(simpleFunction);
            }

            public void visitPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor) {
                Intrinsics.checkNotNullParameter((Object)propertyAccessor, (String)"propertyAccessor");
                this.markTraversalRoot(propertyAccessor);
                super.visitPropertyAccessor(propertyAccessor);
            }

            public void visitConstructor(@NotNull FirConstructor constructor2) {
                Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
                this.markTraversalRoot(constructor2);
                super.visitConstructor(constructor2);
            }

            private final void markTraversalRoot(FirElement elem) {
                KtSourceElement elemSource;
                KtSourceElement ktSourceElement = elemSource = elem.getSource();
                if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind) {
                    this.$allTraversalRoots.add(elemSource);
                }
            }
        });
        for (KtSourceElement root2 : allTraversalRoots) {
            FirRedundantLabelChecker.reportRedundantLabels$default(this, root2.getTreeStructure(), reporter, context2, (KtLightSourceElement)root2, allTraversalRoots, false, 16, null);
        }
    }

    private final void reportRedundantLabels(FlyweightCapableTreeStructure<LighterASTNode> $this$reportRedundantLabels, DiagnosticReporter reporter, CheckerContext context2, KtLightSourceElement source, Set<? extends KtSourceElement> allTraversalRoots, boolean isChildNode) {
        if (isChildNode && allTraversalRoots.contains(source)) {
            return;
        }
        LighterASTNode node = source.getLighterASTNode();
        if (Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.LABELED_EXPRESSION)) {
            IElementType iElementType = KtNodeTypes.LABEL_QUALIFIER;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"LABEL_QUALIFIER");
            LighterASTNode labelQualifier = LightTreePositioningStrategiesKt.findChildByType($this$reportRedundantLabels, node, iElementType);
            if (labelQualifier != null) {
                IElementType iElementType2 = KtNodeTypes.LABEL;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"LABEL");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.findChildByType($this$reportRedundantLabels, labelQualifier, iElementType2);
                if (lighterASTNode2 != null) {
                    LighterASTNode labelNode = lighterASTNode2;
                    boolean bl = false;
                    IElementType iElementType3 = LightTreePositioningStrategiesKt.unwrapParenthesesLabelsAndAnnotations($this$reportRedundantLabels, node).getTokenType();
                    if (!((((Intrinsics.areEqual((Object)iElementType3, (Object)KtNodeTypes.LAMBDA_EXPRESSION) ? true : Intrinsics.areEqual((Object)iElementType3, (Object)KtNodeTypes.FOR)) ? true : Intrinsics.areEqual((Object)iElementType3, (Object)KtNodeTypes.WHILE)) ? true : Intrinsics.areEqual((Object)iElementType3, (Object)KtNodeTypes.DO_WHILE)) ? true : Intrinsics.areEqual((Object)iElementType3, (Object)KtNodeTypes.FUN))) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)FirSourceUtilsKt.buildChildSourceElement(source, labelNode), FirErrors.INSTANCE.getREDUNDANT_LABEL_WARNING(), (DiagnosticContext)context2, null, 8, null);
                    }
                }
            }
        }
        Ref<Object> childrenRef = Ref.create(null);
        $this$reportRedundantLabels.getChildren(node, childrenRef);
        LighterASTNode[] lighterASTNodeArray = childrenRef.get();
        if (lighterASTNodeArray == null) {
            return;
        }
        for (LighterASTNode child : lighterASTNodeArray) {
            if (child == null) continue;
            this.reportRedundantLabels($this$reportRedundantLabels, reporter, context2, FirSourceUtilsKt.buildChildSourceElement(source, child), allTraversalRoots, true);
        }
    }

    static /* synthetic */ void reportRedundantLabels$default(FirRedundantLabelChecker firRedundantLabelChecker, FlyweightCapableTreeStructure flyweightCapableTreeStructure, DiagnosticReporter diagnosticReporter, CheckerContext checkerContext, KtLightSourceElement ktLightSourceElement, Set set, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        firRedundantLabelChecker.reportRedundantLabels(flyweightCapableTreeStructure, diagnosticReporter, checkerContext, ktLightSourceElement, set, bl);
    }

    @Override
    public void checkPsi(@NotNull FirDeclaration element, @NotNull KtPsiSourceElement source, @NotNull PsiElement psi, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!this.isRootLabelContainer(element)) {
            return;
        }
        source.getPsi().accept(new KtTreeVisitorVoid(reporter, context2){
            final /* synthetic */ DiagnosticReporter $reporter;
            final /* synthetic */ CheckerContext $context;
            {
                this.$reporter = $reporter;
                this.$context = $context;
            }

            public void visitLabeledExpression(@NotNull KtLabeledExpression expression2) {
                KtExpression deparenthesizedBaseExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                KtSimpleNameExpression labelNameExpression = expression2.getTargetLabel();
                if (!(labelNameExpression == null || (deparenthesizedBaseExpression = KtPsiUtil.deparenthesize(expression2)) instanceof KtLambdaExpression || deparenthesizedBaseExpression instanceof KtLoopExpression || deparenthesizedBaseExpression instanceof KtNamedFunction)) {
                    KtPsiSourceElement ktPsiSourceElement;
                    PsiElement $this$toKtPsiSourceElement_u24default$iv = labelNameExpression;
                    KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
                    boolean $i$f$toKtPsiSourceElement = false;
                    KtSourceElementKind ktSourceElementKind = kind$iv;
                    if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                        ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv);
                    } else if (ktSourceElementKind instanceof KtFakeSourceElementKind) {
                        ktPsiSourceElement = new KtFakeSourceElement($this$toKtPsiSourceElement_u24default$iv, (KtFakeSourceElementKind)kind$iv);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default(this.$reporter, (AbstractKtSourceElement)ktPsiSourceElement, FirErrors.INSTANCE.getREDUNDANT_LABEL_WARNING(), (DiagnosticContext)this.$context, null, 8, null);
                }
                super.visitLabeledExpression(expression2);
            }
        });
    }

    private final boolean isRootLabelContainer(FirDeclaration element) {
        boolean bl;
        FirDeclaration firDeclaration;
        KtSourceElement ktSourceElement = element.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return false;
        }
        if (element instanceof FirCallableDeclaration) {
            FirMemberDeclaration $this$effectiveVisibility$iv = (FirMemberDeclaration)element;
            boolean $i$f$getEffectiveVisibility = false;
            FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
            Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
            if (object == null || (object = object.getEffectiveVisibility()) == null) {
                object = EffectiveVisibility.Local.INSTANCE;
            }
            if (Intrinsics.areEqual((Object)object, (Object)EffectiveVisibility.Local.INSTANCE)) {
                return false;
            }
        }
        if ((firDeclaration = element) instanceof FirAnonymousFunction) {
            bl = false;
        } else if (firDeclaration instanceof FirFunction) {
            bl = true;
        } else if (firDeclaration instanceof FirProperty) {
            bl = true;
        } else if (firDeclaration instanceof FirAnonymousInitializer) {
            EffectiveVisibility parentVisibility;
            EffectiveVisibility effectiveVisibility;
            FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol(element, element.getModuleData().getSession());
            FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
            if (firRegularClassSymbol != null) {
                FirClassSymbol $this$effectiveVisibility$iv = firRegularClassSymbol;
                boolean $i$f$getEffectiveVisibility = false;
                effectiveVisibility = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
            } else {
                effectiveVisibility = parentVisibility = null;
            }
            bl = parentVisibility != null && !Intrinsics.areEqual((Object)parentVisibility, (Object)EffectiveVisibility.Local.INSTANCE);
        } else {
            bl = false;
        }
        return bl;
    }
}

