#!/bin/sh
#
#
# Installation script for the 3d_pixmaps
# Joerg Mertin <smurphy@stargate.bln.sub.org>
#
#
#
DEST_DIR=/usr/X11R6/include/X11/3dpixmaps
RC_DIR=/etc/X11/fvwm2
INSTALL=/usr/bin/install
AUDIO_DIR=/usr/X11R6/lib/X11/fvwm2/audio
BASE_DIR=`pwd`
#
# lets define some little functions...
#
pixmaps() {
echo -n "--- Installing Pixmaps in $DEST_DIR: "
#
for i in $BASE_DIR/3dpixmaps/*.xpm
 do
  echo -n "."
  $INSTALL -g users -m 444 $i $DEST_DIR
 done
echo
for i in $BASE_DIR/menubar_xpm/*.xpm
 do
  echo -n "."
  $INSTALL -g users -m 444 $i $DEST_DIR
 done
echo
}

configs() {
echo -n "--- Installing sample config files in $RC_DIR: "
#
for i in $BASE_DIR/configs/*
 do
  echo -n "."
  $INSTALL -g users -m 644 $i $RC_DIR
 done
echo
}
#
# File list + Locations
filelist() {
if [ -f file_list ]
  then
    echo -n "--- Removing old File list: "
    rm -fv file_list
fi
#
touch file_list
echo -n "--- Creating filelist:"
for i in  $BASE_DIR/3dpixmaps/*.xpm
 do
  echo "$DEST_DIR/`basename $i`" >> file_list
  echo -n "."
 done
for i in  $BASE_DIR/menubar_xpm/*.xpm
 do
  echo "$DEST_DIR/`basename $i`" >> file_list
  echo -n "."
 done
echo >> file_list
for i in  $BASE_DIR/configs/*
 do
  echo "%config $RC_DIR/`basename $i`" >> file_list
  echo -n "."
 done
echo >> file_list
for i in audio/*
 do
  echo "$AUDIO_DIR/`basename $i`" >> file_list
  echo -n "."
 done
echo >> file_list
for i in bin/*
 do
  echo "/usr/local/bin/`basename $i`" >> file_list
  echo -n "."
 done
echo >> file_list
# Adding the Documentation files
  echo -n "."
  echo "%doc README" >> file_list
  echo -n "."
  echo "%doc 3d_pixmaps_1.2.lsm" >> file_list
echo "done"
}
#
# Lets go for some real work :)
FLAG=$1
WANTED=-f
#
if [ ! -z $FLAG ] && [ $FLAG = $WANTED ]
  then 
    filelist
  else
  if [ -z $FLAG ]
  then
  # Config Files
    $INSTALL -m 0755 -d $RC_DIR
    configs
    # pixmaps
    $INSTALL -m 0755 -d $DEST_DIR
    pixmaps
    # Audio Tools
    $INSTALL -m 0755 -d $AUDIO_DIR
    $INSTALL -g users -m 444 ./audio/* $AUDIO_DIR
    # Binary Samples, eg. some shellscripts
    $INSTALL -m 0755 -d /usr/local/bin
    $INSTALL -g users -m 755 ./bin/* /usr/local/bin
    echo "--- All done. Enjoy..."
  else
    echo "*** Wrong argument"
  fi
fi
