// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package datalabeling aliases all exported identifiers in package
// "cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb".
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package datalabeling

import (
	src "cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
const (
	AnnotationSentiment_ANNOTATION_SENTIMENT_UNSPECIFIED      = src.AnnotationSentiment_ANNOTATION_SENTIMENT_UNSPECIFIED
	AnnotationSentiment_NEGATIVE                              = src.AnnotationSentiment_NEGATIVE
	AnnotationSentiment_POSITIVE                              = src.AnnotationSentiment_POSITIVE
	AnnotationSource_ANNOTATION_SOURCE_UNSPECIFIED            = src.AnnotationSource_ANNOTATION_SOURCE_UNSPECIFIED
	AnnotationSource_OPERATOR                                 = src.AnnotationSource_OPERATOR
	AnnotationType_ANNOTATION_TYPE_UNSPECIFIED                = src.AnnotationType_ANNOTATION_TYPE_UNSPECIFIED
	AnnotationType_GENERAL_CLASSIFICATION_ANNOTATION          = src.AnnotationType_GENERAL_CLASSIFICATION_ANNOTATION
	AnnotationType_IMAGE_BOUNDING_BOX_ANNOTATION              = src.AnnotationType_IMAGE_BOUNDING_BOX_ANNOTATION
	AnnotationType_IMAGE_BOUNDING_POLY_ANNOTATION             = src.AnnotationType_IMAGE_BOUNDING_POLY_ANNOTATION
	AnnotationType_IMAGE_CLASSIFICATION_ANNOTATION            = src.AnnotationType_IMAGE_CLASSIFICATION_ANNOTATION
	AnnotationType_IMAGE_ORIENTED_BOUNDING_BOX_ANNOTATION     = src.AnnotationType_IMAGE_ORIENTED_BOUNDING_BOX_ANNOTATION
	AnnotationType_IMAGE_POLYLINE_ANNOTATION                  = src.AnnotationType_IMAGE_POLYLINE_ANNOTATION
	AnnotationType_IMAGE_SEGMENTATION_ANNOTATION              = src.AnnotationType_IMAGE_SEGMENTATION_ANNOTATION
	AnnotationType_TEXT_CLASSIFICATION_ANNOTATION             = src.AnnotationType_TEXT_CLASSIFICATION_ANNOTATION
	AnnotationType_TEXT_ENTITY_EXTRACTION_ANNOTATION          = src.AnnotationType_TEXT_ENTITY_EXTRACTION_ANNOTATION
	AnnotationType_VIDEO_EVENT_ANNOTATION                     = src.AnnotationType_VIDEO_EVENT_ANNOTATION
	AnnotationType_VIDEO_OBJECT_DETECTION_ANNOTATION          = src.AnnotationType_VIDEO_OBJECT_DETECTION_ANNOTATION
	AnnotationType_VIDEO_OBJECT_TRACKING_ANNOTATION           = src.AnnotationType_VIDEO_OBJECT_TRACKING_ANNOTATION
	AnnotationType_VIDEO_SHOTS_CLASSIFICATION_ANNOTATION      = src.AnnotationType_VIDEO_SHOTS_CLASSIFICATION_ANNOTATION
	DataType_DATA_TYPE_UNSPECIFIED                            = src.DataType_DATA_TYPE_UNSPECIFIED
	DataType_GENERAL_DATA                                     = src.DataType_GENERAL_DATA
	DataType_IMAGE                                            = src.DataType_IMAGE
	DataType_TEXT                                             = src.DataType_TEXT
	DataType_VIDEO                                            = src.DataType_VIDEO
	EvaluationJob_PAUSED                                      = src.EvaluationJob_PAUSED
	EvaluationJob_RUNNING                                     = src.EvaluationJob_RUNNING
	EvaluationJob_SCHEDULED                                   = src.EvaluationJob_SCHEDULED
	EvaluationJob_STATE_UNSPECIFIED                           = src.EvaluationJob_STATE_UNSPECIFIED
	EvaluationJob_STOPPED                                     = src.EvaluationJob_STOPPED
	LabelImageRequest_BOUNDING_BOX                            = src.LabelImageRequest_BOUNDING_BOX
	LabelImageRequest_BOUNDING_POLY                           = src.LabelImageRequest_BOUNDING_POLY
	LabelImageRequest_CLASSIFICATION                          = src.LabelImageRequest_CLASSIFICATION
	LabelImageRequest_FEATURE_UNSPECIFIED                     = src.LabelImageRequest_FEATURE_UNSPECIFIED
	LabelImageRequest_ORIENTED_BOUNDING_BOX                   = src.LabelImageRequest_ORIENTED_BOUNDING_BOX
	LabelImageRequest_POLYLINE                                = src.LabelImageRequest_POLYLINE
	LabelImageRequest_SEGMENTATION                            = src.LabelImageRequest_SEGMENTATION
	LabelTextRequest_FEATURE_UNSPECIFIED                      = src.LabelTextRequest_FEATURE_UNSPECIFIED
	LabelTextRequest_TEXT_CLASSIFICATION                      = src.LabelTextRequest_TEXT_CLASSIFICATION
	LabelTextRequest_TEXT_ENTITY_EXTRACTION                   = src.LabelTextRequest_TEXT_ENTITY_EXTRACTION
	LabelVideoRequest_CLASSIFICATION                          = src.LabelVideoRequest_CLASSIFICATION
	LabelVideoRequest_EVENT                                   = src.LabelVideoRequest_EVENT
	LabelVideoRequest_FEATURE_UNSPECIFIED                     = src.LabelVideoRequest_FEATURE_UNSPECIFIED
	LabelVideoRequest_OBJECT_DETECTION                        = src.LabelVideoRequest_OBJECT_DETECTION
	LabelVideoRequest_OBJECT_TRACKING                         = src.LabelVideoRequest_OBJECT_TRACKING
	StringAggregationType_MAJORITY_VOTE                       = src.StringAggregationType_MAJORITY_VOTE
	StringAggregationType_NO_AGGREGATION                      = src.StringAggregationType_NO_AGGREGATION
	StringAggregationType_STRING_AGGREGATION_TYPE_UNSPECIFIED = src.StringAggregationType_STRING_AGGREGATION_TYPE_UNSPECIFIED
	StringAggregationType_UNANIMOUS_VOTE                      = src.StringAggregationType_UNANIMOUS_VOTE
)

// Deprecated: Please use vars in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
var (
	AnnotationSentiment_name                                             = src.AnnotationSentiment_name
	AnnotationSentiment_value                                            = src.AnnotationSentiment_value
	AnnotationSource_name                                                = src.AnnotationSource_name
	AnnotationSource_value                                               = src.AnnotationSource_value
	AnnotationType_name                                                  = src.AnnotationType_name
	AnnotationType_value                                                 = src.AnnotationType_value
	DataType_name                                                        = src.DataType_name
	DataType_value                                                       = src.DataType_value
	EvaluationJob_State_name                                             = src.EvaluationJob_State_name
	EvaluationJob_State_value                                            = src.EvaluationJob_State_value
	File_google_cloud_datalabeling_v1beta1_annotation_proto              = src.File_google_cloud_datalabeling_v1beta1_annotation_proto
	File_google_cloud_datalabeling_v1beta1_annotation_spec_set_proto     = src.File_google_cloud_datalabeling_v1beta1_annotation_spec_set_proto
	File_google_cloud_datalabeling_v1beta1_data_labeling_service_proto   = src.File_google_cloud_datalabeling_v1beta1_data_labeling_service_proto
	File_google_cloud_datalabeling_v1beta1_data_payloads_proto           = src.File_google_cloud_datalabeling_v1beta1_data_payloads_proto
	File_google_cloud_datalabeling_v1beta1_dataset_proto                 = src.File_google_cloud_datalabeling_v1beta1_dataset_proto
	File_google_cloud_datalabeling_v1beta1_evaluation_job_proto          = src.File_google_cloud_datalabeling_v1beta1_evaluation_job_proto
	File_google_cloud_datalabeling_v1beta1_evaluation_proto              = src.File_google_cloud_datalabeling_v1beta1_evaluation_proto
	File_google_cloud_datalabeling_v1beta1_human_annotation_config_proto = src.File_google_cloud_datalabeling_v1beta1_human_annotation_config_proto
	File_google_cloud_datalabeling_v1beta1_instruction_proto             = src.File_google_cloud_datalabeling_v1beta1_instruction_proto
	File_google_cloud_datalabeling_v1beta1_operations_proto              = src.File_google_cloud_datalabeling_v1beta1_operations_proto
	LabelImageRequest_Feature_name                                       = src.LabelImageRequest_Feature_name
	LabelImageRequest_Feature_value                                      = src.LabelImageRequest_Feature_value
	LabelTextRequest_Feature_name                                        = src.LabelTextRequest_Feature_name
	LabelTextRequest_Feature_value                                       = src.LabelTextRequest_Feature_value
	LabelVideoRequest_Feature_name                                       = src.LabelVideoRequest_Feature_name
	LabelVideoRequest_Feature_value                                      = src.LabelVideoRequest_Feature_value
	StringAggregationType_name                                           = src.StringAggregationType_name
	StringAggregationType_value                                          = src.StringAggregationType_value
)

// AnnotatedDataset is a set holding annotations for data in a Dataset. Each
// labeling task will generate an AnnotatedDataset under the Dataset that the
// task is requested for.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type AnnotatedDataset = src.AnnotatedDataset

// Metadata on AnnotatedDataset.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type AnnotatedDatasetMetadata = src.AnnotatedDatasetMetadata
type AnnotatedDatasetMetadata_BoundingPolyConfig = src.AnnotatedDatasetMetadata_BoundingPolyConfig
type AnnotatedDatasetMetadata_EventConfig = src.AnnotatedDatasetMetadata_EventConfig
type AnnotatedDatasetMetadata_ImageClassificationConfig = src.AnnotatedDatasetMetadata_ImageClassificationConfig
type AnnotatedDatasetMetadata_ObjectDetectionConfig = src.AnnotatedDatasetMetadata_ObjectDetectionConfig
type AnnotatedDatasetMetadata_ObjectTrackingConfig = src.AnnotatedDatasetMetadata_ObjectTrackingConfig
type AnnotatedDatasetMetadata_PolylineConfig = src.AnnotatedDatasetMetadata_PolylineConfig
type AnnotatedDatasetMetadata_SegmentationConfig = src.AnnotatedDatasetMetadata_SegmentationConfig
type AnnotatedDatasetMetadata_TextClassificationConfig = src.AnnotatedDatasetMetadata_TextClassificationConfig
type AnnotatedDatasetMetadata_TextEntityExtractionConfig = src.AnnotatedDatasetMetadata_TextEntityExtractionConfig
type AnnotatedDatasetMetadata_VideoClassificationConfig = src.AnnotatedDatasetMetadata_VideoClassificationConfig

// Annotation for Example. Each example may have one or more annotations. For
// example in image classification problem, each image might have one or more
// labels. We call labels binded with this image an Annotation.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type Annotation = src.Annotation

// Additional information associated with the annotation.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type AnnotationMetadata = src.AnnotationMetadata
type AnnotationSentiment = src.AnnotationSentiment

// Specifies where the annotation comes from (whether it was provided by a
// human labeler or a different source).
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type AnnotationSource = src.AnnotationSource

// Container of information related to one possible annotation that can be
// used in a labeling task. For example, an image classification task where
// images are labeled as `dog` or `cat` must reference an AnnotationSpec for
// `dog` and an AnnotationSpec for `cat`.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type AnnotationSpec = src.AnnotationSpec

// An AnnotationSpecSet is a collection of label definitions. For example, in
// image classification tasks, you define a set of possible labels for images
// as an AnnotationSpecSet. An AnnotationSpecSet is immutable upon creation.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type AnnotationSpecSet = src.AnnotationSpecSet
type AnnotationType = src.AnnotationType

// Annotation value for an example.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type AnnotationValue = src.AnnotationValue
type AnnotationValue_ImageBoundingPolyAnnotation = src.AnnotationValue_ImageBoundingPolyAnnotation
type AnnotationValue_ImageClassificationAnnotation = src.AnnotationValue_ImageClassificationAnnotation
type AnnotationValue_ImagePolylineAnnotation = src.AnnotationValue_ImagePolylineAnnotation
type AnnotationValue_ImageSegmentationAnnotation = src.AnnotationValue_ImageSegmentationAnnotation
type AnnotationValue_TextClassificationAnnotation = src.AnnotationValue_TextClassificationAnnotation
type AnnotationValue_TextEntityExtractionAnnotation = src.AnnotationValue_TextEntityExtractionAnnotation
type AnnotationValue_VideoClassificationAnnotation = src.AnnotationValue_VideoClassificationAnnotation
type AnnotationValue_VideoEventAnnotation = src.AnnotationValue_VideoEventAnnotation
type AnnotationValue_VideoObjectTrackingAnnotation = src.AnnotationValue_VideoObjectTrackingAnnotation

// Records a failed evaluation job run.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type Attempt = src.Attempt

// The BigQuery location for input data. If used in an
// [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob], this is
// where the service saves the prediction input and output sampled from the
// model version.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type BigQuerySource = src.BigQuerySource

// Options regarding evaluation between bounding boxes.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type BoundingBoxEvaluationOptions = src.BoundingBoxEvaluationOptions

// A bounding polygon in the image.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type BoundingPoly = src.BoundingPoly

// Config for image bounding poly (and bounding box) human labeling task.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type BoundingPolyConfig = src.BoundingPolyConfig

// Metadata for classification annotations.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ClassificationMetadata = src.ClassificationMetadata

// Metrics calculated for a classification model.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ClassificationMetrics = src.ClassificationMetrics

// Confusion matrix of the model running the classification. Only applicable
// when the metrics entry aggregates multiple labels. Not applicable when the
// entry is for a single label.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ConfusionMatrix = src.ConfusionMatrix
type ConfusionMatrix_ConfusionMatrixEntry = src.ConfusionMatrix_ConfusionMatrixEntry

// A row in the confusion matrix. Each entry in this row has the same ground
// truth label.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ConfusionMatrix_Row = src.ConfusionMatrix_Row

// Request message for CreateAnnotationSpecSet.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type CreateAnnotationSpecSetRequest = src.CreateAnnotationSpecSetRequest

// Request message for CreateDataset.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type CreateDatasetRequest = src.CreateDatasetRequest

// Request message for CreateEvaluationJob.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type CreateEvaluationJobRequest = src.CreateEvaluationJobRequest

// Metadata of a CreateInstruction operation.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type CreateInstructionMetadata = src.CreateInstructionMetadata

// Request message for CreateInstruction.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type CreateInstructionRequest = src.CreateInstructionRequest

// Deprecated: this instruction format is not supported any more. Instruction
// from a CSV file.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type CsvInstruction = src.CsvInstruction

// DataItem is a piece of data, without annotation. For example, an image.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type DataItem = src.DataItem
type DataItem_ImagePayload = src.DataItem_ImagePayload
type DataItem_TextPayload = src.DataItem_TextPayload
type DataItem_VideoPayload = src.DataItem_VideoPayload

// DataLabelingServiceClient is the client API for DataLabelingService
// service. For semantics around ctx use and closing/ending streaming RPCs,
// please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type DataLabelingServiceClient = src.DataLabelingServiceClient

// DataLabelingServiceServer is the server API for DataLabelingService
// service.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type DataLabelingServiceServer = src.DataLabelingServiceServer
type DataType = src.DataType

// Dataset is the resource to hold your data. You can request multiple
// labeling tasks for a dataset while each one will generate an
// AnnotatedDataset.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type Dataset = src.Dataset

// Request message for DeleteAnnotatedDataset.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type DeleteAnnotatedDatasetRequest = src.DeleteAnnotatedDatasetRequest

// Request message for DeleteAnnotationSpecSet.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type DeleteAnnotationSpecSetRequest = src.DeleteAnnotationSpecSetRequest

// Request message for DeleteDataset.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type DeleteDatasetRequest = src.DeleteDatasetRequest

// Request message DeleteEvaluationJob.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type DeleteEvaluationJobRequest = src.DeleteEvaluationJobRequest

// Request message for DeleteInstruction.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type DeleteInstructionRequest = src.DeleteInstructionRequest

// Describes an evaluation between a machine learning model's predictions and
// ground truth labels. Created when an
// [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob] runs
// successfully.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type Evaluation = src.Evaluation

// Configuration details used for calculating evaluation metrics and creating
// an [Evaluation][google.cloud.datalabeling.v1beta1.Evaluation].
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type EvaluationConfig = src.EvaluationConfig
type EvaluationConfig_BoundingBoxEvaluationOptions = src.EvaluationConfig_BoundingBoxEvaluationOptions

// Defines an evaluation job that runs periodically to generate
// [Evaluations][google.cloud.datalabeling.v1beta1.Evaluation]. [Creating an
// evaluation job](/ml-engine/docs/continuous-evaluation/create-job) is the
// starting point for using continuous evaluation.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type EvaluationJob = src.EvaluationJob

// Provides details for how an evaluation job sends email alerts based on the
// results of a run.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type EvaluationJobAlertConfig = src.EvaluationJobAlertConfig

// Configures specific details of how a continuous evaluation job works.
// Provide this configuration when you create an EvaluationJob.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type EvaluationJobConfig = src.EvaluationJobConfig
type EvaluationJobConfig_BoundingPolyConfig = src.EvaluationJobConfig_BoundingPolyConfig
type EvaluationJobConfig_ImageClassificationConfig = src.EvaluationJobConfig_ImageClassificationConfig
type EvaluationJobConfig_TextClassificationConfig = src.EvaluationJobConfig_TextClassificationConfig

// State of the job.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type EvaluationJob_State = src.EvaluationJob_State
type EvaluationMetrics = src.EvaluationMetrics
type EvaluationMetrics_ClassificationMetrics = src.EvaluationMetrics_ClassificationMetrics
type EvaluationMetrics_ObjectDetectionMetrics = src.EvaluationMetrics_ObjectDetectionMetrics

// Config for video event human labeling task.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type EventConfig = src.EventConfig

// An Example is a piece of data and its annotation. For example, an image
// with label "house".
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type Example = src.Example
type Example_ImagePayload = src.Example_ImagePayload
type Example_TextPayload = src.Example_TextPayload
type Example_VideoPayload = src.Example_VideoPayload

// Metadata of an ExportData operation.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ExportDataOperationMetadata = src.ExportDataOperationMetadata

// Response used for ExportDataset longrunning operation.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ExportDataOperationResponse = src.ExportDataOperationResponse

// Request message for ExportData API.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ExportDataRequest = src.ExportDataRequest

// Export destination of the data.Only gcs path is allowed in output_uri.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type GcsDestination = src.GcsDestination

// Export folder destination of the data.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type GcsFolderDestination = src.GcsFolderDestination

// Source of the Cloud Storage file to be imported.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type GcsSource = src.GcsSource

// Request message for GetAnnotatedDataset.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type GetAnnotatedDatasetRequest = src.GetAnnotatedDatasetRequest

// Request message for GetAnnotationSpecSet.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type GetAnnotationSpecSetRequest = src.GetAnnotationSpecSetRequest

// Request message for GetDataItem.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type GetDataItemRequest = src.GetDataItemRequest

// Request message for GetDataSet.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type GetDatasetRequest = src.GetDatasetRequest

// Request message for GetEvaluationJob.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type GetEvaluationJobRequest = src.GetEvaluationJobRequest

// Request message for GetEvaluation.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type GetEvaluationRequest = src.GetEvaluationRequest

// Request message for GetExample
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type GetExampleRequest = src.GetExampleRequest

// Request message for GetInstruction.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type GetInstructionRequest = src.GetInstructionRequest

// Configuration for how human labeling task should be done.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type HumanAnnotationConfig = src.HumanAnnotationConfig

// Image bounding poly annotation. It represents a polygon including bounding
// box in the image.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ImageBoundingPolyAnnotation = src.ImageBoundingPolyAnnotation
type ImageBoundingPolyAnnotation_BoundingPoly = src.ImageBoundingPolyAnnotation_BoundingPoly
type ImageBoundingPolyAnnotation_NormalizedBoundingPoly = src.ImageBoundingPolyAnnotation_NormalizedBoundingPoly

// Image classification annotation definition.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ImageClassificationAnnotation = src.ImageClassificationAnnotation

// Config for image classification human labeling task.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ImageClassificationConfig = src.ImageClassificationConfig

// Container of information about an image.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ImagePayload = src.ImagePayload

// A polyline for the image annotation.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ImagePolylineAnnotation = src.ImagePolylineAnnotation
type ImagePolylineAnnotation_NormalizedPolyline = src.ImagePolylineAnnotation_NormalizedPolyline
type ImagePolylineAnnotation_Polyline = src.ImagePolylineAnnotation_Polyline

// Image segmentation annotation.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ImageSegmentationAnnotation = src.ImageSegmentationAnnotation

// Metadata of an ImportData operation.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ImportDataOperationMetadata = src.ImportDataOperationMetadata

// Response used for ImportData longrunning operation.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ImportDataOperationResponse = src.ImportDataOperationResponse

// Request message for ImportData API.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ImportDataRequest = src.ImportDataRequest

// The configuration of input data, including data type, location, etc.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type InputConfig = src.InputConfig
type InputConfig_BigquerySource = src.InputConfig_BigquerySource
type InputConfig_GcsSource = src.InputConfig_GcsSource
type InputConfig_TextMetadata = src.InputConfig_TextMetadata

// Instruction of how to perform the labeling task for human operators.
// Currently only PDF instruction is supported.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type Instruction = src.Instruction

// Details of a LabelImageBoundingBox operation metadata.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type LabelImageBoundingBoxOperationMetadata = src.LabelImageBoundingBoxOperationMetadata

// Details of LabelImageBoundingPoly operation metadata.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type LabelImageBoundingPolyOperationMetadata = src.LabelImageBoundingPolyOperationMetadata

// Metadata of a LabelImageClassification operation.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type LabelImageClassificationOperationMetadata = src.LabelImageClassificationOperationMetadata

// Details of a LabelImageOrientedBoundingBox operation metadata.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type LabelImageOrientedBoundingBoxOperationMetadata = src.LabelImageOrientedBoundingBoxOperationMetadata

// Details of LabelImagePolyline operation metadata.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type LabelImagePolylineOperationMetadata = src.LabelImagePolylineOperationMetadata

// Request message for starting an image labeling task.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type LabelImageRequest = src.LabelImageRequest
type LabelImageRequest_BoundingPolyConfig = src.LabelImageRequest_BoundingPolyConfig

// Image labeling task feature.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type LabelImageRequest_Feature = src.LabelImageRequest_Feature
type LabelImageRequest_ImageClassificationConfig = src.LabelImageRequest_ImageClassificationConfig
type LabelImageRequest_PolylineConfig = src.LabelImageRequest_PolylineConfig
type LabelImageRequest_SegmentationConfig = src.LabelImageRequest_SegmentationConfig

// Details of a LabelImageSegmentation operation metadata.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type LabelImageSegmentationOperationMetadata = src.LabelImageSegmentationOperationMetadata

// Metadata of a labeling operation, such as LabelImage or LabelVideo. Next
// tag: 20
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type LabelOperationMetadata = src.LabelOperationMetadata
type LabelOperationMetadata_ImageBoundingBoxDetails = src.LabelOperationMetadata_ImageBoundingBoxDetails
type LabelOperationMetadata_ImageBoundingPolyDetails = src.LabelOperationMetadata_ImageBoundingPolyDetails
type LabelOperationMetadata_ImageClassificationDetails = src.LabelOperationMetadata_ImageClassificationDetails
type LabelOperationMetadata_ImageOrientedBoundingBoxDetails = src.LabelOperationMetadata_ImageOrientedBoundingBoxDetails
type LabelOperationMetadata_ImagePolylineDetails = src.LabelOperationMetadata_ImagePolylineDetails
type LabelOperationMetadata_ImageSegmentationDetails = src.LabelOperationMetadata_ImageSegmentationDetails
type LabelOperationMetadata_TextClassificationDetails = src.LabelOperationMetadata_TextClassificationDetails
type LabelOperationMetadata_TextEntityExtractionDetails = src.LabelOperationMetadata_TextEntityExtractionDetails
type LabelOperationMetadata_VideoClassificationDetails = src.LabelOperationMetadata_VideoClassificationDetails
type LabelOperationMetadata_VideoEventDetails = src.LabelOperationMetadata_VideoEventDetails
type LabelOperationMetadata_VideoObjectDetectionDetails = src.LabelOperationMetadata_VideoObjectDetectionDetails
type LabelOperationMetadata_VideoObjectTrackingDetails = src.LabelOperationMetadata_VideoObjectTrackingDetails

// Statistics about annotation specs.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type LabelStats = src.LabelStats

// Details of a LabelTextClassification operation metadata.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type LabelTextClassificationOperationMetadata = src.LabelTextClassificationOperationMetadata

// Details of a LabelTextEntityExtraction operation metadata.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type LabelTextEntityExtractionOperationMetadata = src.LabelTextEntityExtractionOperationMetadata

// Request message for LabelText.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type LabelTextRequest = src.LabelTextRequest

// Text labeling task feature.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type LabelTextRequest_Feature = src.LabelTextRequest_Feature
type LabelTextRequest_TextClassificationConfig = src.LabelTextRequest_TextClassificationConfig
type LabelTextRequest_TextEntityExtractionConfig = src.LabelTextRequest_TextEntityExtractionConfig

// Details of a LabelVideoClassification operation metadata.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type LabelVideoClassificationOperationMetadata = src.LabelVideoClassificationOperationMetadata

// Details of a LabelVideoEvent operation metadata.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type LabelVideoEventOperationMetadata = src.LabelVideoEventOperationMetadata

// Details of a LabelVideoObjectDetection operation metadata.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type LabelVideoObjectDetectionOperationMetadata = src.LabelVideoObjectDetectionOperationMetadata

// Details of a LabelVideoObjectTracking operation metadata.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type LabelVideoObjectTrackingOperationMetadata = src.LabelVideoObjectTrackingOperationMetadata

// Request message for LabelVideo.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type LabelVideoRequest = src.LabelVideoRequest
type LabelVideoRequest_EventConfig = src.LabelVideoRequest_EventConfig

// Video labeling task feature.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type LabelVideoRequest_Feature = src.LabelVideoRequest_Feature
type LabelVideoRequest_ObjectDetectionConfig = src.LabelVideoRequest_ObjectDetectionConfig
type LabelVideoRequest_ObjectTrackingConfig = src.LabelVideoRequest_ObjectTrackingConfig
type LabelVideoRequest_VideoClassificationConfig = src.LabelVideoRequest_VideoClassificationConfig

// Request message for ListAnnotatedDatasets.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ListAnnotatedDatasetsRequest = src.ListAnnotatedDatasetsRequest

// Results of listing annotated datasets for a dataset.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ListAnnotatedDatasetsResponse = src.ListAnnotatedDatasetsResponse

// Request message for ListAnnotationSpecSets.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ListAnnotationSpecSetsRequest = src.ListAnnotationSpecSetsRequest

// Results of listing annotation spec set under a project.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ListAnnotationSpecSetsResponse = src.ListAnnotationSpecSetsResponse

// Request message for ListDataItems.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ListDataItemsRequest = src.ListDataItemsRequest

// Results of listing data items in a dataset.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ListDataItemsResponse = src.ListDataItemsResponse

// Request message for ListDataset.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ListDatasetsRequest = src.ListDatasetsRequest

// Results of listing datasets within a project.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ListDatasetsResponse = src.ListDatasetsResponse

// Request message for ListEvaluationJobs.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ListEvaluationJobsRequest = src.ListEvaluationJobsRequest

// Results for listing evaluation jobs.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ListEvaluationJobsResponse = src.ListEvaluationJobsResponse

// Request message for ListExamples.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ListExamplesRequest = src.ListExamplesRequest

// Results of listing Examples in and annotated dataset.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ListExamplesResponse = src.ListExamplesResponse

// Request message for ListInstructions.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ListInstructionsRequest = src.ListInstructionsRequest

// Results of listing instructions under a project.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ListInstructionsResponse = src.ListInstructionsResponse

// Normalized bounding polygon.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type NormalizedBoundingPoly = src.NormalizedBoundingPoly

// Normalized polyline.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type NormalizedPolyline = src.NormalizedPolyline

// A vertex represents a 2D point in the image. NOTE: the normalized vertex
// coordinates are relative to the original image and range from 0 to 1.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type NormalizedVertex = src.NormalizedVertex

// Config for video object detection human labeling task. Object detection
// will be conducted on the images extracted from the video, and those objects
// will be labeled with bounding boxes. User need to specify the number of
// images to be extracted per second as the extraction frame rate.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ObjectDetectionConfig = src.ObjectDetectionConfig

// Metrics calculated for an image object detection (bounding box) model.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ObjectDetectionMetrics = src.ObjectDetectionMetrics

// Config for video object tracking human labeling task.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ObjectTrackingConfig = src.ObjectTrackingConfig

// Video frame level annotation for object detection and tracking.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ObjectTrackingFrame = src.ObjectTrackingFrame
type ObjectTrackingFrame_BoundingPoly = src.ObjectTrackingFrame_BoundingPoly
type ObjectTrackingFrame_NormalizedBoundingPoly = src.ObjectTrackingFrame_NormalizedBoundingPoly

// General information useful for labels coming from contributors.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type OperatorMetadata = src.OperatorMetadata

// The configuration of output data.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type OutputConfig = src.OutputConfig
type OutputConfig_GcsDestination = src.OutputConfig_GcsDestination
type OutputConfig_GcsFolderDestination = src.OutputConfig_GcsFolderDestination

// Request message for PauseEvaluationJob.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type PauseEvaluationJobRequest = src.PauseEvaluationJobRequest

// Instruction from a PDF file.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type PdfInstruction = src.PdfInstruction

// A line with multiple line segments.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type Polyline = src.Polyline

// Config for image polyline human labeling task.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type PolylineConfig = src.PolylineConfig
type PrCurve = src.PrCurve
type PrCurve_ConfidenceMetricsEntry = src.PrCurve_ConfidenceMetricsEntry

// Request message ResumeEvaluationJob.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type ResumeEvaluationJobRequest = src.ResumeEvaluationJobRequest

// Request message for SearchEvaluation.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type SearchEvaluationsRequest = src.SearchEvaluationsRequest

// Results of searching evaluations.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type SearchEvaluationsResponse = src.SearchEvaluationsResponse

// Request message of SearchExampleComparisons.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type SearchExampleComparisonsRequest = src.SearchExampleComparisonsRequest

// Results of searching example comparisons.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type SearchExampleComparisonsResponse = src.SearchExampleComparisonsResponse

// Example comparisons comparing ground truth output and predictions for a
// specific input.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type SearchExampleComparisonsResponse_ExampleComparison = src.SearchExampleComparisonsResponse_ExampleComparison

// Config for image segmentation
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type SegmentationConfig = src.SegmentationConfig

// Config for setting up sentiments.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type SentimentConfig = src.SentimentConfig

// Start and end position in a sequence (e.g. text segment).
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type SequentialSegment = src.SequentialSegment
type StringAggregationType = src.StringAggregationType

// Text classification annotation.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type TextClassificationAnnotation = src.TextClassificationAnnotation

// Config for text classification human labeling task.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type TextClassificationConfig = src.TextClassificationConfig

// Text entity extraction annotation.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type TextEntityExtractionAnnotation = src.TextEntityExtractionAnnotation

// Config for text entity extraction human labeling task.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type TextEntityExtractionConfig = src.TextEntityExtractionConfig

// Metadata for the text.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type TextMetadata = src.TextMetadata

// Container of information about a piece of text.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type TextPayload = src.TextPayload

// A time period inside of an example that has a time dimension (e.g. video).
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type TimeSegment = src.TimeSegment

// UnimplementedDataLabelingServiceServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type UnimplementedDataLabelingServiceServer = src.UnimplementedDataLabelingServiceServer

// Request message for UpdateEvaluationJob.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type UpdateEvaluationJobRequest = src.UpdateEvaluationJobRequest

// A vertex represents a 2D point in the image. NOTE: the vertex coordinates
// are in the same scale as the original image.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type Vertex = src.Vertex

// Video classification annotation.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type VideoClassificationAnnotation = src.VideoClassificationAnnotation

// Config for video classification human labeling task. Currently two types of
// video classification are supported: 1. Assign labels on the entire video. 2.
// Split the video into multiple video clips based on camera shot, and assign
// labels on each video clip.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type VideoClassificationConfig = src.VideoClassificationConfig

// Annotation spec set with the setting of allowing multi labels or not.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type VideoClassificationConfig_AnnotationSpecSetConfig = src.VideoClassificationConfig_AnnotationSpecSetConfig

// Video event annotation.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type VideoEventAnnotation = src.VideoEventAnnotation

// Video object tracking annotation.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type VideoObjectTrackingAnnotation = src.VideoObjectTrackingAnnotation

// Container of information of a video.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type VideoPayload = src.VideoPayload

// Container of information of a video thumbnail.
//
// Deprecated: Please use types in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
type VideoThumbnail = src.VideoThumbnail

// Deprecated: Please use funcs in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
func NewDataLabelingServiceClient(cc grpc.ClientConnInterface) DataLabelingServiceClient {
	return src.NewDataLabelingServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb
func RegisterDataLabelingServiceServer(s *grpc.Server, srv DataLabelingServiceServer) {
	src.RegisterDataLabelingServiceServer(s, srv)
}
