package transform

import (
	"strings"

	"github.com/vulncheck-oss/go-exploit/output"
)

// Provided a command param that includes args such as "cmd.exe /c whoami" as one might receive from a a user provided flag like
// -command , this function would return "cmd.exe", "/c whoami", true.
//
//	program, args, ok := transform.ParseCommand(command)
func ParseCommand(command string) (string, string, bool) {
	sCommand := strings.SplitN(command, " ", 2)
	if sCommand == nil {
		output.PrintFrameworkError("Invalid command provided, should be space-separated with program and then args in front. examples: cmd.exe /c someargs or bash -c someargs")

		return "", "", false
	}

	if len(sCommand) != 2 {
		output.PrintFrameworkError("Invalid command provided, should be space-separated with program and then args in front. examples: cmd.exe /c someargs or bash -c someargs")

		return "", "", false
	}

	return sCommand[0], sCommand[1], true
}
